/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jcsmp.DestinationUtils;
import com.solacesystems.jcsmp.DurableTopicEndpoint;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.transaction.TransactedSession;
import com.solacesystems.jms.ConfigurationException;
import com.solacesystems.jms.SolConnectionConsumerIF;
import com.solacesystems.jms.SolConnectionConsumerRA;
import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolMessageConsumerIF;
import com.solacesystems.jms.SolMessageProducer;
import com.solacesystems.jms.SolMessageProducerIF;
import com.solacesystems.jms.SolQueueBrowser;
import com.solacesystems.jms.SolQueueBrowserIF;
import com.solacesystems.jms.SolQueueReceiver;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.SolTemporaryQueue;
import com.solacesystems.jms.SolTemporaryQueueIF;
import com.solacesystems.jms.SolTemporaryTopic;
import com.solacesystems.jms.SolTemporaryTopicIF;
import com.solacesystems.jms.SolTopicSubscriber;
import com.solacesystems.jms.impl.AckHandler;
import com.solacesystems.jms.impl.JCSMPDispatcher;
import com.solacesystems.jms.impl.JCSMPTransactedSession;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.MessageAckHandlerImpl;
import com.solacesystems.jms.impl.SessionConnectionConsumerSupport;
import com.solacesystems.jms.impl.SessionConnectionConsumerSupportRA;
import com.solacesystems.jms.impl.SessionProperties;
import com.solacesystems.jms.impl.SessionTransactionType;
import com.solacesystems.jms.impl.SessionUserProperty;
import com.solacesystems.jms.impl.SolCollections;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.SolQueueImpl;
import com.solacesystems.jms.impl.SolTopicImpl;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.message.SolBytesMessage;
import com.solacesystems.jms.message.SolMapMessage;
import com.solacesystems.jms.message.SolMessage;
import com.solacesystems.jms.message.SolObjectMessage;
import com.solacesystems.jms.message.SolStreamMessage;
import com.solacesystems.jms.message.SolTextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolSession
implements SolSessionIF,
AckHandler {
    private static final String Component = "Session";
    private static final Log log = LogFactory.getLog(SolSession.class);
    protected SolConnectionIF mConnection;
    protected SessionProperties mSessionProps;
    protected ArrayList<SolMessageConsumerIF> mConsumers;
    protected ArrayList<SolMessageProducerIF> mProducers;
    protected ArrayList<SolQueueBrowserIF> mQueueBrowsers;
    protected JMSState mState;
    protected int mAcknowledgeMode;
    protected Object mLock;
    protected Object mStopLock;
    protected TransactedSession mTransactedSession;
    protected AckHandler mAckHandler;
    protected int mSessionId;
    protected MessageListener mDistinguishedListener;
    public SessionConnectionConsumerSupportRA mConnectionConsumerSupportRA;
    public SessionConnectionConsumerSupport mConnectionConsumerSupport;
    private static int ID = 0;

    private static synchronized int getID() {
        return ++ID;
    }

    SolSession(SolConnectionIF connection, boolean transacted, int acknowledgeMode, JMSState state) throws JMSException {
        this.mConnection = connection;
        this.mAcknowledgeMode = transacted ? 0 : acknowledgeMode;
        this.mAckHandler = new MessageAckHandlerImpl(this.mAcknowledgeMode);
        this.mSessionProps = new SessionProperties(connection.getProperties(), transacted ? SessionTransactionType.LocalTransaction : SessionTransactionType.NoTransaction, acknowledgeMode, this);
        this.mConsumers = new ArrayList();
        this.mProducers = new ArrayList();
        this.mQueueBrowsers = new ArrayList();
        this.mState = state;
        if (transacted) {
            try {
                this.mTransactedSession = connection.getProperties().getJCSMPSession().createTransactedSession();
                this.mSessionProps.getUserProperties().put("TransactedSession", new JCSMPTransactedSession(this.mTransactedSession));
            }
            catch (JCSMPException e) {
                throw Validator.createJMSException("soljms.operation.session.create", (Throwable)((Object)e));
            }
        } else {
            this.mTransactedSession = null;
        }
        this.mLock = new Object();
        this.mStopLock = new Object();
        this.mLock = new Object();
        this.mSessionId = SolSession.getID();
        if (!this.mSessionProps.getConnectionProperties().getPropertyBean().getCallbackOnDispatcherThread().booleanValue() && !this.mSessionProps.getConnectionProperties().getPropertyBean().getCallbackOnIOThread().booleanValue()) {
            ContextImpl ctxImpl = (ContextImpl)this.mSessionProps.getConnectionProperties().getContext();
            String name = String.format("%d_jms_%d", ctxImpl.getContextId(), this.mSessionId);
            this.mSessionProps.getUserProperties().put("ConsumerDispatcherFactory", new JCSMPDispatcher(name));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SolSession created.  Transacted: " + transacted + "  acknowledgeMode: " + this.mAcknowledgeMode + "   state: " + (Object)((Object)state)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        SolSession solSession = this;
        synchronized (solSession) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entering close(), sessionId: " + this.mSessionId));
            }
            if (this.mState != JMSState.Closed) {
                SolCollections.closeAll(new ArrayList<SolMessageConsumerIF>(this.mConsumers));
                this.mConsumers.clear();
                SolCollections.closeAll(new ArrayList<SolMessageProducerIF>(this.mProducers));
                this.mProducers.clear();
                SolCollections.closeAll(new ArrayList<SolQueueBrowserIF>(this.mQueueBrowsers));
                this.mQueueBrowsers.clear();
                Iterator<SessionUserProperty> it = this.mSessionProps.getUserProperties().values().iterator();
                while (it.hasNext()) {
                    it.next().onClose();
                }
                this.mDistinguishedListener = null;
                if (this.mConnectionConsumerSupportRA != null) {
                    this.mConnectionConsumerSupportRA.close();
                }
                if (this.mConnectionConsumerSupport != null) {
                    this.mConnectionConsumerSupport.close();
                    this.mConnectionConsumerSupport = null;
                }
                this.mState = JMSState.Closed;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Leaving close() : SolSession closed, sessionId " + this.mSessionId));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Leaving close() : close() called while SolSession was already closed.");
            }
        }
        this.mConnection.remove(this);
    }

    public void commit() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering commit().");
        }
        Validator.checkClosed(this.mState, Component);
        log.debug((Object)String.format("checkTransacted, sessionTransactionType:%s ackMode:%s", new Object[]{this.mSessionProps.getTransactionType(), this.mAcknowledgeMode}));
        Validator.checkTransacted(this.mSessionProps.getTransactionType(), "soljms.operation.session.commit");
        if (this.mConnectionConsumerSupport != null) {
            this.mConnectionConsumerSupport.commit();
        } else {
            try {
                this.mTransactedSession.commit();
            }
            catch (JCSMPException e) {
                throw Validator.createJMSException("soljms.operation.session.commit", (Throwable)((Object)e));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving commit().");
        }
    }

    public void rollback() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering rollback()");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkTransacted(this.mSessionProps.getTransactionType(), "soljms.operation.session.rollback");
        if (this.mConnectionConsumerSupport != null) {
            this.mConnectionConsumerSupport.rollback();
        } else {
            try {
                this.mTransactedSession.rollback();
            }
            catch (JCSMPException e) {
                throw Validator.createJMSException("soljms.operation.session.rollback", (Throwable)((Object)e));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving rollback()");
        }
    }

    public synchronized void recover() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering recover()");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkNotTransacted(this.mSessionProps.getTransactionType(), "soljms.operation.recover");
        if (this.mConnectionConsumerSupportRA != null) {
            throw new ConfigurationException("recover() call is unsupported with ConnectionConsumers");
        }
        if (this.mConnectionConsumerSupport != null) {
            this.mConnectionConsumerSupport.recover();
            return;
        }
        if (this.mAcknowledgeMode == 2) {
            this.mAckHandler.clearUnackedList();
        }
        for (int index = this.mConsumers.size() - 1; index >= 0; --index) {
            try {
                this.mConsumers.get(index).recover();
                continue;
            }
            catch (IllegalStateException e) {
                if ("soljms.error.closed".equals(e.getErrorCode())) {
                    this.mConsumers.remove(index);
                    continue;
                }
                throw Validator.createJMSException("soljms.operation.recover", e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving recover()");
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mDistinguishedListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.mDistinguishedListener = listener;
    }

    public synchronized void loadMessages(Collection<Message> messages, SolConnectionConsumerRA consumer) throws JMSException {
        if (this.mConnectionConsumerSupportRA == null) {
            this.mConnectionConsumerSupportRA = new SessionConnectionConsumerSupportRA(this, consumer);
        } else if (this.mConnectionConsumerSupportRA.updateParent(consumer)) {
            log.error((Object)"Parent session has unexpectedly changed for the ConnectionConsumer support session!");
        }
        this.mConnectionConsumerSupportRA.setMessageListener(this.mDistinguishedListener);
        this.mConnectionConsumerSupportRA.loadMessages(messages);
    }

    public synchronized void loadFromConnectionConsumer(Collection<Message> messages, SolConnectionConsumerIF consumer) {
        this.mConnectionConsumerSupport = new SessionConnectionConsumerSupport(this.mAcknowledgeMode, consumer);
        this.mConnectionConsumerSupport.setMessageListener(this.mDistinguishedListener);
        this.mConnectionConsumerSupport.loadMessages(messages);
    }

    public void run() {
        if (this.mConnectionConsumerSupportRA != null) {
            this.mConnectionConsumerSupportRA.run();
        } else if (this.mConnectionConsumerSupport != null) {
            this.mConnectionConsumerSupport.run();
        }
    }

    @Override
    public List<SolMessageConsumerIF> getConsumers() {
        return this.mConsumers;
    }

    @Override
    public List<SolMessageProducerIF> getProducers() {
        return this.mProducers;
    }

    public synchronized QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public synchronized QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        Validator.checkClosed(this.mState, Component);
        if (log.isDebugEnabled()) {
            log.debug((Object)"createBrowser() called.");
        }
        return new SolQueueBrowser(this, queue, messageSelector);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return new SolBytesMessage();
    }

    public synchronized MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    public synchronized MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    public synchronized MessageConsumer createConsumer(Destination destination, String messageSelector, boolean NoLocal) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering createConsumer(). Destination: " + (destination == null ? "null" : destination.toString()) + "  messageSelector: " + messageSelector + "  NoLocal: " + NoLocal));
        }
        Validator.checkClosed(this.mState, Component);
        if (destination instanceof Queue) {
            Validator.checkConsumerDestination(destination, this.mConnection);
            Queue queue = (Queue)destination;
            SolQueueReceiver rcvr = new SolQueueReceiver(this, queue, messageSelector, NoLocal, this.mState);
            this.mConsumers.add(rcvr);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Leaving createConsumer() : Consumer created (Queue).");
            }
            return rcvr;
        }
        Validator.checkConsumerTopicDestination(destination, this.mConnection, false);
        Topic topic = (Topic)destination;
        SolTopicSubscriber cons = new SolTopicSubscriber((SolSessionIF)this, topic, messageSelector, NoLocal, null, this.mState);
        this.mConsumers.add(cons);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createConsumer() : Consumer created (Topic).");
        }
        return cons;
    }

    public synchronized TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public synchronized TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering createDurableSubscriber().  Topic: " + (topic == null ? "null" : topic.getTopicName()) + "  Name: " + name + "  messageSelector: " + messageSelector + "  noLocal: " + noLocal));
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkConsumerTopicDestination((Destination)topic, this.mConnection, true);
        Validator.checkSubscriptionName(name);
        if (this.mSessionProps.getConnectionProperties().getPropertyBean().getDynamicDurables().booleanValue()) {
            EndpointProperties endpointProps = new EndpointProperties();
            endpointProps.setRespectsMsgTTL(this.mSessionProps.getConnectionProperties().getPropertyBean().getRespectTTL());
            try {
                this.mSessionProps.getConnectionProperties().getJCSMPSession().provision(JCSMPFactory.onlyInstance().createDurableTopicEndpoint(name), endpointProps, 1L);
            }
            catch (JCSMPException e) {
                throw Validator.createJMSException("soljms.operation.consumer.create", (Throwable)((Object)e));
            }
        }
        SolTopicSubscriber sub = new SolTopicSubscriber((SolSessionIF)this, topic, messageSelector, noLocal, name, this.mState);
        this.mConsumers.add(sub);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createDurableSubscriber()");
        }
        return sub;
    }

    public MapMessage createMapMessage() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return new SolMapMessage();
    }

    public Message createMessage() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return new SolMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return new SolObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        Validator.checkClosed(this.mState, Component);
        SolObjectMessage objMsg = new SolObjectMessage();
        objMsg.setObject(object);
        return objMsg;
    }

    public synchronized MessageProducer createProducer(Destination destination) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering createProducer()");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkProducerDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), destination);
        SolMessageProducer prod = new SolMessageProducer(this, destination);
        this.mProducers.add(prod);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createProducer()");
        }
        return prod;
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering createQueue()");
        }
        Validator.checkClosed(this.mState, Component);
        SolQueueImpl queue = new SolQueueImpl((com.solacesystems.jcsmp.Queue)DestinationUtils.onlyInstance().queueFromEncodedName(queueName));
        if (this.mSessionProps.getConnectionProperties().getPropertyBean().getDynamicDurables().booleanValue()) {
            EndpointProperties endpointProps = new EndpointProperties();
            if (!queueName.equals(this.mSessionProps.getConnectionProperties().getPropertyBean().getDeadMessageQueueName())) {
                endpointProps.setRespectsMsgTTL(this.mSessionProps.getConnectionProperties().getPropertyBean().getRespectTTL());
            }
            try {
                this.mSessionProps.getConnectionProperties().getJCSMPSession().provision(queue.getJCSMPQueue(), endpointProps, 1L);
            }
            catch (JCSMPException e) {
                throw Validator.createJMSException("soljms.operation.queue.create", (Throwable)((Object)e));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createQueue()");
        }
        return queue;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return new SolStreamMessage();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        try {
            return new SolTemporaryQueue(this.mConnection, this.mSessionProps.getConnectionProperties().getJCSMPSession().createTemporaryQueue());
        }
        catch (JCSMPException e) {
            throw Validator.createJMSException("soljms.operation.temp.queue.create", (Throwable)((Object)e));
        }
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        try {
            return new SolTemporaryTopic(this.mConnection, this.mSessionProps.getConnectionProperties().getJCSMPSession().createTemporaryTopic());
        }
        catch (JCSMPException e) {
            throw Validator.createJMSException("soljms.operation.temp.topic.create", (Throwable)((Object)e));
        }
    }

    public TextMessage createTextMessage() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return new SolTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        Validator.checkClosed(this.mState, Component);
        SolTextMessage textMsg = new SolTextMessage();
        textMsg.setText(text);
        return textMsg;
    }

    public Topic createTopic(String topicName) throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return new SolTopicImpl((com.solacesystems.jcsmp.Topic)DestinationUtils.onlyInstance().topicFromEncodedName(topicName));
    }

    public int getAcknowledgeMode() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mAcknowledgeMode;
    }

    public boolean getTransacted() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mSessionProps.getTransactionType() != SessionTransactionType.NoTransaction;
    }

    public void unsubscribe(String name) throws JMSException {
        Validator.checkClosed(this.mState, Component);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering unsubscribe");
        }
        try {
            DurableTopicEndpoint dte = JCSMPFactory.onlyInstance().createDurableTopicEndpoint(name);
            this.mSessionProps.getConnectionProperties().getJCSMPSession().unsubscribeDurableTopicEndpoint(dte);
            if (this.mSessionProps.getConnectionProperties().getPropertyBean().getDynamicDurables().booleanValue()) {
                this.mSessionProps.getConnectionProperties().getJCSMPSession().deprovision(dte, 2L);
            }
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("client(s) bound to DTE") != -1) {
                throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.unsubscribe", "soljms.error.illegalstate", e.getMessage()), "soljms.error.illegalstate");
            }
            throw Validator.createJMSException("soljms.operation.unsubscribe", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Leaving unsubscribe.  Unsubscribed from " + name));
        }
    }

    @Override
    public synchronized void start() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        if (this.mState == JMSState.Stopped) {
            for (int index = this.mConsumers.size() - 1; index >= 0; --index) {
                try {
                    this.mConsumers.get(index).start();
                    continue;
                }
                catch (IllegalStateException e) {
                    if ("soljms.error.closed".equals(e.getErrorCode())) {
                        this.mConsumers.remove(index);
                        continue;
                    }
                    throw Validator.createJMSException("soljms.operation.start", e);
                }
            }
            this.mState = JMSState.Started;
            if (log.isInfoEnabled()) {
                log.info((Object)"SolSession started.");
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"SolSession already started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws JMSException {
        Object object = this.mStopLock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entering SolSession.stop() threadId=" + Thread.currentThread().getId()));
            }
            Validator.checkClosed(this.mState, Component);
            if (this.mState == JMSState.Started) {
                ArrayList<SolMessageConsumerIF> stopStartedConsumers = this.stopSyncStart();
                for (int index = 0; index < stopStartedConsumers.size(); ++index) {
                    try {
                        stopStartedConsumers.get(index).stopSyncWait();
                        continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                this.mState = JMSState.Stopped;
                if (log.isInfoEnabled()) {
                    log.info((Object)"SolSession stopped.");
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)"SolSession already stopped.");
            }
        }
    }

    private synchronized ArrayList<SolMessageConsumerIF> stopSyncStart() throws JMSException {
        ArrayList<SolMessageConsumerIF> stopStartedConsumers = new ArrayList<SolMessageConsumerIF>();
        this.mState = JMSState.Stopping;
        for (int index = 0; index < this.mConsumers.size(); ++index) {
            try {
                if (!this.mConsumers.get(index).stopSyncStart()) continue;
                stopStartedConsumers.add(this.mConsumers.get(index));
                continue;
            }
            catch (IllegalStateException e) {
                if ("soljms.error.closed".equals(e.getErrorCode())) {
                    this.mConsumers.remove(index);
                    continue;
                }
                throw Validator.createJMSException("soljms.operation.stop", e);
            }
        }
        return stopStartedConsumers;
    }

    @Override
    public synchronized boolean isTemporaryQueueUsed(SolTemporaryQueueIF queue) {
        if (this.mState != JMSState.Closed) {
            for (int i = 0; i < this.mConsumers.size(); ++i) {
                if (!this.mConsumers.get(i).isTemporaryQueueUsed(queue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean isTemporaryTopicUsed(SolTemporaryTopicIF topic) {
        if (this.mState != JMSState.Closed) {
            for (int i = 0; i < this.mConsumers.size(); ++i) {
                if (!this.mConsumers.get(i).isTemporaryTopicUsed(topic)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public SessionProperties getProperties() {
        return this.mSessionProps;
    }

    @Override
    public void createDefaultSubscriber() throws JCSMPException {
        this.mConnection.createDefaultSubscriber();
    }

    @Override
    public synchronized void remove(SolMessageConsumerIF consumer) {
        for (int index = this.mConsumers.size() - 1; index >= 0; --index) {
            if (this.mConsumers.get(index) != consumer) continue;
            this.mConsumers.remove(index);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"SolMessageConsumerIF removed");
        }
    }

    @Override
    public synchronized void remove(SolMessageProducerIF producer) {
        for (int index = this.mProducers.size() - 1; index >= 0; --index) {
            if (this.mProducers.get(index) != producer) continue;
            this.mProducers.remove(index);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"SolMessageProducer removed");
        }
    }

    @Override
    public synchronized void remove(SolQueueBrowserIF browser) {
        for (int index = this.mQueueBrowsers.size() - 1; index >= 0; --index) {
            if (this.mQueueBrowsers.get(index) != browser) continue;
            this.mQueueBrowsers.remove(index);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"SolQueueBrowser removed");
        }
    }

    @Override
    public String getName() {
        if (this.mTransactedSession != null) {
            return this.mTransactedSession.getName();
        }
        return null;
    }

    @Override
    public void cancelSends(JCSMPException e) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering cancelSends(), sessionID: " + this.mSessionId + "; numProducers: " + this.mProducers.size()));
        }
        for (int i = 0; i < this.mProducers.size(); ++i) {
            this.mProducers.get(i).cancel(e);
        }
    }

    @Override
    public SolConnectionIF getConnection() {
        return this.mConnection;
    }

    @Override
    public JMSState getState() {
        return this.mState;
    }

    @Override
    public void onMessageCreate(SolMessage message) {
        message.setAckHandler(this);
        this.mAckHandler.onMessageCreate(message);
    }

    @Override
    public void onMessageSent(SolMessage message) throws JMSException {
        this.mAckHandler.onMessageSent(message);
    }

    @Override
    public void acknowledge(SolMessage message) throws JMSException {
        Validator.checkClosed(this.mState, Component);
        this.mAckHandler.acknowledge(message);
    }

    @Override
    public void clearUnackedList() {
        this.mAckHandler.clearUnackedList();
    }
}

