/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.property;

import com.solacesystems.common.property.Property;
import com.solacesystems.common.property.PropertyBeanGenerator;
import com.solacesystems.common.property.PropertyConversionException;
import com.solacesystems.common.property.PropertySource;
import com.solacesystems.common.property.PropertyVetoException;
import com.solacesystems.common.property.impl.MapPropertySource;
import com.solacesystems.common.property.impl.SystemPropertySource;
import com.solacesystems.common.property.impl.ValueOfConverter;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jms.property.AuthenticationSchemeValidator;
import com.solacesystems.jms.property.DeliveryModeConverter;
import com.solacesystems.jms.property.JMSProperty;
import com.solacesystems.jms.property.URLToHostlistConverter;
import com.solacesystems.jms.property.URLToPasswordConverter;
import com.solacesystems.jms.property.URLToUsernameConverter;
import com.solacesystems.jms.property.UsernameConverter;
import com.solacesystems.jms.property.UsernameToVPNConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSProperties
implements Cloneable {
    private static final Log log = LogFactory.getLog(JMSProperties.class);
    public static final String CONNECTION_FACTORY_SOURCE = "Connection Factory";
    public static final String INITIAL_CONTEXT_SOURCE = "Initial Context Environment";
    public static final String JMS_API_SOURCE = "JMS API";
    public static final String JNDI_CONNECTION_SOURCE = "JNDI Connection";
    public static final String URL_SOURCE = "URL";
    private static final ValueOfConverter boolCvtr = ValueOfConverter.getConverter(Boolean.class);
    private static final ValueOfConverter intCvtr = ValueOfConverter.getConverter(Integer.class);
    private static final UsernameConverter usernameCvtr = new UsernameConverter();
    private static final UsernameToVPNConverter usernameToVpnCvtr = new UsernameToVPNConverter();
    protected Hashtable<?, ?> mEnvironment;
    protected Map<String, Property<?>> mProperties;

    public JMSProperties(JMSProperties props) {
        this.mEnvironment = props.mEnvironment;
        this.mProperties = new TreeMap();
        Iterator<Property<?>> it = props.mProperties.values().iterator();
        while (it.hasNext()) {
            try {
                Property p = (Property)it.next().clone();
                this.mProperties.put(p.getId(), p);
            }
            catch (CloneNotSupportedException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"error in copy Constructor", (Throwable)e);
            }
        }
    }

    public JMSProperties(Hashtable<?, ?> environment) throws Exception {
        this.mEnvironment = environment;
        this.mProperties = new TreeMap();
        this.createProperties();
        this.createSources();
    }

    private void createProperties() {
        JCSMPProperties jcsmpDefaults = new JCSMPProperties();
        JCSMPChannelProperties jcsmpChannelDefaults = new JCSMPChannelProperties();
        this.mProperties.put(JMSProperty.AuthenticationScheme.toString(), new Property<String>((Object)JMSProperty.AuthenticationScheme, jcsmpDefaults.getStringProperty("AUTHENTICATION_SCHEME")));
        this.mProperties.put(JMSProperty.BrowserTimeoutInMS.toString(), new Property<Integer>((Object)JMSProperty.BrowserTimeoutInMS, -1));
        this.mProperties.put(JMSProperty.CallbackOnDispatcherThread.toString(), new Property<Boolean>((Object)JMSProperty.CallbackOnDispatcherThread, false));
        this.mProperties.put(JMSProperty.CallbackOnIOThread.toString(), new Property<Boolean>((Object)JMSProperty.CallbackOnIOThread, jcsmpDefaults.getBooleanProperty("MESSAGE_CALLBACK_ON_REACTOR")));
        this.mProperties.put(JMSProperty.ClientDescription.toString(), new Property<String>((Object)JMSProperty.ClientDescription, jcsmpDefaults.getStringProperty("application_description")));
        this.mProperties.put(JMSProperty.ClientID.toString(), new Property<String>((Object)JMSProperty.ClientID, jcsmpDefaults.getStringProperty("client_name")));
        this.mProperties.get(JMSProperty.ClientID.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.CompressionLevel.toString(), new Property<Integer>((Object)JMSProperty.CompressionLevel, jcsmpChannelDefaults.getCompressionLevel()));
        this.mProperties.put(JMSProperty.ConnectRetries.toString(), new Property<Integer>((Object)JMSProperty.ConnectRetries, jcsmpChannelDefaults.getConnectRetries()));
        this.mProperties.put(JMSProperty.ConnectRetriesPerHost.toString(), new Property<Integer>((Object)JMSProperty.ConnectRetriesPerHost, jcsmpChannelDefaults.getConnectRetriesPerHost()));
        this.mProperties.put(JMSProperty.ConnectTimeoutInMillis.toString(), new Property<Integer>((Object)JMSProperty.ConnectTimeoutInMillis, jcsmpChannelDefaults.getConnectTimeoutInMillis()));
        this.mProperties.put(JMSProperty.ConsumerDefaultFlowCongestionLimit.toString(), new Property<Integer>((Object)JMSProperty.ConsumerDefaultFlowCongestionLimit, JCSMPFactory.onlyInstance().getGlobalProperties().getConsumerDefaultFlowCongestionLimit()));
        this.mProperties.put(JMSProperty.ConsumerDispatcherQueueSize.toString(), new Property<Integer>((Object)JMSProperty.ConsumerDispatcherQueueSize, JCSMPFactory.onlyInstance().getGlobalProperties().getConsumerDispatcherQueueSize()));
        this.mProperties.put(JMSProperty.DeadMessageQueueName.toString(), new Property((Object)JMSProperty.DeadMessageQueueName));
        this.mProperties.get(JMSProperty.DeadMessageQueueName.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.DelayedStartOverride.toString(), new Property<Boolean>((Object)JMSProperty.DelayedStartOverride, true));
        this.mProperties.put(JMSProperty.DeliveryMode.toString(), new Property<Integer>((Object)JMSProperty.DeliveryMode, 2));
        this.mProperties.put(JMSProperty.DeliverToOne.toString(), new Property<Boolean>((Object)JMSProperty.DeliverToOne, false));
        this.mProperties.put(JMSProperty.DeliverToOneOverride.toString(), new Property<Boolean>((Object)JMSProperty.DeliverToOneOverride, true));
        this.mProperties.put(JMSProperty.DirectOptimized.toString(), new Property<Boolean>((Object)JMSProperty.DirectOptimized, jcsmpDefaults.getBooleanProperty("topic_dispatch_optimize_direct")));
        this.mProperties.put(JMSProperty.DirectTransport.toString(), new Property<Boolean>((Object)JMSProperty.DirectTransport, true));
        this.mProperties.put(JMSProperty.JMSXUserIDEnabled.toString(), new Property<Boolean>((Object)JMSProperty.JMSXUserIDEnabled, true));
        this.mProperties.put(JMSProperty.AllowDuplicateClientId.toString(), new Property<Boolean>((Object)JMSProperty.AllowDuplicateClientId, true));
        this.mProperties.put(JMSProperty.DmqEligible.toString(), new Property<Boolean>((Object)JMSProperty.DmqEligible, false));
        this.mProperties.put(JMSProperty.DynamicDurables.toString(), new Property<Boolean>((Object)JMSProperty.DynamicDurables, false));
        this.mProperties.put(JMSProperty.ElidingEligible.toString(), new Property<Boolean>((Object)JMSProperty.ElidingEligible, false));
        this.mProperties.put(JMSProperty.FrequencyManagerMaxReconnects.toString(), new Property<Integer>((Object)JMSProperty.FrequencyManagerMaxReconnects, JCSMPFactory.onlyInstance().getGlobalProperties().getReconnectFreqManagerMaxReconnects()));
        this.mProperties.put(JMSProperty.GenerateSenderID.toString(), new Property<Boolean>((Object)JMSProperty.GenerateSenderID, jcsmpDefaults.getBooleanProperty("generate_sender_id")));
        this.mProperties.put(JMSProperty.Host.toString(), new Property((Object)JMSProperty.Host));
        this.mProperties.get(JMSProperty.Host.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.JNDIAuthenticationScheme.toString(), new Property<String>((Object)JMSProperty.JNDIAuthenticationScheme, jcsmpDefaults.getStringProperty("AUTHENTICATION_SCHEME")));
        this.mProperties.put(JMSProperty.JNDIClientDescription.toString(), new Property<String>((Object)JMSProperty.JNDIClientDescription, "JNDI"));
        this.mProperties.put(JMSProperty.JNDIClientID.toString(), new Property((Object)JMSProperty.JNDIClientID));
        this.mProperties.get(JMSProperty.JNDIClientID.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.JNDICompressionLevel.toString(), new Property<Integer>((Object)JMSProperty.JNDICompressionLevel, jcsmpChannelDefaults.getCompressionLevel()));
        this.mProperties.put(JMSProperty.JNDIConnectRetries.toString(), new Property<Integer>((Object)JMSProperty.JNDIConnectRetries, jcsmpChannelDefaults.getConnectRetries()));
        this.mProperties.put(JMSProperty.JNDIConnectRetriesPerHost.toString(), new Property<Integer>((Object)JMSProperty.JNDIConnectRetriesPerHost, jcsmpChannelDefaults.getConnectRetriesPerHost()));
        this.mProperties.put(JMSProperty.JNDIConnectTimeoutInMillis.toString(), new Property<Integer>((Object)JMSProperty.JNDIConnectTimeoutInMillis, jcsmpChannelDefaults.getConnectTimeoutInMillis()));
        this.mProperties.put(JMSProperty.JNDIHostlist.toString(), new Property((Object)JMSProperty.JNDIHostlist));
        this.mProperties.get(JMSProperty.JNDIHostlist.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.JNDIKRBMutualAuthentication.toString(), new Property<Boolean>((Object)JMSProperty.JNDIKRBMutualAuthentication, jcsmpDefaults.getBooleanProperty("KRB_MUTUAL_AUTHENTICATION")));
        this.mProperties.put(JMSProperty.JNDIKRBServiceName.toString(), new Property<String>((Object)JMSProperty.JNDIKRBServiceName, (String)jcsmpDefaults.getProperty("KRB_SERVICE_NAME")));
        this.mProperties.put(JMSProperty.JNDIJaasConfigFileReloadEnabled.toString(), new Property<String>((Object)JMSProperty.JNDIJaasConfigFileReloadEnabled, jcsmpDefaults.getStringProperty("JaasConfigFileReloadEnabled")));
        this.mProperties.put(JMSProperty.JNDIJaasLoginContext.toString(), new Property<String>((Object)JMSProperty.JNDIJaasLoginContext, jcsmpDefaults.getStringProperty("JaasLoginContext")));
        this.mProperties.put(JMSProperty.JNDIPassword.toString(), new Property((Object)JMSProperty.JNDIPassword));
        this.mProperties.get(JMSProperty.JNDIPassword.toString()).setType(String.class);
        this.mProperties.get(JMSProperty.JNDIPassword.toString()).setPrintable(false);
        this.mProperties.put(JMSProperty.JNDIReadTimeoutInMillis.toString(), new Property<Integer>((Object)JMSProperty.JNDIReadTimeoutInMillis, jcsmpChannelDefaults.getReadTimeoutInMillis()));
        this.mProperties.put(JMSProperty.JNDIReconnectRetries.toString(), new Property<Integer>((Object)JMSProperty.JNDIReconnectRetries, 20));
        this.mProperties.put(JMSProperty.JNDIReconnectRetryWaitInMillis.toString(), new Property<Integer>((Object)JMSProperty.JNDIReconnectRetryWaitInMillis, jcsmpChannelDefaults.getReconnectRetryWaitInMillis()));
        this.mProperties.put(JMSProperty.JNDISSLCipherSuites.toString(), new Property<String>((Object)JMSProperty.JNDISSLCipherSuites, (String)jcsmpDefaults.getProperty("SSL_CIPHER_SUITES")));
        this.mProperties.put(JMSProperty.JNDISSLValidateCertificateDate.toString(), new Property<Boolean>((Object)JMSProperty.JNDISSLValidateCertificateDate, jcsmpDefaults.getBooleanProperty("SSL_VALIDATE_CERTIFICATE_DATE")));
        this.mProperties.put(JMSProperty.JNDISSLExcludedProtocols.toString(), new Property<String>((Object)JMSProperty.JNDISSLExcludedProtocols, (String)jcsmpDefaults.getProperty("SSL_EXCLUDED_PROTOCOLS")));
        this.mProperties.put(JMSProperty.JNDISSLConnectionDowngradeTo.toString(), new Property<String>((Object)JMSProperty.JNDISSLConnectionDowngradeTo, (String)jcsmpDefaults.getProperty("SSL_CONNECTION_DOWNGRADE_TO")));
        this.mProperties.put(JMSProperty.JNDISSLProtocol.toString(), new Property<String>((Object)JMSProperty.JNDISSLProtocol, (String)jcsmpDefaults.getProperty("SSL_PROTOCOL")));
        this.mProperties.put(JMSProperty.JNDISSLTrustedCommonNameList.toString(), new Property((Object)JMSProperty.JNDISSLTrustedCommonNameList));
        this.mProperties.get(JMSProperty.JNDISSLTrustedCommonNameList.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.JNDISSLTrustStore.toString(), new Property<String>((Object)JMSProperty.JNDISSLTrustStore, (String)jcsmpDefaults.getProperty("SSL_TRUST_STORE")));
        this.mProperties.put(JMSProperty.JNDISSLTrustStoreFormat.toString(), new Property<String>((Object)JMSProperty.JNDISSLTrustStoreFormat, (String)jcsmpDefaults.getProperty("SSL_TRUST_STORE_FORMAT")));
        this.mProperties.put(JMSProperty.JNDISSLTrustStorePassword.toString(), new Property((Object)JMSProperty.JNDISSLTrustStorePassword));
        this.mProperties.get(JMSProperty.JNDISSLTrustStorePassword.toString()).setType(String.class);
        this.mProperties.get(JMSProperty.JNDISSLTrustStorePassword.toString()).setPrintable(false);
        this.mProperties.put(JMSProperty.JNDISSLKeyStore.toString(), new Property<String>((Object)JMSProperty.JNDISSLKeyStore, (String)jcsmpDefaults.getProperty("SSL_KEY_STORE")));
        this.mProperties.put(JMSProperty.JNDISSLKeyStoreFormat.toString(), new Property<String>((Object)JMSProperty.JNDISSLKeyStoreFormat, (String)jcsmpDefaults.getProperty("SSL_KEY_STORE_FORMAT")));
        this.mProperties.get(JMSProperty.JNDISSLKeyStoreFormat.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.JNDISSLKeyStoreNormalizedFormat.toString(), new Property<String>((Object)JMSProperty.JNDISSLKeyStoreNormalizedFormat, (String)jcsmpDefaults.getProperty("SSL_KEY_STORE_NORMALIZED_FORMAT")));
        this.mProperties.get(JMSProperty.JNDISSLKeyStoreNormalizedFormat.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.JNDISSLKeyStorePassword.toString(), new Property((Object)JMSProperty.JNDISSLKeyStorePassword));
        this.mProperties.get(JMSProperty.JNDISSLKeyStorePassword.toString()).setType(String.class);
        this.mProperties.get(JMSProperty.JNDISSLKeyStorePassword.toString()).setPrintable(false);
        this.mProperties.put(JMSProperty.JNDISSLPrivateKeyPassword.toString(), new Property((Object)JMSProperty.JNDISSLPrivateKeyPassword));
        this.mProperties.get(JMSProperty.JNDISSLPrivateKeyPassword.toString()).setType(String.class);
        this.mProperties.get(JMSProperty.JNDISSLPrivateKeyPassword.toString()).setPrintable(false);
        this.mProperties.put(JMSProperty.JNDISSLPrivateKeyAlias.toString(), new Property((Object)JMSProperty.JNDISSLPrivateKeyAlias));
        this.mProperties.get(JMSProperty.JNDISSLPrivateKeyAlias.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.JNDISSLValidateCertificate.toString(), new Property<Boolean>((Object)JMSProperty.JNDISSLValidateCertificate, jcsmpDefaults.getBooleanProperty("SSL_VALIDATE_CERTIFICATE")));
        this.mProperties.put(JMSProperty.JNDIURL.toString(), new Property((Object)JMSProperty.JNDIURL));
        this.mProperties.get(JMSProperty.JNDIURL.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.JNDIUsername.toString(), new Property((Object)JMSProperty.JNDIUsername));
        this.mProperties.get(JMSProperty.JNDIUsername.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.JNDIVPN.toString(), new Property((Object)JMSProperty.JNDIVPN));
        this.mProperties.get(JMSProperty.JNDIVPN.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.KeepAliveCountMax.toString(), new Property<Integer>((Object)JMSProperty.KeepAliveCountMax, 3));
        this.mProperties.put(JMSProperty.KeepAliveIntervalInMillis.toString(), new Property<Integer>((Object)JMSProperty.KeepAliveIntervalInMillis, jcsmpChannelDefaults.getKeepAliveIntervalInMillis()));
        this.mProperties.put(JMSProperty.KeepAlives.toString(), new Property<Boolean>((Object)JMSProperty.KeepAlives, true));
        this.mProperties.put(JMSProperty.KRBMutualAuthentication.toString(), new Property<Boolean>((Object)JMSProperty.KRBMutualAuthentication, jcsmpDefaults.getBooleanProperty("KRB_MUTUAL_AUTHENTICATION")));
        this.mProperties.put(JMSProperty.KRBServiceName.toString(), new Property<String>((Object)JMSProperty.KRBServiceName, jcsmpDefaults.getStringProperty("KRB_SERVICE_NAME")));
        this.mProperties.put(JMSProperty.LargeMessaging.toString(), new Property<Boolean>((Object)JMSProperty.LargeMessaging, jcsmpDefaults.getBooleanProperty("large_messaging")));
        this.mProperties.put(JMSProperty.LargeMessagingSegmentSize.toString(), new Property<Integer>((Object)JMSProperty.LargeMessagingSegmentSize, jcsmpDefaults.getIntegerProperty("large_message_segment_size")));
        this.mProperties.put(JMSProperty.LargeMessagingMaximumSize.toString(), new Property<Integer>((Object)JMSProperty.LargeMessagingMaximumSize, jcsmpDefaults.getIntegerProperty("large_message_max_size")));
        this.mProperties.put(JMSProperty.LargeMessagingConsumeTimeoutInMillis.toString(), new Property<Integer>((Object)JMSProperty.LargeMessagingConsumeTimeoutInMillis, jcsmpDefaults.getIntegerProperty("large_message_consume_timeout")));
        this.mProperties.put(JMSProperty.JaasConfigFileReloadEnabled.toString(), new Property<String>((Object)JMSProperty.JaasConfigFileReloadEnabled, jcsmpDefaults.getStringProperty("JaasConfigFileReloadEnabled")));
        this.mProperties.put(JMSProperty.JaasLoginContext.toString(), new Property<String>((Object)JMSProperty.JaasLoginContext, jcsmpDefaults.getStringProperty("JaasLoginContext")));
        this.mProperties.put(JMSProperty.Localhost.toString(), new Property((Object)JMSProperty.Localhost));
        this.mProperties.get(JMSProperty.Localhost.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.Password.toString(), new Property((Object)JMSProperty.Password));
        this.mProperties.get(JMSProperty.Password.toString()).setType(String.class);
        this.mProperties.get(JMSProperty.Password.toString()).setPrintable(false);
        this.mProperties.put(JMSProperty.Port.toString(), new Property<Integer>((Object)JMSProperty.Port, -1));
        this.mProperties.put(JMSProperty.ProducerDispatcherQueueSize.toString(), new Property<Integer>((Object)JMSProperty.ProducerDispatcherQueueSize, JCSMPFactory.onlyInstance().getGlobalProperties().getProducerDispatcherQueueSize()));
        this.mProperties.put(JMSProperty.ProviderGeneratedClientID.toString(), new Property<Boolean>((Object)JMSProperty.ProviderGeneratedClientID, false));
        this.mProperties.put(JMSProperty.ReadTimeoutInMillis.toString(), new Property<Integer>((Object)JMSProperty.ReadTimeoutInMillis, jcsmpChannelDefaults.getReadTimeoutInMillis()));
        this.mProperties.put(JMSProperty.ReceiveADAckThreshold.toString(), new Property<Integer>((Object)JMSProperty.ReceiveADAckThreshold, jcsmpDefaults.getIntegerProperty("sub_ack_window_threshold")));
        this.mProperties.put(JMSProperty.ReceiveADAckTimerInMillis.toString(), new Property<Integer>((Object)JMSProperty.ReceiveADAckTimerInMillis, jcsmpDefaults.getIntegerProperty("sub_ack_time")));
        this.mProperties.put(JMSProperty.ReceiveADWindowSize.toString(), new Property<Integer>((Object)JMSProperty.ReceiveADWindowSize, 18));
        this.mProperties.put(JMSProperty.ReceiveBufferSize.toString(), new Property<Integer>((Object)JMSProperty.ReceiveBufferSize, jcsmpChannelDefaults.getReceiveBuffer()));
        this.mProperties.put(JMSProperty.ReconnectRetries.toString(), new Property<Integer>((Object)JMSProperty.ReconnectRetries, jcsmpChannelDefaults.getReconnectRetries()));
        this.mProperties.put(JMSProperty.ReconnectRetryWaitInMillis.toString(), new Property<Integer>((Object)JMSProperty.ReconnectRetryWaitInMillis, jcsmpChannelDefaults.getReconnectRetryWaitInMillis()));
        this.mProperties.put(JMSProperty.RespectTTL.toString(), new Property<Boolean>((Object)JMSProperty.RespectTTL, true));
        this.mProperties.put(JMSProperty.SendADAckTimerInMillis.toString(), new Property<Integer>((Object)JMSProperty.SendADAckTimerInMillis, jcsmpDefaults.getIntegerProperty("pub_ack_time")));
        this.mProperties.put(JMSProperty.SendADMaxResends.toString(), new Property<Integer>((Object)JMSProperty.SendADMaxResends, jcsmpDefaults.getIntegerProperty("max_resends")));
        this.mProperties.put(JMSProperty.SendADWindowSize.toString(), new Property<Integer>((Object)JMSProperty.SendADWindowSize, 255));
        this.mProperties.put(JMSProperty.SendBufferSize.toString(), new Property<Integer>((Object)JMSProperty.SendBufferSize, jcsmpChannelDefaults.getSendBuffer()));
        this.mProperties.put(JMSProperty.SSLCipherSuites.toString(), new Property<String>((Object)JMSProperty.SSLCipherSuites, (String)jcsmpDefaults.getProperty("SSL_CIPHER_SUITES")));
        this.mProperties.put(JMSProperty.SSLValidateCertificateDate.toString(), new Property<Boolean>((Object)JMSProperty.SSLValidateCertificateDate, jcsmpDefaults.getBooleanProperty("SSL_VALIDATE_CERTIFICATE_DATE")));
        this.mProperties.put(JMSProperty.SSLExcludedProtocols.toString(), new Property<String>((Object)JMSProperty.SSLExcludedProtocols, (String)jcsmpDefaults.getProperty("SSL_EXCLUDED_PROTOCOLS")));
        this.mProperties.put(JMSProperty.SSLConnectionDowngradeTo.toString(), new Property<String>((Object)JMSProperty.SSLConnectionDowngradeTo, (String)jcsmpDefaults.getProperty("SSL_CONNECTION_DOWNGRADE_TO")));
        this.mProperties.put(JMSProperty.SSLProtocol.toString(), new Property<String>((Object)JMSProperty.SSLProtocol, (String)jcsmpDefaults.getProperty("SSL_PROTOCOL")));
        this.mProperties.put(JMSProperty.SSLTrustedCommonNameList.toString(), new Property((Object)JMSProperty.SSLTrustedCommonNameList));
        this.mProperties.get(JMSProperty.SSLTrustedCommonNameList.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.SSLTrustStore.toString(), new Property<String>((Object)JMSProperty.SSLTrustStore, (String)jcsmpDefaults.getProperty("SSL_TRUST_STORE")));
        this.mProperties.put(JMSProperty.SSLTrustStoreFormat.toString(), new Property<String>((Object)JMSProperty.SSLTrustStoreFormat, (String)jcsmpDefaults.getProperty("SSL_TRUST_STORE_FORMAT")));
        this.mProperties.put(JMSProperty.SSLTrustStorePassword.toString(), new Property((Object)JMSProperty.SSLTrustStorePassword));
        this.mProperties.get(JMSProperty.SSLTrustStorePassword.toString()).setType(String.class);
        this.mProperties.get(JMSProperty.SSLTrustStorePassword.toString()).setPrintable(false);
        this.mProperties.put(JMSProperty.SSLKeyStore.toString(), new Property((Object)JMSProperty.SSLKeyStore));
        this.mProperties.get(JMSProperty.SSLKeyStore.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.SSLKeyStoreFormat.toString(), new Property((Object)JMSProperty.SSLKeyStoreFormat));
        this.mProperties.get(JMSProperty.SSLKeyStoreFormat.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.SSLKeyStoreNormalizedFormat.toString(), new Property((Object)JMSProperty.SSLKeyStoreNormalizedFormat));
        this.mProperties.get(JMSProperty.SSLKeyStoreNormalizedFormat.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.SSLKeyStorePassword.toString(), new Property((Object)JMSProperty.SSLKeyStorePassword));
        this.mProperties.get(JMSProperty.SSLKeyStorePassword.toString()).setType(String.class);
        this.mProperties.get(JMSProperty.SSLKeyStorePassword.toString()).setPrintable(false);
        this.mProperties.put(JMSProperty.SSLPrivateKeyAlias.toString(), new Property((Object)JMSProperty.SSLPrivateKeyAlias));
        this.mProperties.get(JMSProperty.SSLPrivateKeyAlias.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.SSLPrivateKeyPassword.toString(), new Property((Object)JMSProperty.SSLPrivateKeyPassword));
        this.mProperties.get(JMSProperty.SSLPrivateKeyPassword.toString()).setType(String.class);
        this.mProperties.get(JMSProperty.SSLPrivateKeyPassword.toString()).setPrintable(false);
        this.mProperties.put(JMSProperty.SSLValidateCertificate.toString(), new Property<Boolean>((Object)JMSProperty.SSLValidateCertificate, jcsmpDefaults.getBooleanProperty("SSL_VALIDATE_CERTIFICATE")));
        this.mProperties.put(JMSProperty.SubscriberLocalPriority.toString(), new Property<Integer>((Object)JMSProperty.SubscriberLocalPriority, jcsmpDefaults.getIntegerProperty("subscriber_local_priority")));
        this.mProperties.put(JMSProperty.SubscriberNetworkPriority.toString(), new Property<Integer>((Object)JMSProperty.SubscriberNetworkPriority, jcsmpDefaults.getIntegerProperty("subscriber_network_priority")));
        this.mProperties.put(JMSProperty.TcpNoDelay.toString(), new Property<Boolean>((Object)JMSProperty.TcpNoDelay, jcsmpChannelDefaults.isTcpNoDelay()));
        this.mProperties.put(JMSProperty.UseDefaultContext.toString(), new Property<Boolean>((Object)JMSProperty.UseDefaultContext, false));
        this.mProperties.put(JMSProperty.UseLegacyConnectionConsumer.toString(), new Property<Boolean>((Object)JMSProperty.UseLegacyConnectionConsumer, false));
        this.mProperties.put(JMSProperty.Username.toString(), new Property((Object)JMSProperty.Username));
        this.mProperties.get(JMSProperty.Username.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.VPN.toString(), new Property((Object)JMSProperty.VPN));
        this.mProperties.get(JMSProperty.VPN.toString()).setType(String.class);
        this.mProperties.put(JMSProperty.XA.toString(), new Property<Boolean>((Object)JMSProperty.XA, false));
        this.mProperties.put(JMSProperty.XmlPayload.toString(), new Property<Boolean>((Object)JMSProperty.XmlPayload, true));
        this.mProperties.put(JMSProperty.GdReconnectFailAction.toString(), new Property<String>((Object)JMSProperty.GdReconnectFailAction, (String)jcsmpDefaults.getProperty("gd_reconnect_fail_action")));
        this.mProperties.put(JMSProperty.MessageIDMode.toString(), new Property<String>((Object)JMSProperty.MessageIDMode, "DEFAULT"));
        this.mProperties.get(JMSProperty.MessageIDMode.toString()).setType(String.class);
    }

    private void createSources() {
        this.addStringSources(JMSProperty.AuthenticationScheme, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_Authentication_Scheme", this.mEnvironment, 2, false));
        Property<?> prop = this.mProperties.get(JMSProperty.AuthenticationScheme.toString());
        prop.addVetoableListener(new AuthenticationSchemeValidator());
        this.addIntegerSources(JMSProperty.BrowserTimeoutInMS, new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_Browser_Timeout_In_MS", this.mEnvironment, 1, false, intCvtr), new SystemPropertySource("Solace_JMS_Browser_Timeout_In_MS", 2, false, intCvtr), new PropertySource(CONNECTION_FACTORY_SOURCE, 3, false, intCvtr));
        this.addBooleanSources(JMSProperty.CallbackOnDispatcherThread, new SystemPropertySource("Solace_JMS_MsgCallbackOnDispatcherThread", 1, false, boolCvtr));
        this.addBooleanSources(JMSProperty.CallbackOnIOThread, new SystemPropertySource("Solace_JMS_MsgCallbackOnIOThread", 1, false, boolCvtr), new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_MsgCallbackOnIOThread", this.mEnvironment, 2, false, boolCvtr), new PropertySource(CONNECTION_FACTORY_SOURCE, 3, false, boolCvtr));
        this.addStringSources(JMSProperty.ClientDescription, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_ClientDescription", this.mEnvironment, 1, false), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false));
        this.addStringSources(JMSProperty.ClientID, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false), new PropertySource(JMS_API_SOURCE, 2, false));
        this.addIntegerSources(JMSProperty.CompressionLevel, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr), new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_CompressionLevel", this.mEnvironment, 2, false, intCvtr));
        this.addIntegerSources(JMSProperty.ConnectRetries, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.ConnectRetriesPerHost, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.ConnectTimeoutInMillis, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.ConsumerDefaultFlowCongestionLimit, new SystemPropertySource("Solace_JMS_ConsumerDefaultFlowCongestionLimit", 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.ConsumerDispatcherQueueSize, new SystemPropertySource("Solace_JMS_ConsumerDispatcherQueueSize", 1, false, intCvtr));
        this.addStringSources(JMSProperty.DeadMessageQueueName, new SystemPropertySource("Solace_JMS_DeadMsgQueueName"));
        this.addBooleanSources(JMSProperty.DelayedStartOverride, new SystemPropertySource("Solace_JMS_DelayedStartOverride", 1, false, boolCvtr), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_DelayedStartOverride", this.mEnvironment, 2, boolCvtr));
        this.addIntegerSources(JMSProperty.DeliveryMode, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, new DeliveryModeConverter()));
        this.addBooleanSources(JMSProperty.DeliverToOne, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr));
        this.addBooleanSources(JMSProperty.DeliverToOneOverride, new SystemPropertySource("Solace_JMS_DeliverToOneOverride", 1, false, boolCvtr), new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_DeliverToOneOverride", this.mEnvironment, 2, false, boolCvtr), new PropertySource(CONNECTION_FACTORY_SOURCE, 3, false, boolCvtr));
        this.addBooleanSources(JMSProperty.DirectOptimized, new SystemPropertySource("Solace_JMS_OptimizeDirect", 1, false, boolCvtr), new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_OptimizeDirect", this.mEnvironment, 2, false, boolCvtr), new PropertySource(CONNECTION_FACTORY_SOURCE, 3, false, boolCvtr));
        this.addBooleanSources(JMSProperty.DirectTransport, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr));
        this.addBooleanSources(JMSProperty.JMSXUserIDEnabled, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr));
        this.addBooleanSources(JMSProperty.AllowDuplicateClientId, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr));
        this.addBooleanSources(JMSProperty.DmqEligible, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr));
        this.addBooleanSources(JMSProperty.DynamicDurables, new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_DynamicDurables", this.mEnvironment, 1, false, boolCvtr), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false, boolCvtr));
        this.addBooleanSources(JMSProperty.ElidingEligible, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr));
        this.addIntegerSources(JMSProperty.FrequencyManagerMaxReconnects, new SystemPropertySource("Solace_JMS_ReconnectFreqManagerMaxReconnects", 1, false, intCvtr));
        this.addBooleanSources(JMSProperty.GenerateSenderID, new SystemPropertySource("Solace_JMS_GenerateSenderId", 1, false, boolCvtr), new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_GenerateSenderId", this.mEnvironment, 2, false, boolCvtr), new PropertySource(CONNECTION_FACTORY_SOURCE, 3, false, boolCvtr));
        this.addStringSources(JMSProperty.Host, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, new URLToHostlistConverter(false)), new MapPropertySource(URL_SOURCE, (Object)"java.naming.provider.url", this.mEnvironment, 2, new URLToHostlistConverter(true)), new SystemPropertySource("java.naming.provider.url", 3, false, new URLToHostlistConverter(true)));
        this.addStringSources(JMSProperty.JNDIAuthenticationScheme, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_Authentication_Scheme", this.mEnvironment, 1, false));
        prop = this.mProperties.get(JMSProperty.JNDIAuthenticationScheme.toString());
        prop.addVetoableListener(new AuthenticationSchemeValidator());
        this.addStringSources(JMSProperty.JNDIClientDescription, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_JNDI_ClientDescription", this.mEnvironment, 1, false));
        this.addStringSources(JMSProperty.JNDIClientID, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_JNDI_ClientID", this.mEnvironment, 1, false));
        this.addIntegerSources(JMSProperty.JNDICompressionLevel, new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_CompressionLevel", this.mEnvironment, 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.JNDIConnectRetries, new MapPropertySource("Initial Context Environment-1", "Solace_JMS_JNDI_ConnectRetries", this.mEnvironment, 1, false, intCvtr), new MapPropertySource("Initial Context Environment-2", "JNDI_Connect_Retries", this.mEnvironment, 2, false, intCvtr), new SystemPropertySource("JNDI_Connect_Retries", 3, false, intCvtr));
        this.addIntegerSources(JMSProperty.JNDIConnectRetriesPerHost, new MapPropertySource("Initial Context Environment-1", "Solace_JMS_JNDI_ConnectRetriesPerHost", this.mEnvironment, 1, false, intCvtr), new MapPropertySource("Initial Context Environment-2", "JNDI_Connection_Retries_Per_Host", this.mEnvironment, 2, false, intCvtr), new SystemPropertySource("JNDI_Connection_Retries_Per_Host", 3, false, intCvtr));
        this.addIntegerSources(JMSProperty.JNDIConnectTimeoutInMillis, new MapPropertySource("Initial Context Environment-1", "Solace_JMS_JNDI_ConnectTimeout", this.mEnvironment, 1, false, intCvtr), new MapPropertySource("Initial Context Environment-2", "JNDI_Connect_Timeout", this.mEnvironment, 2, false, intCvtr), new SystemPropertySource("JNDI_Connect_Timeout", 3, false, intCvtr));
        this.addStringSources(JMSProperty.JNDIHostlist, new MapPropertySource(URL_SOURCE, (Object)"java.naming.provider.url", this.mEnvironment, 1, new URLToHostlistConverter(true)));
        this.addBooleanSources(JMSProperty.JNDIKRBMutualAuthentication, new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_KRB_Mutual_Authentication", this.mEnvironment, 1, false, boolCvtr));
        this.addBooleanSources(JMSProperty.JNDIKRBServiceName, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_KRB_Service_Name", this.mEnvironment, 1, false));
        this.addBooleanSources(JMSProperty.JNDIJaasConfigFileReloadEnabled, new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_JaasConfigFileReloadEnabled", this.mEnvironment, 1, false, null));
        this.addStringSources(JMSProperty.JNDIJaasLoginContext, new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_JaasLoginContext", this.mEnvironment, 1, false, null));
        this.addStringSources(JMSProperty.JNDIPassword, new SystemPropertySource("System Property", "java.naming.security.credentials", 1, false), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"java.naming.security.credentials", this.mEnvironment, 2), new MapPropertySource(URL_SOURCE, (Object)"java.naming.provider.url", this.mEnvironment, 3, new URLToPasswordConverter()));
        this.addIntegerSources(JMSProperty.JNDIReadTimeoutInMillis, new MapPropertySource("Initial Context Environment-1", "Solace_JMS_JNDI_ReadTimeout", this.mEnvironment, 1, false, intCvtr), new MapPropertySource("Initial Context Environment-2", "JNDI_Read_Timeout", this.mEnvironment, 2, false, intCvtr), new SystemPropertySource("JNDI_Read_Timeout", 3, false, intCvtr));
        this.addIntegerSources(JMSProperty.JNDIReconnectRetries, new MapPropertySource("Initial Context Environment-1", "Solace_JMS_JNDI_ReconnectRetries", this.mEnvironment, 1, false, intCvtr), new MapPropertySource("Initial Context Environment-2", "JNDI_Reconnect_Retries", this.mEnvironment, 2, false, intCvtr), new SystemPropertySource("JNDI_Reconnect_Retries", 3, false, intCvtr));
        this.addIntegerSources(JMSProperty.JNDIReconnectRetryWaitInMillis, new MapPropertySource("Initial Context Environment-1", "Solace_JMS_JNDI_ReconnectRetryWait", this.mEnvironment, 1, false, intCvtr), new MapPropertySource("Initial Context Environment-2", "JNDI_Reconnect_Retry_Wait", this.mEnvironment, 2, false, intCvtr), new SystemPropertySource("JNDI_Reconnect_Retry_Wait", 3, false, intCvtr));
        this.addStringSources(JMSProperty.JNDISSLCipherSuites, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_CipherSuites", this.mEnvironment, 1, false));
        this.addBooleanSources(JMSProperty.JNDISSLValidateCertificateDate, new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_SSL_ValidateCertificateDate", this.mEnvironment, 1, false, boolCvtr));
        this.addStringSources(JMSProperty.JNDISSLExcludedProtocols, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_ExcludedProtocols", this.mEnvironment, 1, false));
        this.addStringSources(JMSProperty.JNDISSLConnectionDowngradeTo, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_ConnectionDowngradeTo", this.mEnvironment, 1, false));
        this.addStringSources(JMSProperty.JNDISSLProtocol, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_Protocol", this.mEnvironment, 1, false));
        this.addStringSources(JMSProperty.JNDISSLTrustedCommonNameList, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_TrustedCommonNameList", this.mEnvironment, 1, false));
        this.addStringSources(JMSProperty.JNDISSLTrustStore, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_TrustStore", this.mEnvironment, 1, false), new SystemPropertySource("javax.net.ssl.trustStore", 2, false));
        this.addStringSources(JMSProperty.JNDISSLTrustStoreFormat, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_TrustStoreFormat", this.mEnvironment, 1, false), new SystemPropertySource("javax.net.ssl.trustStoreType", 2, false));
        this.addStringSources(JMSProperty.JNDISSLTrustStorePassword, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_TrustStorePassword", this.mEnvironment, 1, false), new SystemPropertySource("javax.net.ssl.trustStorePassword", 2, false));
        this.addStringSources(JMSProperty.JNDISSLKeyStore, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_KeyStore", this.mEnvironment, 1, false), new SystemPropertySource("javax.net.ssl.keyStore", 2, false));
        this.addStringSources(JMSProperty.JNDISSLKeyStoreFormat, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_KeyStoreFormat", this.mEnvironment, 1, false), new SystemPropertySource("javax.net.ssl.keyStoreType", 2, false));
        this.addStringSources(JMSProperty.JNDISSLKeyStoreNormalizedFormat, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_KeyStoreNormalizedFormat", this.mEnvironment, 1, false), new SystemPropertySource("javax.net.ssl.keyStoreNormalizedType", 2, false));
        this.addStringSources(JMSProperty.JNDISSLKeyStorePassword, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_KeyStorePassword", this.mEnvironment, 1, false), new SystemPropertySource("javax.net.ssl.keyStorePassword", 2, false));
        this.addStringSources(JMSProperty.JNDISSLPrivateKeyAlias, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_PrivateKeyAlias", this.mEnvironment, 1, false));
        this.addStringSources(JMSProperty.JNDISSLPrivateKeyPassword, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_PrivateKeyPassword", this.mEnvironment, 1, false));
        this.addBooleanSources(JMSProperty.JNDISSLValidateCertificate, new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_SSL_ValidateCertificate", this.mEnvironment, 1, false, boolCvtr));
        this.addStringSources(JMSProperty.JNDIURL, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"java.naming.provider.url", this.mEnvironment, 1));
        this.addStringSources(JMSProperty.JNDIUsername, new SystemPropertySource("System Property", "java.naming.security.principal", 1, false, usernameCvtr), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"java.naming.security.principal", this.mEnvironment, 2, usernameCvtr), new MapPropertySource(URL_SOURCE, (Object)"java.naming.provider.url", this.mEnvironment, 3, new URLToUsernameConverter()));
        this.addStringSources(JMSProperty.JNDIVPN, new SystemPropertySource("Solace_JMS_VPN", 1, false), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_VPN", this.mEnvironment, 2), new MapPropertySource("Initial Context Environment-java.naming.security.principal", (Object)"java.naming.security.principal", this.mEnvironment, 3, usernameToVpnCvtr));
        this.addIntegerSources(JMSProperty.KeepAliveCountMax, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.KeepAliveIntervalInMillis, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addBooleanSources(JMSProperty.KeepAlives, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr));
        this.addBooleanSources(JMSProperty.KRBMutualAuthentication, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr), new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_KRB_Mutual_Authentication", this.mEnvironment, 2, false, boolCvtr));
        this.addStringSources(JMSProperty.KRBServiceName, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, null), new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_KRB_Service_Name", this.mEnvironment, 2, false, null));
        this.addStringSources(JMSProperty.JaasLoginContext, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, null), new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_JaasLoginContext", this.mEnvironment, 2, false, null));
        this.addBooleanSources(JMSProperty.JaasConfigFileReloadEnabled, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr), new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_JaasConfigFileReloadEnabled", this.mEnvironment, 2, false, boolCvtr));
        this.addBooleanSources(JMSProperty.LargeMessaging, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_Large_Messaging", this.mEnvironment, 1, boolCvtr), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false, boolCvtr), new SystemPropertySource("Solace_JMS_Large_Messaging", 3, false, boolCvtr));
        this.addIntegerSources(JMSProperty.LargeMessagingSegmentSize, new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_Large_Messaging_Payload_Segment_Size", this.mEnvironment, 1, false, intCvtr), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false, intCvtr), new SystemPropertySource("Solace_JMS_Large_Messaging_Payload_Segment_Size", 3, false, intCvtr));
        this.addIntegerSources(JMSProperty.LargeMessagingMaximumSize, new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_Large_Messaging_Maximum_Size", this.mEnvironment, 1, false, intCvtr), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false, intCvtr), new SystemPropertySource("Solace_JMS_Large_Messaging_Maximum_Size", 3, false, intCvtr));
        this.addIntegerSources(JMSProperty.LargeMessagingConsumeTimeoutInMillis, new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_Large_Messaging_Consume_Timeout_In_Millis", this.mEnvironment, 1, false, intCvtr), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false, intCvtr), new SystemPropertySource("Solace_JMS_Large_Messaging_Consume_Timeout_In_Millis", 3, false, intCvtr));
        this.addStringSources(JMSProperty.Localhost, new MapPropertySource("Initial Context Environment-1", (Object)"Solace_JMS_Localhost", this.mEnvironment, 1, false), new MapPropertySource("Initial Context Environment-2", (Object)"JMS_Solace_localhost", this.mEnvironment, 2, false), new SystemPropertySource("JMS_Solace_localhost", 3));
        this.addStringSources(JMSProperty.Password, new PropertySource(JMS_API_SOURCE, 1, false), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false), new SystemPropertySource("System Property-java.naming.security.credentials", "java.naming.security.credentials", 3, false), new SystemPropertySource("System Property-java.naming.provider.url", "java.naming.provider.url", 4, false, new URLToPasswordConverter()), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"java.naming.security.credentials", this.mEnvironment, 5), new MapPropertySource(URL_SOURCE, (Object)"java.naming.provider.url", this.mEnvironment, 6, new URLToPasswordConverter()));
        this.addIntegerSources(JMSProperty.Port, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr), new PropertySource(JNDI_CONNECTION_SOURCE, 2, false, intCvtr));
        this.addIntegerSources(JMSProperty.ProducerDispatcherQueueSize, new SystemPropertySource("Solace_JMS_ProducerDispatcherQueueSize", 1, false, intCvtr));
        this.addBooleanSources(JMSProperty.ProviderGeneratedClientID, new SystemPropertySource("Solace_JMS_providerGeneratedClientID", 1, false, boolCvtr));
        this.addIntegerSources(JMSProperty.ReadTimeoutInMillis, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.ReceiveADAckThreshold, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.ReceiveADAckTimerInMillis, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.ReceiveADWindowSize, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.ReceiveBufferSize, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.ReconnectRetries, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.ReconnectRetryWaitInMillis, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addBooleanSources(JMSProperty.RespectTTL, new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_RespectTimeToLive", this.mEnvironment, 1, false, boolCvtr), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false, boolCvtr));
        this.addIntegerSources(JMSProperty.SendADAckTimerInMillis, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.SendADMaxResends, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.SendADWindowSize, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addIntegerSources(JMSProperty.SendBufferSize, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, intCvtr));
        this.addStringSources(JMSProperty.SSLCipherSuites, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_CipherSuites", this.mEnvironment, 2, false));
        this.addBooleanSources(JMSProperty.SSLValidateCertificateDate, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr), new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_SSL_ValidateCertificateDate", this.mEnvironment, 2, false, boolCvtr));
        this.addStringSources(JMSProperty.SSLExcludedProtocols, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_ExcludedProtocols", this.mEnvironment, 2, false));
        this.addStringSources(JMSProperty.SSLConnectionDowngradeTo, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_ConnectionDowngradeTo", this.mEnvironment, 2, false));
        this.addStringSources(JMSProperty.SSLProtocol, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_Protocol", this.mEnvironment, 2, false));
        this.addStringSources(JMSProperty.SSLTrustedCommonNameList, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_TrustedCommonNameList", this.mEnvironment, 2, false));
        this.addStringSources(JMSProperty.SSLTrustStore, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_TrustStore", this.mEnvironment, 1, false), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false), new SystemPropertySource("javax.net.ssl.trustStore", 3, false));
        this.addStringSources(JMSProperty.SSLTrustStoreFormat, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_TrustStoreFormat", this.mEnvironment, 1, false), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false), new SystemPropertySource("javax.net.ssl.trustStoreType", 3, false));
        this.addStringSources(JMSProperty.SSLTrustStorePassword, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_TrustStorePassword", this.mEnvironment, 1, false), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false), new SystemPropertySource("javax.net.ssl.trustStorePassword", 3, false));
        this.addStringSources(JMSProperty.SSLKeyStore, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_KeyStore", this.mEnvironment, 1, false), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false), new SystemPropertySource("javax.net.ssl.keyStore", 3, false));
        this.addStringSources(JMSProperty.SSLKeyStoreFormat, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_KeyStoreFormat", this.mEnvironment, 1, false), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false), new SystemPropertySource("javax.net.ssl.keyStoreType", 3, false));
        this.addStringSources(JMSProperty.SSLKeyStoreNormalizedFormat, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_KeyStoreNormalizedFormat", this.mEnvironment, 1, false), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false), new SystemPropertySource("javax.net.ssl.keyStoreNormalizedType", 3, false));
        this.addStringSources(JMSProperty.SSLKeyStorePassword, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_KeyStorePassword", this.mEnvironment, 1, false), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false), new SystemPropertySource("javax.net.ssl.keyStorePassword", 3, false));
        this.addStringSources(JMSProperty.SSLPrivateKeyAlias, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_PrivateKeyAlias", this.mEnvironment, 2, false));
        this.addStringSources(JMSProperty.SSLPrivateKeyPassword, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_SSL_PrivateKeyPassword", this.mEnvironment, 2, false));
        this.addBooleanSources(JMSProperty.SSLValidateCertificate, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr), new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_SSL_ValidateCertificate", this.mEnvironment, 2, false, boolCvtr));
        this.addIntegerSources(JMSProperty.SubscriberLocalPriority, new SystemPropertySource("Solace_JMS_SubscriberLocalDTOPriority", 1, false, intCvtr), new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_SubscriberLocalDTOPriority", this.mEnvironment, 2, false, intCvtr), new PropertySource(CONNECTION_FACTORY_SOURCE, 3, false, intCvtr));
        this.addIntegerSources(JMSProperty.SubscriberNetworkPriority, new SystemPropertySource("Solace_JMS_SubscriberNetworkDTOPriority", 1, false, intCvtr), new MapPropertySource(INITIAL_CONTEXT_SOURCE, "Solace_JMS_SubscriberNetworkDTOPriority", this.mEnvironment, 2, false, intCvtr), new PropertySource(CONNECTION_FACTORY_SOURCE, 3, false, intCvtr));
        this.addBooleanSources(JMSProperty.TcpNoDelay, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr));
        this.addBooleanSources(JMSProperty.UseDefaultContext, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_UseDefaultContext", this.mEnvironment, 2, boolCvtr));
        this.addBooleanSources(JMSProperty.UseLegacyConnectionConsumer, new SystemPropertySource("Solace_JMS_useLegacyConnectionConsumer", 1, false, boolCvtr));
        this.addStringSources(JMSProperty.Username, new PropertySource(JMS_API_SOURCE, 1, false), new PropertySource(CONNECTION_FACTORY_SOURCE, 2, false), new SystemPropertySource("System Property-java.naming.security.principal", "java.naming.security.principal", 3, false, usernameCvtr), new SystemPropertySource("System Property-java.naming.provider.url", "java.naming.provider.url", 4, false, new URLToUsernameConverter()), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"java.naming.security.principal", this.mEnvironment, 5, usernameCvtr), new MapPropertySource(URL_SOURCE, (Object)"java.naming.provider.url", this.mEnvironment, 6, new URLToUsernameConverter()));
        this.addStringSources(JMSProperty.VPN, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false), new SystemPropertySource("Solace_JMS_VPN", 2, false), new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_VPN", this.mEnvironment, 3), new MapPropertySource("Initial Context Environment-java.naming.security.principal", (Object)"java.naming.security.principal", this.mEnvironment, 4, usernameToVpnCvtr));
        this.addBooleanSources(JMSProperty.XA, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr));
        this.addBooleanSources(JMSProperty.XmlPayload, new PropertySource(CONNECTION_FACTORY_SOURCE, 1, false, boolCvtr));
        this.addStringSources(JMSProperty.GdReconnectFailAction, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_GD_Reconnect_Fail_Action", this.mEnvironment, 1, false), new SystemPropertySource("Solace_JMS_GD_Reconnect_Fail_Action", 2, false));
        this.addStringSources(JMSProperty.MessageIDMode, new MapPropertySource(INITIAL_CONTEXT_SOURCE, (Object)"Solace_JMS_MessageIDMode", this.mEnvironment, 1), new PropertySource("Solace_JMS_MessageIDMode", 2, false), new SystemPropertySource("Solace_JMS_MessageIDMode", 3, false));
    }

    public Hashtable<?, ?> getEnvironment() {
        return this.mEnvironment;
    }

    public Map<String, Property<?>> getProperties() {
        return this.mProperties;
    }

    public void initialize() throws PropertyVetoException, PropertyConversionException {
        for (Property<?> prop : this.mProperties.values()) {
            Collection<String> sourceNames = prop.getSourceNames();
            Iterator<String> sourceIT = sourceNames.iterator();
            while (sourceIT.hasNext()) {
                PropertySource<?> source = prop.getSource(sourceIT.next());
                try {
                    source.initialize();
                }
                catch (Exception ex) {
                    if (ex instanceof PropertyVetoException && (prop.getId().equals(JMSProperty.AuthenticationScheme.toString()) || prop.getId().equals(JMSProperty.JNDIAuthenticationScheme.toString()))) {
                        throw (PropertyVetoException)ex;
                    }
                    if (ex.getMessage().contains("corbaloc:")) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)String.format("Failed to initialize PropertySource \"%s\" for Property \"%s\" - %s", source.getName(), prop.getId(), ex.getMessage()));
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)String.format("Failed to initialize PropertySource \"%s\" for Property \"%s\" - %s", source.getName(), prop.getId(), ex.getMessage()));
                }
            }
        }
    }

    public Object clone() {
        return new JMSProperties(this);
    }

    public String toString() {
        TreeMap treeMap = new TreeMap();
        for (Property<?> prop : this.mProperties.values()) {
            treeMap.put(prop.getId(), prop);
        }
        StringBuilder bldr = new StringBuilder();
        Iterator<Property<Object>> it = treeMap.values().iterator();
        while (it.hasNext()) {
            bldr.append(it.next());
        }
        return bldr.toString();
    }

    private void addIntegerSources(JMSProperty property, PropertySource<Integer> ... sources) {
        Property<?> prop = this.mProperties.get(property.toString());
        prop.addSources(sources);
    }

    private void addStringSources(JMSProperty property, PropertySource<String> ... sources) {
        Property<?> prop = this.mProperties.get(property.toString());
        prop.addSources(sources);
    }

    private void addBooleanSources(JMSProperty property, PropertySource<Boolean> ... sources) {
        Property<?> prop = this.mProperties.get(property.toString());
        prop.addSources(sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateBean(String name, Collection<Property<?>> properties, String source, int operations) {
        String jmsBeanStr = PropertyBeanGenerator.generate(name, "com.solacesystems.jms.property", properties, source, operations);
        File jmsBeanFile = new File(".", name + ".java");
        if (jmsBeanFile.exists()) {
            jmsBeanFile.delete();
        }
        FileOutputStream fos = null;
        try {
            jmsBeanFile.createNewFile();
            fos = new FileOutputStream(jmsBeanFile);
            fos.write(jmsBeanStr.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        JMSProperties p = null;
        try {
            p = new JMSProperties((Hashtable)null);
            p.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JMSProperties.generateBean("JMSPropertyBean", p.getProperties().values(), null, 5);
        JMSProperties.generateBean("JMSConnectionFactoryPropertyBean", p.getProperties().values(), CONNECTION_FACTORY_SOURCE, 7);
        JMSProperties.generateBean("JMSAPIPropertyBean", p.getProperties().values(), JMS_API_SOURCE, 2);
    }
}

