/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.secure;

import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.secure.AuthSSLInitializationError;
import com.solacesystems.jcsmp.secure.AuthSSLX509TrustManager;
import com.solacesystems.jcsmp.secure.JCSMPSecureProtocolSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthSSLProtocolSocketFactory
implements JCSMPSecureProtocolSocketFactory {
    private static final Log LOG = LogFactory.getLog(AuthSSLProtocolSocketFactory.class);
    private URL keystoreUrl = null;
    private String keystorePassword = null;
    private URL truststoreUrl = null;
    private String truststorePassword = null;
    private SSLContext sslcontext = null;
    private HandshakeCompletedListener m_listener;
    private String[] m_ciphers;

    public AuthSSLProtocolSocketFactory(URL keystoreUrl, String keystorePassword, URL truststoreUrl, String truststorePassword, HandshakeCompletedListener listener, String[] ciphers) {
        this.keystoreUrl = keystoreUrl;
        this.keystorePassword = keystorePassword;
        this.truststoreUrl = truststoreUrl;
        this.truststorePassword = truststorePassword;
        this.m_listener = listener;
        this.m_ciphers = ciphers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore createKeyStore(URL url, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (url == null) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("AuthSSLProtocolSocketFactory.keystoreUrlMayNotBeNull"));
        }
        LOG.debug((Object)"Initializing key store");
        KeyStore keystore = KeyStore.getInstance("jks");
        InputStream keystoreInputStream = url.openStream();
        try {
            keystore.load(keystoreInputStream, password != null ? password.toCharArray() : null);
        }
        finally {
            if (keystoreInputStream != null) {
                keystoreInputStream.close();
            }
        }
        return keystore;
    }

    private static KeyManager[] createKeyManagers(KeyStore keystore, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keystore == null) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("AuthSSLProtocolSocketFactory.keystoreMayNotBeNull"));
        }
        LOG.debug((Object)"Initializing key manager");
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, password != null ? password.toCharArray() : null);
        return kmfactory.getKeyManagers();
    }

    private static TrustManager[] createTrustManagers(KeyStore keystore) throws KeyStoreException, NoSuchAlgorithmException {
        if (keystore == null) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("AuthSSLProtocolSocketFactory.keystoreMayNotBeNull"));
        }
        LOG.debug((Object)"Initializing trust manager");
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmfactory.init(keystore);
        TrustManager[] trustmanagers = tmfactory.getTrustManagers();
        for (int i = 0; i < trustmanagers.length; ++i) {
            if (!(trustmanagers[i] instanceof X509TrustManager)) continue;
            trustmanagers[i] = new AuthSSLX509TrustManager((X509TrustManager)trustmanagers[i], null);
        }
        return trustmanagers;
    }

    SSLContext createSSLContext() {
        try {
            String alias;
            Enumeration<String> aliases;
            KeyStore keystore;
            KeyManager[] keymanagers = null;
            TrustManager[] trustmanagers = null;
            if (this.keystoreUrl != null) {
                keystore = AuthSSLProtocolSocketFactory.createKeyStore(this.keystoreUrl, this.keystorePassword);
                if (LOG.isDebugEnabled()) {
                    aliases = keystore.aliases();
                    while (aliases.hasMoreElements()) {
                        alias = aliases.nextElement();
                        Certificate[] certs = keystore.getCertificateChain(alias);
                        if (certs == null) continue;
                        LOG.debug((Object)("Certificate chain '" + alias + "':"));
                        for (int c = 0; c < certs.length; ++c) {
                            if (!(certs[c] instanceof X509Certificate)) continue;
                            X509Certificate cert = (X509Certificate)certs[c];
                            LOG.debug((Object)(" Certificate " + (c + 1) + ":"));
                            LOG.debug((Object)("  Subject DN: " + cert.getSubjectDN()));
                            LOG.debug((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                            LOG.debug((Object)("  Valid from: " + cert.getNotBefore()));
                            LOG.debug((Object)("  Valid until: " + cert.getNotAfter()));
                            LOG.debug((Object)("  Issuer: " + cert.getIssuerDN()));
                        }
                    }
                }
                keymanagers = AuthSSLProtocolSocketFactory.createKeyManagers(keystore, this.keystorePassword);
            }
            if (this.truststoreUrl != null) {
                keystore = AuthSSLProtocolSocketFactory.createKeyStore(this.truststoreUrl, this.truststorePassword);
                if (LOG.isDebugEnabled()) {
                    aliases = keystore.aliases();
                    while (aliases.hasMoreElements()) {
                        alias = aliases.nextElement();
                        LOG.debug((Object)("Trusted certificate '" + alias + "':"));
                        Certificate trustedcert = keystore.getCertificate(alias);
                        if (trustedcert == null || !(trustedcert instanceof X509Certificate)) continue;
                        X509Certificate cert = (X509Certificate)trustedcert;
                        LOG.debug((Object)("  Subject DN: " + cert.getSubjectDN()));
                        LOG.debug((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                        LOG.debug((Object)("  Valid from: " + cert.getNotBefore()));
                        LOG.debug((Object)("  Valid until: " + cert.getNotAfter()));
                        LOG.debug((Object)("  Issuer: " + cert.getIssuerDN()));
                    }
                }
                trustmanagers = AuthSSLProtocolSocketFactory.createTrustManagers(keystore);
            }
            this.sslcontext = SSLContext.getInstance("TLSv1");
            this.sslcontext.init(keymanagers, trustmanagers, null);
            if (this.m_ciphers == null) {
                this.m_ciphers = this.sslcontext.getSocketFactory().getSupportedCipherSuites();
            }
            return this.sslcontext;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new AuthSSLInitializationError(JCSMPRB.BUNDLE.getStringSafely("AuthSSLProtocolSocketFactory.unsupportedAlgorithmException") + e.getMessage());
        }
        catch (KeyStoreException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new AuthSSLInitializationError(JCSMPRB.BUNDLE.getStringSafely("AuthSSLProtocolSocketFactory.keystoreException") + e.getMessage());
        }
        catch (GeneralSecurityException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new AuthSSLInitializationError(JCSMPRB.BUNDLE.getStringSafely("AuthSSLProtocolSocketFactory.keyManagementException") + e.getMessage());
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            LOG.error((Object)JCSMPRB.BUNDLE.getStringSafely("AuthSSLProtocolSocketFactory.checkThatKeystoreOrTruststoreFileExists"));
            throw new AuthSSLInitializationError(JCSMPRB.BUNDLE.getStringSafely("AuthSSLProtocolSocketFactory.ioErrorReadingTruststoreKeystoreFile") + e.getMessage());
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext();
        }
        return this.sslcontext;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        SSLSocket s = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
        if (s != null) {
            if (this.m_listener != null) {
                s.addHandshakeCompletedListener(this.m_listener);
            }
            if (this.m_ciphers != null) {
                s.setEnabledCipherSuites(this.m_ciphers);
            }
            s.setKeepAlive(true);
        }
        return s;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket s = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(host, port);
        if (s != null) {
            if (this.m_listener != null) {
                s.addHandshakeCompletedListener(this.m_listener);
            }
            if (this.m_ciphers != null) {
                s.setEnabledCipherSuites(this.m_ciphers);
            }
            s.setKeepAlive(true);
        }
        return s;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket s = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
        if (s != null) {
            if (this.m_listener != null) {
                s.addHandshakeCompletedListener(this.m_listener);
            }
            if (this.m_ciphers != null) {
                s.setEnabledCipherSuites(this.m_ciphers);
            }
            s.setKeepAlive(true);
        }
        return s;
    }
}

