/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionImpl;
import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolTopicSession;
import com.solacesystems.jms.impl.JCSMPXASession;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.message.SolMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.TransactionInProgressException;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolXATopicSession
extends SolTopicSession
implements XATopicSession {
    private static final String Component = "XATopicSession";
    private static final Log log = LogFactory.getLog(SolXATopicSession.class);
    protected XASessionImpl mXASession;

    public SolXATopicSession(SolConnectionIF connection, JMSState state) throws JMSException {
        super(connection, false, 1, state);
        this.mSessionProps.enableXA();
        try {
            this.mXASession = (XASessionImpl)connection.getProperties().getJCSMPSession().createXASession();
            this.mSessionProps.getUserProperties().put("XASession", new JCSMPXASession(this.mXASession));
        }
        catch (JCSMPException e) {
            throw Validator.createJMSException("soljms.operation.session.create", (Throwable)((Object)e));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SolXATopicSession created. State: " + (Object)((Object)state)));
        }
    }

    public Session getSession() throws JMSException {
        return this;
    }

    public synchronized XAResource getXAResource() {
        try {
            return this.mXASession.getXAResource();
        }
        catch (JCSMPException e) {
            return null;
        }
    }

    public void trackMessage(Message message) throws JMSException {
        try {
            this.mXASession.trackMessage(((SolMessage)message).getMessage());
        }
        catch (JCSMPException e) {
            throw Validator.createJMSException("soljms.operation.session.create", (Throwable)((Object)e));
        }
    }

    public void setParentSession(XASessionImpl parentSession) {
        this.mXASession.setParent(parentSession);
    }

    public String getName() {
        if (this.mXASession != null) {
            return this.mXASession.getName();
        }
        return super.getName();
    }

    public TopicSession getTopicSession() throws JMSException {
        return this;
    }

    public void commit() throws JMSException {
        throw new TransactionInProgressException("Can't commit() inside an XATopicSession");
    }

    public boolean getTransacted() throws JMSException {
        return super.getTransacted();
    }

    public void rollback() throws JMSException {
        throw new TransactionInProgressException("Can't rollback() inside an XATopicSession");
    }
}

