/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solacesystems.common.HostInfo;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.protocol.nio.IOReactor;
import com.solacesystems.jcsmp.protocol.smf.SSLSmfClient;
import com.solacesystems.jcsmp.protocol.smf.SimpleSmfClient;
import com.solacesystems.jcsmp.protocol.smf.ZSmfClient;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeBasicParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeClientCertificateParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeKRBParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeParameters;
import com.solacesystems.jcsmp.secure.SecureProperties;

public class SimpleSmfClientFactory {
    public static SimpleSmfClient constructAndInit(JCSMPProperties prop, JCSMPChannelProperties channelProp, SecureProperties secureProps, HostInfo host, JCSMPSessionStats sessionStats, ContextImpl context) {
        AuthenticationSchemeParameters authParams;
        String username;
        JCSMPChannelProperties cprop = (JCSMPChannelProperties)channelProp.clone();
        String authScheme = prop.getStringProperty("AUTHENTICATION_SCHEME");
        if (authScheme.equals("AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE")) {
            username = prop.getStringProperty("username");
            authParams = new AuthenticationSchemeClientCertificateParameters(username, prop.isUsernameSet());
        } else if (authScheme.equals("AUTHENTICATION_SCHEME_GSS_KRB")) {
            String loginCtxName = prop.getStringProperty("JaasLoginContext");
            if (loginCtxName == null) {
                loginCtxName = "SolaceGSS";
            }
            authParams = new AuthenticationSchemeKRBParameters(loginCtxName, prop.getBooleanProperty("KRB_MUTUAL_AUTHENTICATION"), prop.getStringProperty("username"), prop.getStringProperty("KRB_SERVICE_NAME"), prop.getBooleanProperty("JaasConfigFileReloadEnabled"));
        } else {
            username = prop.getStringProperty("username");
            String password = prop.getStringProperty("password");
            if (password == null) {
                password = "";
            }
            password = password.trim();
            authParams = new AuthenticationSchemeBasicParameters(username, password);
        }
        boolean isZip = cprop.getCompressionLevel() > 0;
        boolean usePubIntermediateDirectBuf = prop.getBooleanProperty("pub_use_intermediate_direct_buf");
        SimpleSmfClient smfClient = isZip ? new ZSmfClient(authParams, sessionStats, (IOReactor)context.getIOReactor(), cprop.getCompressionLevel()) : (host.isSecure() ? new SSLSmfClient(authParams, sessionStats, context.getIOReactor(), usePubIntermediateDirectBuf, secureProps) : new SimpleSmfClient(authParams, sessionStats, context.getIOReactor(), usePubIntermediateDirectBuf));
        smfClient.setConnTimeout(cprop.getConnectTimeoutInMillis());
        smfClient.setSockTimeout(cprop.getReadTimeoutInMillis());
        smfClient.setClientProps(cprop);
        smfClient.setRemoteHost(host);
        smfClient.setTcpNoDelay(cprop.isTcpNoDelay());
        smfClient.setSO_rcvbuf(cprop.getReceiveBuffer());
        smfClient.setSO_sndbuf(cprop.getSendBuffer());
        return smfClient;
    }
}

