/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jms.SolMessageProducer;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.impl.Validator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public class SolTopicPublisher
extends SolMessageProducer
implements TopicPublisher {
    private final LogWrapper log = new LogWrapper(SolTopicPublisher.class);
    private static final String Component = "TopicPublisher";

    SolTopicPublisher(SolSessionIF session, Topic topic) throws JMSException {
        super(session, (Destination)topic);
        this.log.setContextInfo(this.getLogContextInfo());
        if (this.log.isDebugEnabled()) {
            this.log.debug("SolTopicPublisher created.  Topic: " + (topic == null ? "null" : topic.getTopicName()));
        }
    }

    public synchronized Topic getTopic() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return (Topic)this.mDestination;
    }

    public void publish(Message message) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering publish()");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, null);
        Validator.checkMessage(message);
        this.sendMessage(this.mDestination, message, this.mDeliveryMode, this.mPriority, this.mTimeToLive);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving publish()");
        }
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering publish()");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, null);
        Validator.checkMessage(message);
        Validator.checkDeliveryMode(deliveryMode);
        Validator.checkPriority(priority);
        Validator.checkTimeToLive(timeToLive);
        this.sendMessage(this.mDestination, message, deliveryMode, priority, timeToLive);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving publish()");
        }
    }

    public void publish(Topic topic, Message message) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering publish()");
        }
        Validator.checkClosed(this.mState, Component);
        Destination destination = Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, (Destination)topic);
        Validator.checkMessage(message);
        this.sendMessage(destination, message, this.mDeliveryMode, this.mPriority, this.mTimeToLive);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving publish()");
        }
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering publish()");
        }
        Validator.checkClosed(this.mState, Component);
        Destination destination = Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, (Destination)topic);
        Validator.checkMessage(message);
        Validator.checkDeliveryMode(deliveryMode);
        Validator.checkPriority(priority);
        Validator.checkTimeToLive(timeToLive);
        this.sendMessage(destination, message, deliveryMode, priority, timeToLive);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving publish()");
        }
    }
}

