/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.sdt;

import com.solacesystems.jcsmp.BytesMessage;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.MapMessage;
import com.solacesystems.jcsmp.Producer;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.SDTUnknownType;
import com.solacesystems.jcsmp.StreamMessage;
import com.solacesystems.jcsmp.TextMessage;
import com.solacesystems.jcsmp.XMLContentMessage;
import com.solacesystems.jcsmp.impl.TopicImpl;
import com.solacesystems.jcsmp.impl.sdt.InteropTest;
import com.solacesystems.jcsmp.impl.sdt.MapImpl;
import com.solacesystems.jcsmp.impl.sdt.StreamImpl;
import com.solacesystems.jcsmp.impl.sdt.TLVBuffer;
import com.solacesystems.jcsmp.impl.sdt.UnsupportedTLV;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class JMSInteropTest {
    public int testNo;
    public String jmsMsgID;
    public String jmsType;
    public String jmsCorrelationID;
    public SDTMap jmsProps;
    public Destination jmsReplyTo;
    public Long jmsSendTs;
    public byte jmsMessageType;
    public Object payload;
    public boolean payloadJMSCompat;
    public static final int MIN_INTEROP_ID = 1;
    public static final int MAX_INTEROP_ID = 16;
    public static final Map<Integer, JMSInteropTest> Tests = JMSInteropTest.initTests();

    private static Map<Integer, JMSInteropTest> initTests() {
        String methodPrefix = "interopTest";
        int methodPrefixLength = "interopTest".length();
        TreeMap<Integer, JMSInteropTest> tests = new TreeMap<Integer, JMSInteropTest>();
        try {
            Method[] methods = JMSInteropTest.class.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().startsWith("interopTest")) continue;
                JMSInteropTest test = (JMSInteropTest)methods[i].invoke(null, (Object[])null);
                test.testNo = Integer.valueOf(methods[i].getName().substring(methodPrefixLength));
                tests.put(test.testNo, test);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tests;
    }

    public static int validateRecvMsg(BytesXMLMessage msg) throws SDTException, IOException, ClassNotFoundException {
        JMSInteropTest test = null;
        byte[] userData = msg.getUserData();
        if (userData == null || userData.length == 0) {
            throw new IllegalArgumentException("no test number specified in user data");
        }
        test = Tests.get(userData[0]);
        if (test == null) {
            throw new IllegalArgumentException("unknown test number specified - " + userData[0]);
        }
        InteropTest.testValues(test.jmsMsgID, msg.getAppMessageID(), test.testNo, "App Message IDs don't match");
        InteropTest.testValues(test.jmsType, msg.getAppMessageType(), test.testNo, "App Message Types don't match");
        InteropTest.testValues(test.jmsCorrelationID, msg.getCorrelationId(), test.testNo, "Correlation IDs don't match");
        InteropTest.testMapValues(test.jmsProps, msg.getProperties(), test.testNo, "User Properties don't match");
        InteropTest.testValues(test.jmsReplyTo, msg.getReplyTo(), test.testNo, "ReplyTos don't match");
        InteropTest.testSendTimestamps(test.jmsSendTs, msg.getSendTimestamp(), test.testNo, "Send Timestamps don't match");
        InteropTest.testValues(test.jmsMessageType, msg.getStructuredMsgType(), test.testNo, "Message Types don't match");
        if (test.jmsMessageType == 10) {
            InteropTest.testMapValues((SDTMap)test.payload, ((MapMessage)msg).getMap(), test.testNo, "Map Payloads don't match");
        } else if (test.jmsMessageType == 11) {
            InteropTest.testStreamValues((SDTStream)test.payload, ((StreamMessage)msg).getStream(), test.testNo, "Stream Payloads don't match");
        } else if (test.jmsMessageType == 7) {
            InteropTest.testValues(test.payload, ((TextMessage)msg).getText(), test.testNo, "text values don't match");
        } else if (test.jmsMessageType == 2) {
            JMSInteropTest.testBytesValues((byte[])test.payload, msg, test.testNo);
        } else if (test.jmsMessageType == 3) {
            JMSInteropTest.testObjectValues(test.payload, msg, test.testNo);
        } else if (test.jmsMessageType != 4) {
            if (test.jmsMessageType == 1) {
                InteropTest.testValues(test.payload, ((XMLContentMessage)msg).getXMLContent(), test.testNo, "text values don't match");
            } else {
                throw new IllegalArgumentException(InteropTest.getErrorStr(test.testNo, "Unknown structured message type"));
            }
        }
        return test.testNo;
    }

    public static void testBytesValues(byte[] expected, BytesXMLMessage received, int testNo) throws SDTException {
        if (expected == null) {
            if (received.getAttachmentContentLength() != 0) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNo, "bytes difference, expected none"));
            }
        } else {
            byte[] receivedBytes = new byte[received.getAttachmentContentLength()];
            received.readAttachmentBytes(receivedBytes);
            InteropTest.testBytes(expected, receivedBytes, testNo, "bytes values don't match");
        }
    }

    public static void testObjectValues(Object expected, BytesXMLMessage received, int testNo) throws SDTException, IOException, ClassNotFoundException {
        if (expected == null) {
            if (received.getAttachmentContentLength() != 0) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNo, "object difference, expected none"));
            }
        } else {
            byte[] receivedBytes = new byte[received.getAttachmentContentLength()];
            received.readAttachmentBytes(receivedBytes);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(receivedBytes));
            if (!expected.equals(in.readObject())) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNo, "object values don't match"));
            }
        }
    }

    public static BytesXMLMessage createMessageByNumber(Producer producer, Integer msgId) throws JCSMPException, IOException {
        JMSInteropTest interopTest = null;
        switch (msgId) {
            case 1: {
                interopTest = JMSInteropTest.interopTest1();
                break;
            }
            case 2: {
                interopTest = JMSInteropTest.interopTest2();
                break;
            }
            case 3: {
                interopTest = JMSInteropTest.interopTest3();
                break;
            }
            case 4: {
                interopTest = JMSInteropTest.interopTest4();
                break;
            }
            case 5: {
                interopTest = JMSInteropTest.interopTest5();
                break;
            }
            case 6: {
                interopTest = JMSInteropTest.interopTest6();
                break;
            }
            case 7: {
                interopTest = JMSInteropTest.interopTest7();
                break;
            }
            case 8: {
                interopTest = JMSInteropTest.interopTest8();
                break;
            }
            case 9: {
                interopTest = JMSInteropTest.interopTest9();
                break;
            }
            case 10: {
                interopTest = JMSInteropTest.interopTest10();
                break;
            }
            case 11: {
                interopTest = JMSInteropTest.interopTest11();
                break;
            }
            case 12: {
                interopTest = JMSInteropTest.interopTest12();
                break;
            }
            case 13: {
                interopTest = JMSInteropTest.interopTest13();
                break;
            }
            case 14: {
                interopTest = JMSInteropTest.interopTest14();
                break;
            }
            case 15: {
                interopTest = JMSInteropTest.interopTest15();
                break;
            }
            case 16: {
                interopTest = JMSInteropTest.interopTest16();
                break;
            }
            default: {
                throw new JCSMPException("Unexpected msgId: " + msgId);
            }
        }
        interopTest.testNo = msgId;
        return JMSInteropTest.createJCSMPMessage(producer, interopTest);
    }

    public static BytesXMLMessage createJCSMPMessage(Producer producer, JMSInteropTest test) throws JCSMPException, IOException {
        BytesXMLMessage message;
        if (test.jmsMessageType == 2) {
            message = producer.createBytesMessage();
            message.setStructuredMsg(false);
            message.setStructuredMsgType((byte)2);
            if (test.payload instanceof byte[]) {
                ((BytesMessage)message).writeAttachment((byte[])test.payload);
            }
        } else if (test.jmsMessageType == 10) {
            message = producer.createMapMessage();
            if (test.payload != null) {
                ((MapMessage)message).setMap((SDTMap)test.payload);
            }
        } else if (test.jmsMessageType == 3) {
            message = producer.createBytesMessage();
            message.setStructuredMsg(false);
            message.setStructuredMsgType((byte)3);
            if (test.payload != null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bos);
                out.writeObject(test.payload);
                out.close();
                ((BytesMessage)message).setData(bos.toByteArray());
            }
        } else if (test.jmsMessageType == 11) {
            message = producer.createStreamMessage();
            if (test.payload != null) {
                ((StreamMessage)message).setStream((SDTStream)test.payload);
            }
        } else if (test.jmsMessageType == 7) {
            message = producer.createTextMessage();
            ((TextMessage)message).setText((String)test.payload);
        } else if (test.jmsMessageType == 1) {
            message = producer.createXMLContentMessage();
            ((XMLContentMessage)message).setXMLContent((String)test.payload);
        } else if (test.jmsMessageType == 4) {
            message = producer.createBytesXMLMessage();
            message.setStructuredMsg(false);
            message.setStructuredMsgType((byte)4);
        } else {
            throw new IllegalArgumentException("illegal jms message type");
        }
        message.setUserData(new byte[]{(byte)test.testNo});
        message.setDeliveryMode(DeliveryMode.NON_PERSISTENT);
        message.setAppMessageID(test.jmsMsgID);
        message.setAppMessageType(test.jmsType);
        message.setCorrelationId(test.jmsCorrelationID);
        if (test.jmsProps != null) {
            message.setProperties(test.jmsProps);
        }
        message.setReplyTo(test.jmsReplyTo);
        if (test.jmsSendTs != null) {
            message.setSendTimestamp(test.jmsSendTs);
        }
        return message;
    }

    public static JMSInteropTest interopTest1() {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillNullHeaderProperties(test);
        test.jmsMessageType = (byte)2;
        test.payload = null;
        test.payloadJMSCompat = true;
        return test;
    }

    public static JMSInteropTest interopTest2() {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillNullHeaderProperties(test);
        test.jmsMessageType = (byte)10;
        test.payload = null;
        test.payloadJMSCompat = true;
        return test;
    }

    public static JMSInteropTest interopTest3() {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillNullHeaderProperties(test);
        test.jmsMessageType = (byte)3;
        test.payload = null;
        test.payloadJMSCompat = true;
        return test;
    }

    public static JMSInteropTest interopTest4() {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillNullHeaderProperties(test);
        test.jmsMessageType = (byte)4;
        test.payload = null;
        test.payloadJMSCompat = true;
        return test;
    }

    public static JMSInteropTest interopTest5() {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillNullHeaderProperties(test);
        test.jmsMessageType = (byte)11;
        test.payload = null;
        test.payloadJMSCompat = true;
        return test;
    }

    public static JMSInteropTest interopTest6() {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillNullHeaderProperties(test);
        test.jmsMessageType = (byte)7;
        test.payload = null;
        test.payloadJMSCompat = true;
        return test;
    }

    public static JMSInteropTest interopTest7() {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillNullHeaderProperties(test);
        test.jmsMessageType = 1;
        test.payload = null;
        test.payloadJMSCompat = true;
        return test;
    }

    public static JMSInteropTest interopTest8() throws SDTException {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillHeaderProperties(test);
        test.jmsMessageType = (byte)2;
        byte[] data = new byte[256];
        for (int i = 0; i < 256; ++i) {
            data[i] = (byte)i;
        }
        test.payload = data;
        test.payloadJMSCompat = true;
        return test;
    }

    public static JMSInteropTest interopTest9() throws SDTException {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillHeaderProperties(test);
        test.jmsMessageType = (byte)10;
        MapImpl map = new MapImpl();
        map.putBoolean("booleanValue", true);
        map.putByte("byteValue", (byte)9);
        map.putShort("shortValue", (short)12);
        map.putCharacter("charValue", Character.valueOf('x'));
        map.putInteger("intValue", 111);
        map.putLong("longValue", 9999999999L);
        map.putFloat("floatValue", Float.valueOf(111.222f));
        map.putDouble("doubleValue", 9.87654321E7);
        map.putString("StringValue", "this is a string value");
        map.putBytes("bytesValue", new byte[]{5, 6, 7, 1, 2, 3});
        test.payload = map;
        test.payloadJMSCompat = true;
        return test;
    }

    public static JMSInteropTest interopTest10() throws SDTException {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillHeaderProperties(test);
        test.jmsMessageType = (byte)3;
        test.payload = "a serialized string object";
        test.payloadJMSCompat = true;
        return test;
    }

    public static JMSInteropTest interopTest11() throws SDTException {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillHeaderProperties(test);
        test.jmsMessageType = (byte)4;
        test.payload = null;
        test.payloadJMSCompat = true;
        return test;
    }

    public static JMSInteropTest interopTest12() throws SDTException {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillHeaderProperties(test);
        test.jmsMessageType = (byte)11;
        StreamImpl stream = new StreamImpl();
        stream.writeBoolean(true);
        stream.writeByte((byte)9);
        stream.writeShort((short)12);
        stream.writeCharacter(Character.valueOf('x'));
        stream.writeInteger(111);
        stream.writeLong(9999999999L);
        stream.writeFloat(Float.valueOf(111.222f));
        stream.writeDouble(9.87654321E7);
        stream.writeString("this is a string value");
        stream.writeBytes(new byte[]{5, 6, 7, 1, 2, 3});
        test.payload = stream;
        test.payloadJMSCompat = true;
        return test;
    }

    public static JMSInteropTest interopTest13() throws SDTException {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillHeaderProperties(test);
        test.jmsMessageType = (byte)7;
        StringBuilder bldr = new StringBuilder();
        for (int i = 1; i < 128; ++i) {
            bldr.append((char)i);
        }
        test.payload = bldr.toString();
        test.payloadJMSCompat = true;
        return test;
    }

    public static JMSInteropTest interopTest14() throws SDTException {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillHeaderProperties(test);
        test.jmsMessageType = 1;
        test.payload = "<test>this is an xml string value</test>";
        test.payloadJMSCompat = true;
        return test;
    }

    public static JMSInteropTest interopTest15() throws SDTException {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillHeaderProperties(test);
        test.jmsMessageType = (byte)10;
        MapImpl map = new MapImpl();
        map.putBoolean("booleanValue", true);
        MapImpl innerMap = new MapImpl();
        innerMap.putByte("innerByteValue", (byte)13);
        map.putMap("innerMap", innerMap);
        StreamImpl innerStream = new StreamImpl();
        innerStream.writeFloat(Float.valueOf(13.13f));
        map.putStream("innerStream", innerStream);
        map.putDestination("destinationValue", TopicImpl.createFastNoValidation("level1/level2"));
        map.putObject("bigIntValue", new BigInteger("9223372036854775807"));
        map.putObject("unsupportedValue", JMSInteropTest.createUnsupported());
        test.payload = map;
        test.payloadJMSCompat = false;
        return test;
    }

    public static JMSInteropTest interopTest16() throws SDTException {
        JMSInteropTest test = new JMSInteropTest();
        JMSInteropTest.fillHeaderProperties(test);
        test.jmsMessageType = (byte)11;
        StreamImpl stream = new StreamImpl();
        stream.writeBoolean(true);
        MapImpl innerMap = new MapImpl();
        innerMap.putByte("innerByteValue", (byte)13);
        stream.writeMap(innerMap);
        StreamImpl innerStream = new StreamImpl();
        innerStream.writeFloat(Float.valueOf(13.13f));
        stream.writeStream(innerStream);
        stream.writeDestination(TopicImpl.createFastNoValidation("level1/level2"));
        stream.writeObject(new BigInteger("9223372036854775807"));
        stream.writeObject(JMSInteropTest.createUnsupported());
        test.payload = stream;
        test.payloadJMSCompat = false;
        return test;
    }

    private static void fillHeaderProperties(JMSInteropTest test) throws SDTException {
        test.jmsMsgID = "JMS Message ID";
        test.jmsType = "JMS Message Type";
        test.jmsCorrelationID = "JMS Correlation ID";
        test.jmsReplyTo = TopicImpl.createFastNoValidation("JMS ReplyTo Topic");
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1981, 11, 2, 0, 0, 0);
        test.jmsSendTs = cal.getTimeInMillis() / 1000L * 1000L;
        MapImpl props = new MapImpl();
        props.putBoolean("booleanProp", true);
        props.putByte("byteProp", (byte)123);
        props.putShort("shortProp", (short)12345);
        props.putInteger("intProp", 1234567);
        props.putLong("longProp", 1234567890L);
        props.putFloat("floatProp", Float.valueOf(123.456f));
        props.putDouble("doubleProp", 123456.789);
        props.putString("stringProp", "this is a string");
        test.jmsProps = props;
    }

    private static void fillNullHeaderProperties(JMSInteropTest test) {
        test.jmsMsgID = null;
        test.jmsType = null;
        test.jmsCorrelationID = null;
        test.jmsReplyTo = null;
        test.jmsSendTs = null;
        test.jmsProps = null;
    }

    private static SDTUnknownType createUnsupported() {
        TLVBuffer buffer = new TLVBuffer(3);
        buffer.writeTagAndLength((byte)63, 1);
        buffer.writeRawByte((byte)0);
        return new UnsupportedTLV(UnsupportedTLV.Reason.UnsupportedTag, 63, "Testing", buffer.asByteArray());
    }
}

