/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.impl.XMLMessageQueueList;

public class XMLMessageQueue {
    private static final int WAIT_TIMEOUT = 100;
    private boolean closed = false;
    private boolean stopped = true;
    private XMLMessageQueueList internalList;
    private String name;
    private int congestionLimit;
    private int uncongestedMark;

    public XMLMessageQueue(String name, int congestionLimit, int uncongestedThreshold) {
        this.name = name;
        this.internalList = new XMLMessageQueueList();
        this.congestionLimit = congestionLimit;
        this.uncongestedMark = uncongestedThreshold;
    }

    public String toString() {
        return "XMLMessageQueue[name=" + this.name + " size=" + this.size() + "]";
    }

    public void stop() {
        this.stopped = true;
    }

    public void start() {
        this.stopped = false;
        this.getLock().notifyAll();
    }

    public Object getLock() {
        return this.internalList;
    }

    public int size() {
        return this.internalList.size();
    }

    public int capacityToCongestion() {
        return Math.max(0, this.congestionLimit - this.size());
    }

    public int getUncongestedMark() {
        return this.uncongestedMark;
    }

    public void close() {
        this.clear();
        this.closed = true;
        this.getLock().notifyAll();
    }

    public void clear() {
        this.internalList.clear();
    }

    public int enqueue(Object message) {
        if (!this.closed) {
            this.internalList.add(message);
            this.getLock().notifyAll();
            return this.capacityToCongestion();
        }
        return 0;
    }

    public Object dequeue() throws InterruptedException {
        Object message = null;
        while (!this.closed) {
            while ((this.internalList.size() == 0 || this.stopped) && !this.closed) {
                this.getLock().wait(100L);
            }
            message = this.dequeueNoWait();
            if (message == null) continue;
            break;
        }
        return message;
    }

    public Object dequeue(long timeInMillis) throws InterruptedException {
        Object message = null;
        if (timeInMillis == 0L) {
            message = this.dequeue();
        } else {
            long start;
            long waitTime = timeInMillis;
            long l = start = timeInMillis <= 0L ? 0L : System.currentTimeMillis();
            while (!this.closed && (message = this.dequeueNoWait()) == null && waitTime > 0L) {
                this.getLock().wait(waitTime);
                waitTime = timeInMillis - (System.currentTimeMillis() - start);
            }
        }
        return message;
    }

    public Object dequeueNoWait() throws InterruptedException {
        if (!this.stopped) {
            return this.internalList.removeFirst();
        }
        return null;
    }

    public void visit(XMLMessageQueueList.Visitor visitor) {
        this.internalList.visit(visitor);
    }
}

