/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.common.SolReserved;
import com.solacesystems.jcsmp.InvalidPropertiesException;
import java.io.Serializable;

public class JCSMPGlobalProperties
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int producerDispatcherQueueSize = 2000;
    private int consumerDispatcherQueueSize = 75000;
    private int consumerDefaultFlowCongestionLimit = 5000;
    private int reconnectFreqManagerMaxReconnects = 10;
    private int contentBufferResizeMultiplier = 25;
    private int contentBufferSizeDefault = 4096;
    private static boolean _dropInternalReplies = true;

    public Object clone() {
        JCSMPGlobalProperties props = new JCSMPGlobalProperties();
        props.producerDispatcherQueueSize = this.producerDispatcherQueueSize;
        props.consumerDispatcherQueueSize = this.consumerDispatcherQueueSize;
        props.consumerDefaultFlowCongestionLimit = this.consumerDefaultFlowCongestionLimit;
        props.reconnectFreqManagerMaxReconnects = this.reconnectFreqManagerMaxReconnects;
        props.contentBufferResizeMultiplier = this.contentBufferResizeMultiplier;
        props.contentBufferSizeDefault = this.contentBufferSizeDefault;
        return props;
    }

    public int getProducerDispatcherQueueSize() {
        return this.producerDispatcherQueueSize;
    }

    public void setProducerDispatcherQueueSize(int producerDispatcherQueueSize) {
        this.producerDispatcherQueueSize = producerDispatcherQueueSize;
    }

    public int getConsumerDispatcherQueueSize() {
        return this.consumerDispatcherQueueSize;
    }

    public void setConsumerDispatcherQueueSize(int consumerDispatcherQueueSize) {
        this.consumerDispatcherQueueSize = consumerDispatcherQueueSize;
    }

    public int getConsumerDefaultFlowCongestionLimit() {
        return this.consumerDefaultFlowCongestionLimit;
    }

    public void setConsumerDefaultFlowCongestionLimit(int consumerDefaultFlowCongestionLimit) {
        this.consumerDefaultFlowCongestionLimit = consumerDefaultFlowCongestionLimit;
    }

    public int getConsumerDefaultFlowUncongestedLimit() {
        return Math.max(this.consumerDefaultFlowCongestionLimit / 5, 1);
    }

    public int getReconnectFreqManagerMaxReconnects() {
        return this.reconnectFreqManagerMaxReconnects;
    }

    public void setReconnectFreqManagerMaxReconnects(int reconnectFreqManagerMaxReconnects) {
        this.reconnectFreqManagerMaxReconnects = reconnectFreqManagerMaxReconnects;
    }

    public int getContentBufferResizeMultiplier() {
        return this.contentBufferResizeMultiplier;
    }

    public void setContentBufferResizeMultiplier(int multiplier) {
        this.contentBufferResizeMultiplier = multiplier;
    }

    public int getContentBufferSizeDefault() {
        return this.contentBufferSizeDefault;
    }

    public void setContentBufferSizeDefault(int sz) throws InvalidPropertiesException {
        if (sz < 4096) {
            throw new InvalidPropertiesException("minimum default size is 4096");
        }
        this.contentBufferSizeDefault = sz;
    }

    @SolReserved
    public static boolean shouldDropInternalReplyMessages() {
        return _dropInternalReplies;
    }

    @SolReserved
    public static void setShouldDropInternalReplyMessages(boolean dropIt) {
        _dropInternalReplies = dropIt;
    }
}

