/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SNIUtil {
    private static final Constructor<?> sniHostNameConstructor;
    private static final Method sniSetterMethod;
    private static final Log LOGGER;

    private static Constructor<?> loadSNIHostNameConstructor() {
        try {
            return Class.forName("javax.net.ssl.SNIHostName").getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error((Object)"SNI disabled for Java SDK below 1.8 or Android version earlier than 7.0", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"SNI disabled for Java SDK below 1.8 or Android version earlier than 7.0", (Throwable)e);
        }
        return null;
    }

    private static Method loadSetServerNames() {
        try {
            return Class.forName("javax.net.ssl.SSLParameters").getMethod("setServerNames", List.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private static Object createNewSNIHostNameObject(String hostname) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return sniHostNameConstructor.newInstance(hostname);
    }

    private static List<Object> createSNIHostNames(String ... hostNames) throws IllegalAccessException, InstantiationException {
        ArrayList<Object> list = new ArrayList<Object>(hostNames.length);
        for (String hostname : hostNames) {
            try {
                list.add(SNIUtil.createNewSNIHostNameObject(hostname));
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return list;
    }

    public static void setServerNames(SSLParameters parameters, String ... hostNames) {
        block7: {
            if (sniHostNameConstructor == null || sniSetterMethod == null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)"Server Name Indication (SNI) can't be applied, this feature is supported in JDK 1.8 and newer only");
                }
                return;
            }
            try {
                List<Object> sniHostNames = SNIUtil.createSNIHostNames(hostNames);
                sniSetterMethod.invoke((Object)parameters, sniHostNames);
                if (LOGGER.isInfoEnabled() && !sniHostNames.isEmpty()) {
                    LOGGER.info((Object)"Server Name Indication (SNI) automatically applied by using provided hostname");
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)"Server Name Indication (SNI) parameter is not applied", (Throwable)e);
                }
            }
            catch (InvocationTargetException e) {
                if (!LOGGER.isWarnEnabled()) break block7;
                LOGGER.warn((Object)"Server Name Indication (SNI) parameter is not applied", (Throwable)e);
            }
        }
    }

    static {
        Method setServerNamesMethod;
        LOGGER = LogFactory.getLog(SNIUtil.class);
        Constructor<?> sniHostNameClassConstructor = SNIUtil.loadSNIHostNameConstructor();
        sniSetterMethod = setServerNamesMethod = SNIUtil.loadSetServerNames();
        sniHostNameConstructor = sniHostNameClassConstructor;
    }
}

