/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import com.solacesystems.common.ChainedException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CommonUtils {
    private static final String LOCALHOST_NAME;
    private static final String LOCALHOST_IP;

    public static Object newInstance(String className) throws ChainedException {
        if (className == null) {
            throw new ChainedException("cannot classLoadFromName(null)");
        }
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception ex) {
            throw new ChainedException("failed to newInstance of " + className, ex);
        }
    }

    public static void waitFor(long howLong) {
        try {
            Thread.sleep(howLong);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static boolean areEqual(String[] a, String[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length == b.length) {
            for (int i = 0; i < a.length; ++i) {
                if (a[i].equals(b[i])) continue;
                return false;
            }
        }
        return false;
    }

    public static final List<Object> createShallowCopy(List<Object> old) {
        if (old != null) {
            ArrayList<Object> l = new ArrayList<Object>();
            Iterator<Object> iter = old.iterator();
            while (iter.hasNext()) {
                l.add(iter.next());
            }
            return l;
        }
        return null;
    }

    public static boolean isLocalAddress(String address) {
        if (address == null || address.trim().equals("")) {
            return false;
        }
        return address.trim().toUpperCase().equals(LOCALHOST_NAME.toUpperCase()) || address.trim().toUpperCase().equals(LOCALHOST_IP.toUpperCase());
    }

    public static String getFileName(String filePath) {
        int index = filePath.lastIndexOf(File.pathSeparator);
        String fileName = filePath.substring(index + 1, filePath.length());
        return CommonUtils.trimFileName(fileName);
    }

    public static String sanitizeFilename(String filename) {
        char[] fchars = filename.toCharArray();
        for (int i = 0; i < fchars.length; ++i) {
            char c = fchars[i];
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '[' || c == ']' || c == '.') continue;
            fchars[i] = 95;
        }
        return new String(fchars);
    }

    public static String trimFileName(String fileName) {
        String trimName = "";
        trimName = fileName.trim().length() > 36 ? fileName.trim().substring(0, 36) : fileName.trim();
        return trimName;
    }

    public static final String loadTextFile(String textFileName) throws ChainedException {
        if (textFileName == null || textFileName.equals("")) {
            throw new ChainedException("Unable to load file since it's absolute path is empty or null");
        }
        File file = new File(textFileName);
        if (!file.exists()) {
            throw new ChainedException("Unable to load file '" + textFileName + "' because it does not exist anymore");
        }
        StringBuffer content = new StringBuffer();
        BufferedReader buffReader = null;
        char[] charBuff = new char[1024];
        try {
            buffReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));
            int numberOfCharsRead = buffReader.read(charBuff);
            while (numberOfCharsRead != -1) {
                content.append(charBuff, 0, numberOfCharsRead);
                numberOfCharsRead = buffReader.read(charBuff);
            }
            buffReader.close();
            return content.toString();
        }
        catch (IOException ex) {
            if (buffReader != null) {
                try {
                    buffReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ChainedException("Unable to load file '" + textFileName + "'", ex);
        }
    }

    public static final FileInputStream loadFile(String textFileName) throws ChainedException {
        if (textFileName == null || textFileName.equals("")) {
            throw new ChainedException("Unable to load file since it's absolute path is empty or null");
        }
        try {
            return new FileInputStream(textFileName);
        }
        catch (FileNotFoundException fne) {
            throw new ChainedException("Unable to load file '" + textFileName + "' because it does not exist anymore");
        }
    }

    static {
        String locName = "";
        String locIp = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            byte[] ipAddr = addr.getAddress();
            locName = addr.getHostName();
            String ipAddrString = "";
            for (int i = 0; i < ipAddr.length; ++i) {
                if (i > 0) {
                    ipAddrString = ipAddrString + ".";
                }
                ipAddrString = ipAddrString + (ipAddr[i] & 0xFF);
            }
            locIp = ipAddrString;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        LOCALHOST_NAME = locName;
        LOCALHOST_IP = locIp;
    }
}

