/*
 * Decompiled with CFR 0.152.
 */
package com.solace.transport.impl.netty;

import com.solace.transport.TransportExecutorService;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.nio.NioIoHandler;
import io.netty.util.Version;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class NettyTransportExecutorService
implements TransportExecutorService {
    private static final Log Trace = LogFactory.getLog(NettyTransportExecutorService.class);
    private final EventLoopGroup eventLoopGroup;
    private final boolean epollEnabled;

    public NettyTransportExecutorService(String name) {
        Map versionInfo = Version.identify();
        String versionStr = versionInfo.isEmpty() ? "Netty (Version Unresolvable)" : "Netty " + ((Version)versionInfo.values().iterator().next()).artifactVersion();
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)("Netty version identify: " + versionInfo.toString()));
        }
        this.epollEnabled = Epoll.isAvailable();
        if (this.epollEnabled) {
            if (Trace.isInfoEnabled()) {
                Trace.info((Object)("Epoll is enabled; " + versionStr));
            }
            this.eventLoopGroup = new MultiThreadIoEventLoopGroup(1, (ThreadFactory)((Object)new IdentifyingThreadFactory(name)), EpollIoHandler.newFactory());
        } else {
            if (Trace.isInfoEnabled()) {
                Trace.info((Object)("Epoll is not available; " + versionStr));
            }
            this.eventLoopGroup = new MultiThreadIoEventLoopGroup(1, (ThreadFactory)((Object)new IdentifyingThreadFactory(name)), NioIoHandler.newFactory());
        }
    }

    @Override
    public void shutdown() {
        this.eventLoopGroup.shutdownGracefully();
    }

    @Override
    public void shutdownNow() {
        this.eventLoopGroup.shutdownGracefully(2L, 10L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isShutdown() {
        return this.eventLoopGroup.isShutdown();
    }

    @Override
    public boolean isShuttingDown() {
        return this.eventLoopGroup.isShuttingDown();
    }

    @Override
    public boolean isTerminated() {
        return this.eventLoopGroup.isTerminated();
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.eventLoopGroup.schedule(callable, delay, unit);
    }

    @Override
    public boolean isManagedThread(Thread t) {
        return this.eventLoopGroup.next().inEventLoop(t);
    }

    @Override
    public boolean isManagedThread() {
        return this.isManagedThread(Thread.currentThread());
    }

    void bootstrap(Bootstrap bootstrap) {
        bootstrap.group(this.eventLoopGroup);
    }

    boolean isEpollSupported() {
        return this.epollEnabled;
    }

    class IdentifyingThreadFactory
    extends DefaultThreadFactory {
        public IdentifyingThreadFactory(String name) {
            super(name, true);
        }

        protected Thread newThread(Runnable r, String name) {
            Thread t = super.newThread(r, name);
            return t;
        }
    }
}

