/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jcsmp.ClosedFacilityException;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionImpl;
import com.solacesystems.jms.SolConnectionConsumerRA;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.SolXAQueueSession;
import com.solacesystems.jms.SolXASession;
import com.solacesystems.jms.SolXATopicSession;
import com.solacesystems.jms.impl.AckHandler;
import com.solacesystems.jms.impl.ConnectionConsumerXATransactionStrategy;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.message.SolMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.XASession;

public class SessionConnectionConsumerSupportRA {
    private Object mLock = new Object();
    private List<Message> mDispatchMessages = new ArrayList<Message>();
    private MessageListener mListener;
    private SolSessionIF mSession;
    private boolean xa = false;
    private AckHandler mAckHandler;
    private XASessionImpl mParentXaSession = null;

    public SessionConnectionConsumerSupportRA(SolSessionIF session, SolConnectionConsumerRA connConsumer) throws JMSException {
        this.mSession = session;
        this.xa = session instanceof XASession;
        this.updateParent(connConsumer);
        this.mAckHandler = connConsumer.getAckHandler();
    }

    public boolean updateParent(SolConnectionConsumerRA connConsumer) throws JMSException {
        if (this.xa) {
            XASessionImpl parentXaSession = ((ConnectionConsumerXATransactionStrategy)connConsumer.getAckTransaction()).getJCSMPXASession();
            try {
                parentXaSession.checkClosed();
            }
            catch (ClosedFacilityException e) {
                throw new JMSException(e.getMessage());
            }
            if (!parentXaSession.equals(this.mParentXaSession)) {
                if (this.mSession instanceof SolXAQueueSession) {
                    ((SolXAQueueSession)this.mSession).setParentSession(parentXaSession);
                } else if (this.mSession instanceof SolXATopicSession) {
                    ((SolXATopicSession)this.mSession).setParentSession(parentXaSession);
                } else {
                    ((SolXASession)this.mSession).setParentSession(parentXaSession);
                }
                this.mParentXaSession = parentXaSession;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMessages(Collection<Message> messages) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDispatchMessages.addAll(messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDispatchMessages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        MessageListener msgListener = null;
        ArrayList<Message> tempList = null;
        Iterator<Message> msgIterator = null;
        Object object = this.mLock;
        // MONITORENTER : object
        tempList = new ArrayList<Message>(this.mDispatchMessages);
        msgIterator = tempList.iterator();
        msgListener = this.mListener;
        // MONITOREXIT : object
        if (msgIterator.hasNext() && msgListener == null) {
            throw new IllegalStateException("MessageListener was null when attempting to deliver ConnectionConsumer message on Session");
        }
        try {
            while (msgIterator.hasNext()) {
                Message dispatchMsg = msgIterator.next();
                boolean messageProcessed = false;
                if (this.mSession.getState() == JMSState.Closed) {
                    return;
                }
                try {
                    if (this.xa) {
                        if (this.mSession instanceof SolXAQueueSession) {
                            ((SolXAQueueSession)this.mSession).trackMessage(dispatchMsg);
                        } else if (this.mSession instanceof SolXATopicSession) {
                            ((SolXATopicSession)this.mSession).trackMessage(dispatchMsg);
                        } else {
                            ((SolXASession)this.mSession).trackMessage(dispatchMsg);
                        }
                    }
                    msgListener.onMessage(dispatchMsg);
                    messageProcessed = true;
                }
                finally {
                    if (this.xa || !messageProcessed) continue;
                    this.mAckHandler.onMessageSent((SolMessage)dispatchMsg);
                }
            }
            return;
        }
        catch (JMSException e) {
            throw new RuntimeException("Error occurred while delivering a message - " + e.getMessage(), e);
        }
        finally {
            tempList.clear();
            tempList = null;
            this.close();
        }
    }
}

