/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPLoginFailureException;
import com.solacesystems.jcsmp.JCSMPSecurityException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.VersionNotSupportException;
import com.solacesystems.jcsmp.XMLMessage;

public class JCSMPUtils {
    public static boolean isAdMessage(XMLMessage message) {
        DeliveryMode type = message.getDeliveryMode();
        return type == DeliveryMode.PERSISTENT || type == DeliveryMode.NON_PERSISTENT;
    }

    public static boolean isDirectMessage(XMLMessage message) {
        return message.getDeliveryMode() == DeliveryMode.DIRECT;
    }

    public static boolean reconnectOnUnknownNames(JCSMPException e, String action) {
        JCSMPErrorResponseException respEx;
        return e instanceof JCSMPErrorResponseException && (respEx = (JCSMPErrorResponseException)e).getResponseCode() == 400 && action.equals("gd_reconnect_fail_action_auto_retry") && (respEx.getSubcodeEx() == 55 || respEx.getSubcodeEx() == 64);
    }

    public static boolean isRetryableConnectionErrorAA(JCSMPException e, String action) {
        if (e instanceof JCSMPErrorResponseException) {
            JCSMPErrorResponseException respEx = (JCSMPErrorResponseException)e;
            if (respEx.getResponseCode() == 420) {
                return false;
            }
            if (JCSMPUtils.reconnectOnUnknownNames(e, action)) {
                return true;
            }
            return respEx.getResponseCode() != 400 || respEx.getSubcodeEx() != 55 && respEx.getSubcodeEx() != 64;
        }
        if (e instanceof JCSMPSecurityException) {
            return true;
        }
        if (e instanceof VersionNotSupportException) {
            return true;
        }
        if (e instanceof JCSMPTransportException || JCSMPUtils.is403InvalidRouter(e)) {
            return true;
        }
        if (e instanceof JCSMPErrorResponseException || e instanceof JCSMPLoginFailureException) {
            boolean retr_deleteprog = JCSMPUtils.is503DeleteInProgress(e);
            return retr_deleteprog;
        }
        return false;
    }

    public static boolean is403InvalidRouter(JCSMPException e) {
        return e instanceof JCSMPErrorResponseException && ((JCSMPErrorResponseException)e).getResponseCode() == 403 && ((JCSMPErrorResponseException)e).getResponsePhrase() != null && ((JCSMPErrorResponseException)e).getResponsePhrase().indexOf("Invalid Virtual Router Address") >= 0;
    }

    public static boolean is503DeleteInProgress(JCSMPException e) {
        int code = 0;
        String str = null;
        if (e instanceof JCSMPErrorResponseException) {
            code = ((JCSMPErrorResponseException)e).getResponseCode();
            str = ((JCSMPErrorResponseException)e).getResponsePhrase();
        } else if (e instanceof JCSMPLoginFailureException) {
            code = ((JCSMPLoginFailureException)e).getResponseCode();
            str = ((JCSMPLoginFailureException)e).getResponsePhrase();
        }
        return code == 503 && str.toLowerCase().contains("delete in progress");
    }
}

