/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.InvalidPropertiesException;
import com.solacesystems.jcsmp.JCSMPNotComparableException;
import com.solacesystems.jcsmp.ReplayStartLocationImpl;
import com.solacesystems.jcsmp.ReplicationGroupMessageId;
import java.math.BigInteger;

public class ReplicationGroupMessageIdImpl
implements ReplicationGroupMessageId,
ReplayStartLocationImpl {
    private long spoolerId = 0L;
    private long msgId = 0L;
    private static final String RMID_VERION_1_PREFIX = "rmid1:";
    private static final int RMID_LENGTH = "rmid1:".length() + 35;
    private static final String RMID_NOT_COMPARABLE = "Replication Group Message Id are not comparable. Messages must be published to the same broker or HA pair for their Replication Group Message Id to be comparable.";
    private static final String RMID_NULL = "Replication Group Message ID is null";
    private static final String RMID_FORMAT_INVALID = "Invalid Replication Group Message ID format: %s";
    private static final String RMID_INVALID_VALUE = "Invalid Replication Group Message ID Value: %s";

    public static ReplicationGroupMessageId createReplicationGroupMessageId(String id) throws InvalidPropertiesException {
        if (id == null) {
            throw new InvalidPropertiesException(RMID_NULL);
        }
        if (id.length() != RMID_LENGTH) {
            throw new InvalidPropertiesException(String.format(RMID_FORMAT_INVALID, id));
        }
        String[] buffers = id.substring(RMID_VERION_1_PREFIX.length()).split("-");
        if (buffers.length != 4 || buffers[0].length() != 5 || buffers[1].length() != 11 || buffers[2].length() != 8 || buffers[3].length() != 8 || !id.contains(RMID_VERION_1_PREFIX)) {
            throw new InvalidPropertiesException(String.format(RMID_FORMAT_INVALID, id));
        }
        try {
            long suid = new BigInteger(buffers[0] + buffers[1], 16).longValue();
            long muid = new BigInteger(buffers[2] + buffers[3], 16).longValue();
            if (suid == 0L) {
                throw new InvalidPropertiesException(String.format(RMID_INVALID_VALUE, id));
            }
            return new ReplicationGroupMessageIdImpl(suid, muid);
        }
        catch (NumberFormatException ex) {
            throw new InvalidPropertiesException(String.format(RMID_INVALID_VALUE, id));
        }
    }

    public ReplicationGroupMessageIdImpl(long spoolerId, long msgId) {
        this.spoolerId = spoolerId;
        this.msgId = msgId;
    }

    protected long getSuid() {
        return this.spoolerId;
    }

    protected long getMessageId() {
        return this.msgId;
    }

    @Override
    public int compare(ReplicationGroupMessageId id) throws JCSMPNotComparableException {
        if (id == null) {
            throw new NullPointerException(RMID_NULL);
        }
        if (this.getSuid() != ((ReplicationGroupMessageIdImpl)id).getSuid()) {
            throw new JCSMPNotComparableException(RMID_NOT_COMPARABLE);
        }
        return Long.compare(this.getMessageId(), ((ReplicationGroupMessageIdImpl)id).getMessageId());
    }

    @Override
    public String toString() {
        int i;
        byte[] sbytes = new byte[8];
        byte[] mbytes = new byte[8];
        NetworkByteOrderNumberUtil.intToEightByte(this.spoolerId, sbytes, 0);
        NetworkByteOrderNumberUtil.intToEightByte(this.msgId, mbytes, 0);
        StringBuilder rmid = new StringBuilder(RMID_VERION_1_PREFIX);
        for (i = 0; i < 8; ++i) {
            rmid.append(Character.forDigit(sbytes[i] >> 4 & 0xF, 16));
            if (i == 2) {
                rmid.append('-');
            }
            rmid.append(Character.forDigit(sbytes[i] & 0xF, 16));
        }
        rmid.append('-');
        for (i = 0; i < 8; ++i) {
            if (i == 4) {
                rmid.append('-');
            }
            rmid.append(Character.forDigit(mbytes[i] >> 4 & 0xF, 16));
            rmid.append(Character.forDigit(mbytes[i] & 0xF, 16));
        }
        return rmid.toString();
    }

    @Override
    public byte[] getEncodedBytes() {
        byte[] encValue = new byte[17];
        encValue[0] = 2;
        NetworkByteOrderNumberUtil.intToEightByte(this.spoolerId, encValue, 1);
        NetworkByteOrderNumberUtil.intToEightByte(this.msgId, encValue, 9);
        return encValue;
    }
}

