/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.FlowEventArgs;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.FlowReceiver;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jms.SolConsumerEventListener;
import com.solacesystems.jms.SolDestination;
import com.solacesystems.jms.SolEventFilter;
import com.solacesystems.jms.SolEventListener;
import com.solacesystems.jms.SolEventSource;
import com.solacesystems.jms.SolMessageConsumer;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.SolTemporaryQueueIF;
import com.solacesystems.jms.SolTemporaryTopicIF;
import com.solacesystems.jms.events.ActiveFlowIndicationEvent;
import com.solacesystems.jms.events.SolConsumerEvent;
import com.solacesystems.jms.events.SolEvent;
import com.solacesystems.jms.impl.JCSMPConsumerFactory;
import com.solacesystems.jms.impl.JCSMPMessageListener;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.Validator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.QueueReceiver;
import javax.jms.TemporaryQueue;

public class SolQueueReceiver
extends SolMessageConsumer
implements QueueReceiver,
SolEventSource,
FlowEventHandler {
    private final LogWrapper log = new LogWrapper(SolQueueReceiver.class);
    int mFlowState = 0;
    CopyOnWriteArrayList<SolEventFilter> mEventListeners = new CopyOnWriteArrayList();

    SolQueueReceiver(SolSessionIF session, javax.jms.Queue queue, String messageSelector, boolean noLocal, JMSState state) throws JMSException {
        super(session, (Destination)queue, messageSelector, noLocal, state, !(queue instanceof TemporaryQueue));
        this.createConsumer();
        this.log.setContextInfo(this.getLogContextInfo());
        if (this.log.isDebugEnabled()) {
            this.log.debug("SolQueueReceiver created");
        }
    }

    public javax.jms.Queue getQueue() throws JMSException {
        Validator.checkClosed(this.mState, "MessageConsumer");
        return (javax.jms.Queue)this.mDestination;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Setting message listener");
            }
            if (listener == null) {
                ((FlowReceiver)this.mConsumer).setMessageListener(null);
                this.mListener.setMessageListener(listener);
            } else {
                this.mListener.setMessageListener(listener);
                ((FlowReceiver)this.mConsumer).setMessageListener(this.mListener);
            }
            this.processDelayStart();
        }
        catch (Exception e) {
            throw Validator.createJMSException("soljms.operation.consumer.setlistener", e);
        }
    }

    @Override
    protected void createConsumer() throws JMSException {
        Queue jcsmpQueue = (Queue)((SolDestination)this.mDestination).getJCSMPDestination();
        boolean nonDurable = this.mDestination instanceof TemporaryQueue;
        JCSMPMessageListener listener = this.mListener.getMessageListener() == null ? null : this.mListener;
        try {
            this.mConsumer = nonDurable ? this.mConsumerFac.createNonDurableConsumer(jcsmpQueue, (XMLMessageListener)listener, this, JCSMPConsumerFactory.standard) : this.mConsumerFac.createDurableConsumer(jcsmpQueue, (XMLMessageListener)listener, this, JCSMPConsumerFactory.standard);
            super.updateLogContextInfo();
            super.createConsumer();
        }
        catch (Exception e) {
            throw Validator.createJMSException("soljms.operation.consumer.create", e);
        }
    }

    @Override
    public boolean isTemporaryQueueUsed(SolTemporaryQueueIF queue) {
        if (this.mState != JMSState.Closed) {
            return queue.equals(this.mDestination);
        }
        return false;
    }

    @Override
    public boolean isTemporaryTopicUsed(SolTemporaryTopicIF topic) {
        return false;
    }

    @Override
    public synchronized void addSolEventListener(SolEventListener listener, long eventTypeMask) throws JMSException {
        block5: {
            for (SolEventFilter filter : this.mEventListeners) {
                if (filter.getListener() != listener) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Adding event mask to listener : " + eventTypeMask);
                }
                filter.addEventType(eventTypeMask);
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding SolEventListener to SolQueueReceiver.  Mask: " + eventTypeMask);
            }
            SolEventFilter filter = new SolEventFilter(this, listener, eventTypeMask);
            this.mEventListeners.add(filter);
            try {
                filter.onEvent(new ActiveFlowIndicationEvent(this.mFlowState));
            }
            catch (Throwable t) {
                if (!this.log.isWarnEnabled()) break block5;
                this.log.warn("Exception occurred in message consumer notification handler", t);
            }
        }
    }

    @Override
    public synchronized void addSolEventListener(SolEventListener listener) throws JMSException {
        this.addSolEventListener(listener, -1L);
    }

    @Override
    public synchronized void removeSolEventListener(SolEventListener listener) {
        this.removeSolEventListener(listener, -1L);
    }

    @Override
    public synchronized void removeSolEventListener(SolEventListener listener, long eventTypeMask) {
        for (SolEventFilter filter : this.mEventListeners) {
            if (filter.getListener() != listener) continue;
            filter.removeEventType(eventTypeMask);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Removing event mask from SolEventListener : " + eventTypeMask);
            }
            if (filter.getEventMask() == 0L) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Removing SolEventListener from SolQueueReceiver");
                }
                this.mEventListeners.remove(filter);
            }
            return;
        }
    }

    public void notifySolEventListeners(SolEvent solEvent) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering notifySolEventListeners()");
        }
        for (SolEventFilter filter : this.mEventListeners) {
            try {
                filter.onEvent(solEvent);
            }
            catch (Throwable t) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn("Exception occurred in message consumer notification handler", t);
            }
        }
        if (this.mConsumerEventListener != null) {
            try {
                this.mConsumerEventListener.onEvent((SolConsumerEvent)((Object)solEvent));
            }
            catch (Throwable t) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("Exception occurred in message consumer event listener", t);
                }
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Event class not extended from SolConsumerEvent - cannot notify SolConsumerEventListeners.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving notifySolEventListeners()");
        }
    }

    @Override
    public synchronized void handleEvent(Object source, FlowEventArgs event) {
        ActiveFlowIndicationEvent queueEvent = null;
        switch (event.getEvent()) {
            case FLOW_ACTIVE: {
                this.mFlowState = 1;
                queueEvent = new ActiveFlowIndicationEvent(this.mFlowState);
                if (!this.log.isDebugEnabled()) break;
                try {
                    this.log.debug("SolQueueReceiver for queue " + this.getQueue().getQueueName() + " Flow state is now ACTIVE");
                }
                catch (JMSException jMSException) {}
                break;
            }
            case FLOW_INACTIVE: {
                this.mFlowState = 0;
                queueEvent = new ActiveFlowIndicationEvent(this.mFlowState);
                if (!this.log.isDebugEnabled()) break;
                try {
                    this.log.debug("SolQueueReceiver for queue " + this.getQueue().getQueueName() + " Flow state is now INACTIVE");
                }
                catch (JMSException jMSException) {}
                break;
            }
        }
        if (queueEvent != null) {
            this.notifySolEventListeners(queueEvent);
        }
    }

    @Override
    public void setSolConsumerEventListener(SolConsumerEventListener listener) {
        block2: {
            super.setSolConsumerEventListener(listener);
            try {
                this.mConsumerEventListener.onEvent(new ActiveFlowIndicationEvent(this.mFlowState));
            }
            catch (Throwable t) {
                if (!this.log.isWarnEnabled()) break block2;
                this.log.warn("Exception occurred in message consumer notification handler", t);
            }
        }
    }
}

