/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.message;

import com.solace.messaging.trace.propagation.Baggage;
import com.solace.messaging.trace.propagation.MessageTracingSupport;
import com.solace.messaging.trace.propagation.TraceContext;
import com.solace.messaging.trace.propagation.TraceContextSetter;
import com.solace.messaging.trace.propagation.impl.BaggageImpl;
import com.solace.messaging.trace.propagation.impl.TraceContextImpl;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.impl.MessageDumpFieldProvider;
import com.solacesystems.jcsmp.impl.MessageDumpUtil;
import com.solacesystems.jcsmp.impl.sdt.MapImpl;
import com.solacesystems.jms.SolDestination;
import com.solacesystems.jms.impl.AckHandler;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.message.SolMessageDump;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolMessage
implements Message,
MessageTracingSupport,
Serializable {
    private static final Log log = LogFactory.getLog(SolMessage.class);
    private static final long serialVersionUID = -290711074650625544L;
    public static final String JMSMessageIDPrefix = "ID:";
    public static final int PRORITY_UNDEFINED = -1;
    public static final int PRORITY_MAX = 9;
    protected static final Enumeration<String> EMPTY_PROPERTY_NAMES = Collections.enumeration(new HashMap().keySet());
    private static final Class<?>[] SupportedPropertyTypes = new Class[]{Byte.class, byte[].class, Boolean.class, String.class, Character.class, Long.class, Integer.class, Short.class, Float.class, Double.class};
    protected String mJMSClientID = null;
    protected String mJMSCorrelationID = null;
    protected int mJMSDeliveryMode = 2;
    protected Destination mJMSDestination = null;
    protected boolean mJMSDestinationSet = false;
    protected Long mJMSExpiration = null;
    protected String mJMSMessageID = null;
    protected boolean mJMSMessageIDSet = false;
    protected int mJMSPriority = -1;
    protected boolean mJMSRedelivered = false;
    protected Destination mJMSReplyTo = null;
    protected long mJMSTimestamp = 0L;
    protected boolean mJMSTimestampSet = false;
    protected String mJMSType = null;
    protected boolean mReadOnlyProperties = false;
    protected Map<String, Object> mProperties = null;
    protected transient MessageBodyMode mBodyMode = MessageBodyMode.WriteMode;
    protected transient BytesXMLMessage mMessage = null;
    protected transient AckHandler mAckHandler = null;
    protected Boolean mIsXML = null;
    protected Boolean mIsReplyMsg = null;
    protected Boolean mIsDTO = null;
    protected Boolean mDMQEligible = null;
    protected Boolean mElidingEligible = null;
    protected Boolean mDiscardIndication = null;
    protected Long mTopicSequenceNumber = null;
    protected String mHTTPContentType = null;
    protected boolean mHTTPContentTypeSet = false;
    protected String mHTTPContentEncoding = null;
    protected boolean mHTTPContentEncodingSet = false;
    protected String mSenderID = null;
    protected boolean mSenderIDSet = false;
    protected Integer mDeliveryCount = null;
    private volatile TraceContextSetter contextSetter;
    private volatile TraceContextImpl creationContext;
    private volatile TraceContextImpl transportContext;
    private volatile BaggageImpl baggage;

    public SolMessage() {
    }

    public SolMessage(BytesXMLMessage message) {
        this.mReadOnlyProperties = true;
        this.mBodyMode = MessageBodyMode.ReadUnloadedMode;
        this.mMessage = message;
    }

    public BytesXMLMessage getMessage() {
        return this.mMessage;
    }

    public long getMessageSize() throws JMSException {
        if (this.mMessage == null) {
            throw new IllegalStateException("Can only calculate message size on received messages");
        }
        long msgSize = 0L;
        msgSize += (long)this.mMessage.getAttachmentContentLength();
        msgSize += (long)this.mMessage.getContentLength();
        return msgSize += (long)this.mMessage.getBinaryMetadataContentLength(0);
    }

    public void acknowledge() throws JMSException {
        if (this.mAckHandler != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Acking message.");
            }
            this.mAckHandler.acknowledge(this);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Message acked.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"acknowledge() cannot ack the message as there is no ack handler.");
        }
    }

    public void clearBody() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Clearing message body");
        }
        this.mBodyMode = MessageBodyMode.WriteMode;
    }

    public void clearPropertyReadOnlyFlag() {
        this.mReadOnlyProperties = false;
    }

    public void clearProperties() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Clearing message properties");
        }
        this.mReadOnlyProperties = false;
        Map<String, Object> props = this.getProperties();
        if (props != null) {
            props.clear();
        }
        this.mIsXML = null;
        this.mIsDTO = null;
        this.mDMQEligible = null;
        this.mElidingEligible = null;
        this.mIsReplyMsg = null;
        this.setHTTPContentType(null);
        this.setHTTPContentEncoding(null);
        this.setSenderID(null);
        this.mDeliveryCount = null;
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return this.vanillaToBoolean(name);
    }

    public byte getByteProperty(String name) throws JMSException {
        return this.vanillaToByte(name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        return this.vanillaToDouble(name);
    }

    public float getFloatProperty(String name) throws JMSException {
        return this.vanillaToFloat(name);
    }

    public int getIntProperty(String name) throws JMSException {
        return this.vanillaToInt(name);
    }

    public String getJMSCorrelationID() {
        if (this.mMessage != null) {
            this.mJMSCorrelationID = this.mMessage.getCorrelationId();
        }
        return this.mJMSCorrelationID;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        if (this.mMessage != null) {
            this.mJMSCorrelationID = this.mMessage.getCorrelationId();
        }
        if (this.mJMSCorrelationID == null) {
            return null;
        }
        return this.mJMSCorrelationID.getBytes(Charset.forName("UTF-8"));
    }

    public int getJMSDeliveryMode() {
        return this.mJMSDeliveryMode;
    }

    public Destination getJMSDestination() {
        if (this.mMessage != null && !this.mJMSDestinationSet) {
            this.mJMSDestination = SolDestination.createDestination(this.mMessage.getDestination());
        }
        return this.mJMSDestination;
    }

    public long getJMSExpiration() {
        if (this.mJMSExpiration == null) {
            this.mJMSExpiration = this.mMessage != null ? Long.valueOf(this.mMessage.getExpiration()) : Long.valueOf(0L);
        }
        return this.mJMSExpiration;
    }

    public String getJMSMessageID() {
        if (this.mMessage != null && !this.mJMSMessageIDSet) {
            this.mJMSMessageID = this.mMessage.getAppMessageID();
        }
        return this.mJMSMessageID;
    }

    public int getJMSPriority() {
        if (this.mJMSPriority == -1) {
            return 0;
        }
        return this.mJMSPriority;
    }

    public boolean getJMSRedelivered() {
        return this.mJMSRedelivered;
    }

    public Destination getJMSReplyTo() {
        if (this.mMessage != null && this.mMessage.getReplyTo() != null) {
            this.mJMSReplyTo = SolDestination.createDestination(this.mMessage.getReplyTo());
        }
        return this.mJMSReplyTo;
    }

    public long getJMSTimestamp() {
        if (this.mMessage != null && !this.mJMSTimestampSet) {
            this.mJMSTimestamp = this.mMessage.getSendTimestamp() == null ? 0L : this.mMessage.getSendTimestamp();
        }
        return this.mJMSTimestamp;
    }

    public String getJMSType() {
        if (this.mMessage != null) {
            this.mJMSType = this.mMessage.getAppMessageType();
        }
        return this.mJMSType;
    }

    public long getLongProperty(String name) throws JMSException {
        return this.vanillaToLong(name);
    }

    public Integer getJMSXDeliveryCount() {
        return this.mDeliveryCount;
    }

    public Object getObjectProperty(String name) {
        if (name == null) {
            throw new NullPointerException("name supplied is null");
        }
        if (name.equals("JMS_Solace_isXML")) {
            return this.mIsXML;
        }
        if (name.equals("Solace_JMS_Prop_IS_Reply_Message")) {
            return this.mIsReplyMsg;
        }
        if (name.equals("JMS_Solace_DeliverToOne")) {
            return this.mIsDTO;
        }
        if (name.equals("JMS_Solace_DeadMsgQueueEligible")) {
            return this.mDMQEligible;
        }
        if (name.equals("JMS_Solace_ElidingEligible")) {
            return this.mElidingEligible;
        }
        if (name.equals("JMS_Solace_MsgDiscardIndication")) {
            return this.mDiscardIndication;
        }
        if (name.equals("JMS_Solace_TopicSequenceNumber")) {
            return this.mTopicSequenceNumber;
        }
        if (name.equals("JMS_Solace_HTTPContentType")) {
            return this.getHTTPContentType();
        }
        if (name.equals("JMS_Solace_HTTPContentEncoding")) {
            return this.getHTTPContentEncoding();
        }
        if (name.equals("JMS_Solace_SenderId")) {
            return this.getSenderID();
        }
        if (name.equals("JMSXDeliveryCount")) {
            return this.mDeliveryCount;
        }
        Map<String, Object> props = this.getProperties();
        if (props == null) {
            return null;
        }
        return props.get(name);
    }

    public Enumeration<String> getPropertyNames() {
        Map<String, Object> props = this.getProperties();
        if (props == null && this.mIsXML == null && this.mIsDTO == null && this.mDMQEligible == null && this.mElidingEligible == null && this.mDiscardIndication == null && this.mTopicSequenceNumber == null && this.mIsReplyMsg == null && this.getHTTPContentType() == null && this.getHTTPContentEncoding() == null && this.getSenderID() == null) {
            return EMPTY_PROPERTY_NAMES;
        }
        ArrayList<Object> newList = props == null ? new ArrayList() : new ArrayList<String>(props.keySet());
        if (this.mIsXML != null) {
            newList.add("JMS_Solace_isXML");
        }
        if (this.mIsDTO != null) {
            newList.add("JMS_Solace_DeliverToOne");
        }
        if (this.mDMQEligible != null) {
            newList.add("JMS_Solace_DeadMsgQueueEligible");
        }
        if (this.mElidingEligible != null) {
            newList.add("JMS_Solace_ElidingEligible");
        }
        if (this.mDiscardIndication != null) {
            newList.add("JMS_Solace_MsgDiscardIndication");
        }
        if (this.mTopicSequenceNumber != null) {
            newList.add("JMS_Solace_TopicSequenceNumber");
        }
        if (this.mIsReplyMsg != null) {
            newList.add("Solace_JMS_Prop_IS_Reply_Message");
        }
        if (this.getHTTPContentType() != null) {
            newList.add("JMS_Solace_HTTPContentType");
        }
        if (this.getHTTPContentEncoding() != null) {
            newList.add("JMS_Solace_HTTPContentEncoding");
        }
        if (this.getSenderID() != null) {
            newList.add("JMS_Solace_SenderId");
        }
        if (this.mDeliveryCount != null) {
            newList.add("JMSXDeliveryCount");
        }
        return Collections.enumeration(newList);
    }

    public short getShortProperty(String name) throws JMSException {
        return this.vanillaToShort(name);
    }

    public String getStringProperty(String name) throws JMSException {
        return this.vanillaToString(name);
    }

    public boolean propertyExists(String name) throws JMSException {
        if (name.equals("Solace_JMS_Prop_IS_Reply_Message")) {
            return this.mIsReplyMsg != null;
        }
        if (name.equals("JMS_Solace_isXML")) {
            return this.mIsXML != null;
        }
        if (name.equals("JMS_Solace_DeliverToOne")) {
            return this.mIsDTO != null;
        }
        if (name.equals("JMS_Solace_DeadMsgQueueEligible")) {
            return this.mDMQEligible != null;
        }
        if (name.equals("JMS_Solace_ElidingEligible")) {
            return this.mElidingEligible != null;
        }
        if (name.equals("JMS_Solace_MsgDiscardIndication")) {
            return this.mDiscardIndication != null;
        }
        if (name.equals("JMS_Solace_TopicSequenceNumber")) {
            return this.mTopicSequenceNumber != null;
        }
        if (name.equals("JMS_Solace_HTTPContentType")) {
            return this.getHTTPContentType() != null;
        }
        if (name.equals("JMS_Solace_HTTPContentEncoding")) {
            return this.getHTTPContentEncoding() != null;
        }
        if (name.equals("JMS_Solace_SenderId")) {
            return this.getSenderID() != null;
        }
        if (name.equals("JMSXDeliveryCount")) {
            return this.mDeliveryCount != null;
        }
        if (name.equals("JMSXUserID")) {
            try {
                return this.getStringProperty("JMSXUserID") != null;
            }
            catch (JMSException e) {
                return false;
            }
        }
        if (name.equals("JMSXGroupID")) {
            try {
                return this.getStringProperty("JMSXGroupID") != null;
            }
            catch (JMSException e) {
                return false;
            }
        }
        if (name.equals("JMSXGroupSeq")) {
            try {
                this.getIntProperty("JMSXGroupSeq");
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
            catch (JMSException e) {
                return false;
            }
        }
        Map<String, Object> props = this.getProperties();
        if (props == null) {
            return false;
        }
        return props.containsKey(name);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.setObjectProperty(name, Float.valueOf(value));
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.mJMSCorrelationID = correlationID;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        if (correlationID == null) {
            this.mJMSCorrelationID = null;
        } else {
            this.setJMSCorrelationID(new String(correlationID, Charset.forName("UTF-8")));
        }
    }

    public void setJMSDeliveryMode(int deliveryMode) {
        this.mJMSDeliveryMode = deliveryMode;
    }

    public void setJMSDestination(Destination destination) {
        this.mJMSDestination = destination;
        this.mJMSDestinationSet = true;
    }

    public void setJMSExpiration(long expiration) {
        this.mJMSExpiration = expiration;
    }

    public void setJMSMessageID(String id) {
        this.mJMSMessageID = id;
        this.mJMSMessageIDSet = true;
    }

    public void setJMSPriority(int priority) throws JMSException {
        Validator.checkPriority(priority);
        this.mJMSPriority = priority;
    }

    public void setJMSRedelivered(boolean redelivered) {
        this.mJMSRedelivered = redelivered;
    }

    public void setJMSReplyTo(Destination replyTo) {
        this.mJMSReplyTo = replyTo;
    }

    public void setJMSTimestamp(long timestamp) {
        this.mJMSTimestamp = timestamp;
        this.mJMSTimestampSet = true;
    }

    public void setJMSType(String type) {
        this.mJMSType = type;
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setJMSXDeliveryCount(Integer count) {
        this.mDeliveryCount = count;
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (this.mReadOnlyProperties) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.setObjectPropertyWithoutReadOnlyCheck(name, value);
    }

    public void setObjectPropertyWithoutReadOnlyCheck(String name, Object value) throws JMSException {
        this.checkPropertyName(name);
        if (value != null) {
            boolean supported = false;
            for (int i = 0; i < SupportedPropertyTypes.length; ++i) {
                if (!SupportedPropertyTypes[i].equals(value.getClass())) continue;
                supported = true;
                break;
            }
            if (!supported) {
                throw new MessageFormatException("unsupported object value class \"" + value.getClass().getSimpleName() + "\"");
            }
        }
        if (name.equals("JMS_Solace_isXML") && value instanceof Boolean) {
            this.mIsXML = (Boolean)value;
            return;
        }
        if (name.equals("Solace_JMS_Prop_IS_Reply_Message") && value instanceof Boolean) {
            this.mIsReplyMsg = (Boolean)value;
            return;
        }
        if (name.equals("JMS_Solace_DeliverToOne") && value instanceof Boolean) {
            this.mIsDTO = (Boolean)value;
            return;
        }
        if (name.equals("JMS_Solace_DeadMsgQueueEligible") && value instanceof Boolean) {
            this.mDMQEligible = (Boolean)value;
            return;
        }
        if (name.equals("JMS_Solace_ElidingEligible") && value instanceof Boolean) {
            this.mElidingEligible = (Boolean)value;
            return;
        }
        if (name.equals("JMS_Solace_HTTPContentType") && value instanceof String) {
            this.setHTTPContentType((String)value);
            return;
        }
        if (name.equals("JMS_Solace_HTTPContentEncoding") && value instanceof String) {
            this.setHTTPContentEncoding((String)value);
            return;
        }
        if (name.equals("JMS_Solace_SenderId") && value instanceof String) {
            this.setSenderID((String)value);
            return;
        }
        if (name.equals("JMS_Solace_MsgDiscardIndication")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ignoring request to set read-only property JMS_Solace_MsgDiscardIndication.");
            }
            return;
        }
        if (name.equals("JMS_Solace_TopicSequenceNumber")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ignoring request to set read-only property JMS_Solace_TopicSequenceNumber.");
            }
            return;
        }
        Map<String, Object> props = this.getProperties();
        if (props == null) {
            this.mProperties = new HashMap<String, Object>();
            this.mProperties.put(name, value);
        } else {
            props.put(name, value);
        }
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        SDTMap sdtMap;
        if (this.mProperties == null && this.mMessage != null && (sdtMap = this.mMessage.getProperties()) != null) {
            this.mProperties = ((MapImpl)sdtMap).getMap();
        }
        return this.mProperties;
    }

    public void setAckHandler(AckHandler ackHandler) {
        this.mAckHandler = ackHandler;
    }

    public Boolean isXML() {
        return this.mIsXML;
    }

    public void setIsXML(boolean isXML) {
        this.mIsXML = isXML;
    }

    public Boolean isDTO() {
        return this.mIsDTO;
    }

    public void setIsDTO(boolean isDTO) {
        this.mIsDTO = isDTO;
    }

    public Boolean isReplyMsg() {
        return this.mIsReplyMsg;
    }

    public void setIsReplyMsg(boolean isRplyMsg) {
        this.mIsReplyMsg = isRplyMsg;
    }

    public Boolean isDMQEligible() {
        return this.mDMQEligible;
    }

    public void setIsDMQEligible(boolean isDMQEligible) {
        this.mDMQEligible = isDMQEligible;
    }

    public Boolean isElidingEligible() {
        return this.mElidingEligible;
    }

    public void setIsElidingEligible(boolean isElidingEligible) {
        this.mElidingEligible = isElidingEligible;
    }

    public void setDiscardIndication(boolean discardIndication) {
        this.mDiscardIndication = discardIndication;
    }

    public void setTopicSequenceNumber(Long topicSequenceNumber) {
        this.mTopicSequenceNumber = topicSequenceNumber;
    }

    public String getHTTPContentType() {
        if (this.mMessage != null && !this.mHTTPContentTypeSet) {
            this.setHTTPContentType(this.mMessage.getHTTPContentType());
        }
        return this.mHTTPContentType;
    }

    public void setHTTPContentType(String contentType) {
        this.mHTTPContentType = contentType;
        this.mHTTPContentTypeSet = true;
    }

    public String getHTTPContentEncoding() {
        if (this.mMessage != null && !this.mHTTPContentEncodingSet) {
            this.setHTTPContentEncoding(this.mMessage.getHTTPContentEncoding());
        }
        return this.mHTTPContentEncoding;
    }

    public void setHTTPContentEncoding(String contentEncoding) {
        this.mHTTPContentEncoding = contentEncoding;
        this.mHTTPContentEncodingSet = true;
    }

    public String getSenderID() {
        if (this.mMessage != null && !this.mSenderIDSet) {
            this.setSenderID(this.mMessage.getSenderId());
        }
        return this.mSenderID;
    }

    public void setSenderID(String senderID) {
        this.mSenderID = senderID;
        this.mSenderIDSet = true;
    }

    public void removeProperty(String name) {
        this.loadProperties();
        if (this.mProperties != null && name != null) {
            this.mProperties.remove(name);
        }
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        throw new UnsupportedOperationException("getBody(Class<T>) is not supported");
    }

    public boolean isBodyAssignableTo(Class c) throws JMSException {
        throw new UnsupportedOperationException("isBodyAssignableTo(Class) is not supported");
    }

    public long getJMSDeliveryTime() throws JMSException {
        throw new UnsupportedOperationException("getJMSDeliveryTime() is not supported");
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        throw new UnsupportedOperationException("setJMSDeliveryTime(long) is not supported");
    }

    protected boolean vanillaToBoolean(String name) throws JMSException {
        boolean result = false;
        Object value = this.getObjectProperty(name);
        if (value != null) {
            if (value instanceof Boolean) {
                result = (Boolean)value;
            } else if (value instanceof String) {
                result = Boolean.valueOf((String)value);
            } else {
                throw new MessageFormatException("not a Boolean type");
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte vanillaToByte(String name) throws JMSException {
        byte result = 0;
        Object value = this.getObjectProperty(name);
        if (value == null) throw new NumberFormatException("Cannot interpret null as a Byte");
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (!(value instanceof String)) throw new MessageFormatException(name + " not a Byte type");
        return Byte.valueOf((String)value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected short vanillaToShort(String name) throws JMSException {
        short result = 0;
        Object value = this.getObjectProperty(name);
        if (value == null) throw new NumberFormatException(name + " is null");
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            return Short.valueOf((String)value);
        }
        if (!(value instanceof Byte)) throw new MessageFormatException(name + " not a Short type");
        return ((Byte)value).byteValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int vanillaToInt(String name) throws JMSException {
        int result = 0;
        Object value = this.getObjectProperty(name);
        if (value == null) throw new NumberFormatException(name + " is null");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (!(value instanceof Short)) throw new MessageFormatException(name + " not an Integer type");
        return ((Short)value).intValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long vanillaToLong(String name) throws JMSException {
        long result = 0L;
        Object value = this.getObjectProperty(name);
        if (value == null) throw new NumberFormatException(name + " is null");
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (!(value instanceof Integer)) throw new MessageFormatException(name + " not a Long type");
        return ((Integer)value).intValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected float vanillaToFloat(String name) throws JMSException {
        float result = 0.0f;
        Object value = this.getObjectProperty(name);
        if (value == null) throw new NullPointerException(name + " is null");
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (!(value instanceof String)) throw new MessageFormatException(name + " not a Float type: " + value.getClass());
        return Float.valueOf((String)value).floatValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected double vanillaToDouble(String name) throws JMSException {
        double result = 0.0;
        Object value = this.getObjectProperty(name);
        if (value == null) throw new NullPointerException(name + " is null");
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        if (!(value instanceof Float)) throw new MessageFormatException(name + " not a Double type");
        return ((Float)value).floatValue();
    }

    protected String vanillaToString(String name) throws JMSException {
        String result = null;
        Object value = this.getObjectProperty(name);
        if (value != null) {
            if (value instanceof String || value instanceof Number || value instanceof Boolean) {
                result = value.toString();
            } else {
                throw new MessageFormatException(name + " not a String type");
            }
        }
        return result;
    }

    protected byte[] toByteArray(ObjectInputStream in) throws IOException {
        byte[] data = new byte[]{};
        while (in.available() > 0) {
            int newLength = data.length + in.available();
            byte[] newArray = new byte[newLength];
            System.arraycopy(data, 0, newArray, 0, data.length);
            if (in.read(newArray, data.length, in.available()) < in.available()) {
                throw new IOException("Error in reading the stream");
            }
            data = newArray;
        }
        return data;
    }

    private void checkPropertyName(String name) throws JMSException {
        if (name == null) {
            throw new IllegalArgumentException("Invalid property name: cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Invalid property name: cannot be empty");
        }
    }

    private void loadProperties() {
        this.getJMSCorrelationID();
        this.getJMSDestination();
        this.getJMSMessageID();
        this.getJMSReplyTo();
        this.getJMSTimestamp();
        this.getJMSType();
        this.getProperties();
        this.getJMSExpiration();
        this.getHTTPContentEncoding();
        this.getHTTPContentType();
        this.getSenderID();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.loadProperties();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.mBodyMode = MessageBodyMode.WriteMode;
        this.mReadOnlyProperties = false;
    }

    public String dump() {
        Collection field_providers = SolMessageDump.getJmsFieldProviders();
        StringBuilder sb = new StringBuilder();
        sb.append(MessageDumpUtil.dump(field_providers, this, 1));
        if (this.mMessage != null) {
            sb.append(this.mMessage.dump());
        }
        return sb.toString();
    }

    protected static void writeUTF(DataOutput dataOut, String value) throws IOException {
        dataOut.writeUTF(value);
        dataOut.writeByte(0);
    }

    protected static void writeJMSUTF(DataOutput dataOut, String value) throws JMSException {
        try {
            SolMessage.writeUTF(dataOut, value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    protected static String readUTF(DataInput dataIn) throws EOFException, IOException {
        String returnString = dataIn.readUTF();
        dataIn.readByte();
        return returnString;
    }

    protected static String readJMSUTF(DataInput dataIn) throws JMSException {
        try {
            return SolMessage.readUTF(dataIn);
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occurred" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public String toString() {
        Collection<MessageDumpFieldProvider<MessageDumpFieldProvider<SolMessage>>> field_providers = SolMessageDump.getJmsFieldProviders();
        field_providers.add(new SolMessageDump.FPJmsJcsmpContents());
        StringBuilder sb = new StringBuilder();
        sb.append(MessageDumpUtil.dump(field_providers, this, ",", 0, 0));
        String className = this.getClass().getSimpleName();
        String str = String.format("%s={ %s }", className, sb.toString());
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TraceContextSetter contextSetter() {
        if (this.contextSetter == null) {
            SolMessage solMessage = this;
            synchronized (solMessage) {
                if (this.contextSetter == null) {
                    this.contextSetter = new TraceContextSetterImpl(this);
                }
            }
        }
        return this.contextSetter;
    }

    @Override
    public TraceContext transportContext() {
        return this.transportContext;
    }

    @Override
    public TraceContext creationContext() {
        return this.creationContext;
    }

    @Override
    public Baggage baggage() {
        if (this.baggage == null) {
            this.baggage = new BaggageImpl();
        }
        return this.baggage;
    }

    public void setTransportContext(TraceContext traceContext) {
        this.transportContext = (TraceContextImpl)traceContext;
    }

    public void setCreationContext(TraceContext traceContext) {
        this.creationContext = (TraceContextImpl)traceContext;
    }

    public void setBaggage(Baggage baggage) {
        this.baggage = (BaggageImpl)baggage;
    }

    private static class TraceContextSetterImpl
    implements TraceContextSetter {
        private static final Log Trace = LogFactory.getLog(TraceContextSetterImpl.class);
        private static final String FIELD_TRACE_ID = "traceId";
        private static final String FIELD_SPAN_ID = "spanId";
        private static final String FIELD_SAMPLED = "sampled";
        private static final String FIELD_TRACE_STATE = "traceState";
        final SolMessage message;

        TraceContextSetterImpl(SolMessage message) {
            this.message = message;
        }

        @Override
        public void setTraceIdBytes16(byte[] traceIdBytes) throws IllegalArgumentException {
            if (traceIdBytes != null && traceIdBytes.length != 16) {
                throw new IllegalArgumentException("traceIdBytes size should be 16 bytes");
            }
            TraceContextImpl traceContext = this.findContext(FIELD_TRACE_ID);
            if (traceContext != null) {
                traceContext.setTraceIdBytes16(traceIdBytes);
                if (traceContext == this.message.transportContext) {
                    traceContext.setTraceState(null);
                }
            }
        }

        @Override
        public void setSpanIdBytes8(byte[] spanIdBytes) throws IllegalArgumentException {
            if (spanIdBytes != null && spanIdBytes.length != 8) {
                throw new IllegalArgumentException("spanIdBytes size should be 8 bytes");
            }
            TraceContextImpl traceContext = this.findContext(FIELD_SPAN_ID);
            if (traceContext != null) {
                traceContext.setSpanIdBytes8(spanIdBytes);
            }
        }

        @Override
        public void setSampled(boolean sampled) {
            TraceContextImpl traceContext = this.findContext(FIELD_SAMPLED);
            if (traceContext != null) {
                traceContext.setSampled(sampled);
            }
        }

        @Override
        public void setTraceState(String traceState) throws IllegalArgumentException {
            TraceContextImpl traceContext = this.findContext(FIELD_TRACE_STATE);
            if (traceContext != null) {
                traceContext.setTraceState(traceState);
            }
        }

        private TraceContextImpl findContext(String field) {
            if (this.message.transportContext != null) {
                return this.message.transportContext;
            }
            if (FIELD_TRACE_ID.equals(field)) {
                if (this.message.creationContext == null) {
                    this.message.creationContext = new TraceContextImpl();
                    return this.message.creationContext;
                }
                if (this.message.transportContext == null) {
                    this.message.transportContext = new TraceContextImpl();
                    return this.message.transportContext;
                }
            }
            if (FIELD_SPAN_ID.equals(field)) {
                if (this.message.creationContext != null && this.message.creationContext.getTraceIdBytes16() != null && this.message.creationContext.getSpanIdBytes8() == null) {
                    return this.message.creationContext;
                }
                Trace.error((Object)"Invalid call to set spanId");
            }
            if (FIELD_SAMPLED.equals(field) && this.message.creationContext != null) {
                return this.message.creationContext;
            }
            if (FIELD_TRACE_STATE.equals(field) && this.message.creationContext != null) {
                return this.message.creationContext;
            }
            Trace.error((Object)String.format("%s injection failed, trace context not set", field));
            return null;
        }
    }

    protected static enum MessageBodyMode {
        WriteMode,
        ReadLoadedMode,
        ReadUnloadedMode;

    }
}

