/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.expect;

import com.solacesystems.common.expect.ExceptionMatcher;

public class DefaultExceptionMatcher
implements ExceptionMatcher {
    protected Class<?> mClass;
    protected ClassMatch mClassMatch;
    protected String mMessage;
    protected StringMatch mMessageMatch;

    public DefaultExceptionMatcher(Class<?> exceptionClass, ClassMatch classMatch) {
        this(exceptionClass, classMatch, null, null);
    }

    public DefaultExceptionMatcher(Class<?> exceptionClass, ClassMatch classMatch, String exceptionMessage, StringMatch messageMatch) {
        this.mClass = exceptionClass;
        this.mClassMatch = classMatch;
        this.mMessage = exceptionMessage;
        this.mMessageMatch = messageMatch;
    }

    @Override
    public boolean exceptionMatches(Exception exception) {
        if (exception == null) {
            return false;
        }
        if (!this.mClassMatch.match(this.mClass, exception.getClass())) {
            return false;
        }
        return this.mMessageMatch == null || this.mMessageMatch.match(this.mMessage, exception.getMessage());
    }

    public static enum StringMatch {
        Exact,
        IgnoreCase,
        IndexOf,
        StartsWith;


        public boolean match(String src, String comparer) {
            if (comparer == null) {
                return false;
            }
            if (Exact.name().equals(this.name())) {
                return comparer.equals(src);
            }
            if (IgnoreCase.name().equals(this.name())) {
                return comparer.equalsIgnoreCase(src);
            }
            if (IndexOf.name().equals(this.name())) {
                return comparer.indexOf(src) != -1;
            }
            return comparer.startsWith(src);
        }
    }

    public static enum ClassMatch {
        SameClass,
        AndSubclasses;


        public boolean match(Class<?> src, Class<?> comparer) {
            if (comparer == null) {
                return false;
            }
            if (SameClass.name().equals(this.name())) {
                return src.equals(comparer);
            }
            return src.isAssignableFrom(comparer);
        }
    }
}

