/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.common.util.DestinationUtil;
import com.solacesystems.jcsmp.AccessDeniedException;
import com.solacesystems.jcsmp.ClosedFacilityException;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFlowTransportException;
import com.solacesystems.jcsmp.JCSMPLoginFailureException;
import com.solacesystems.jcsmp.JCSMPSecurityException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.PropertyMismatchException;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.StaleSessionException;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.transaction.RollbackException;
import com.solacesystems.jcsmp.transaction.TransactionResultUnknownException;
import com.solacesystems.jms.ConfigurationException;
import com.solacesystems.jms.DuplicateDurableSubscriptionException;
import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolDestination;
import com.solacesystems.jms.SolTemporaryQueueIF;
import com.solacesystems.jms.SolTemporaryTopicIF;
import com.solacesystems.jms.impl.JCSMPErrorExceptionKey;
import com.solacesystems.jms.impl.JCSMPExceptionKey;
import com.solacesystems.jms.impl.JCSMPExceptionMapper;
import com.solacesystems.jms.impl.JMSExceptionValue;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.SessionTransactionType;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import javax.jms.Destination;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.Queue;
import javax.jms.ResourceAllocationException;
import javax.jms.ServerSessionPool;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TransactionRolledBackException;

public class Validator {
    public static Object[][] ExceptionMap = new Object[][]{{InvalidOperationException.class, "TOPIC_DISPATCH_OPTIMIZE_DIRECT", "soljms.operation.consumer.create", ConfigurationException.class, "soljms.error.notcapable", "Only a single consumer can be used when optimizing for direct - SOLACE_JMS_OPTIMIZE_DIRECT"}, {InvalidOperationException.class, "TOPIC_DISPATCH_OPTIMIZE_DIRECT", "soljms.operation.send", ConfigurationException.class, "soljms.error.notcapable", "Only a single consumer can be used when optimizing for direct - SOLACE_JMS_OPTIMIZE_DIRECT"}, {InvalidOperationException.class, "TOPIC_DISPATCH_OPTIMIZE_DIRECT", "soljms.operation.unsubscribe", ConfigurationException.class, "soljms.error.notcapable", "Only a single consumer can be used when optimizing for direct - SOLACE_JMS_OPTIMIZE_DIRECT"}, {InvalidOperationException.class, "TOPIC_DISPATCH_OPTIMIZE_DIRECT", "soljms.operation.producer.create", ConfigurationException.class, "soljms.error.notcapable", "Only a single producer can be used when optimizing for direct - SOLACE_JMS_OPTIMIZE_DIRECT"}, {InvalidOperationException.class, "Operation CREATEFLOW disallowed in state", "soljms.operation.producer.create", javax.jms.IllegalStateException.class, "soljms.error.illegalstate", null}, {InvalidOperationException.class, "Tried to call receive on a message consumer in asynchronous mode.", "soljms.operation.recv", javax.jms.IllegalStateException.class, "soljms.error.illegalstate", null}, {InvalidOperationException.class, null, "soljms.operation.recv", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {InvalidOperationException.class, null, "soljms.operation.consumer.start", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {ClosedFacilityException.class, null, "soljms.operation.recv", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {ClosedFacilityException.class, null, "soljms.operation.consumer.start", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {StaleSessionException.class, null, "soljms.operation.recv", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {StaleSessionException.class, null, "soljms.operation.consumer.start", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {InvalidOperationException.class, null, "soljms.operation.consumer.create", ConfigurationException.class, "soljms.error.notcapable", null}, {InvalidOperationException.class, null, "soljms.operation.send", ConfigurationException.class, "soljms.error.notcapable", null}, {InvalidOperationException.class, null, "soljms.operation.unsubscribe", ConfigurationException.class, "soljms.error.notcapable", null}, {InvalidOperationException.class, null, "soljms.operation.queue.browser", ConfigurationException.class, "soljms.error.notcapable", null}, {InvalidOperationException.class, null, "soljms.operation.session.create", ConfigurationException.class, "soljms.error.notcapable", null}, {ClosedFacilityException.class, null, "soljms.operation.consumer.create", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {ClosedFacilityException.class, null, "soljms.operation.send", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {StaleSessionException.class, null, "soljms.operation.consumer.create", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {StaleSessionException.class, null, "soljms.operation.send", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {ClosedFacilityException.class, null, "soljms.operation.unsubscribe", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {ClosedFacilityException.class, null, "soljms.operation.queue.browser", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {ClosedFacilityException.class, null, "soljms.operation.producer.create", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {StaleSessionException.class, null, "soljms.operation.unsubscribe", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {StaleSessionException.class, null, "soljms.operation.queue.browser", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {ClosedFacilityException.class, null, "soljms.operation.session.create", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {StaleSessionException.class, null, "soljms.operation.session.create", javax.jms.IllegalStateException.class, "soljms.error.closed", null}, {InvalidOperationException.class, JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoEndpointTTL"), null, ConfigurationException.class, "soljms.error.notcapable", null}, {InvalidOperationException.class, JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoEndpointMgmt"), null, ConfigurationException.class, "soljms.error.notcapable", null}, {JCSMPTransportException.class, null, null, JMSException.class, "soljms.error.transport", null}, {JCSMPFlowTransportException.class, null, null, JMSException.class, "soljms.error.transport", null}, {InterruptedException.class, null, null, JMSException.class, "soljms.error.internal", null}, {SDTException.class, null, null, MessageFormatException.class, "soljms.error.messageformat", null}, {IllegalStateException.class, null, null, javax.jms.IllegalStateException.class, "soljms.error.illegalstate", null}, {JCSMPLoginFailureException.class, null, null, JMSSecurityException.class, "soljms.error.loginfailure", null}, {AccessDeniedException.class, null, null, JMSSecurityException.class, "soljms.error.accessdenied", null}, {JCSMPErrorResponseException.class, 503, null, "shutdown", "soljms.operation.consumer.create", JMSSecurityException.class, "soljms.error.shutdownendpoint", null}, {JCSMPErrorResponseException.class, 503, null, "shutdown", "soljms.operation.queue.browser", JMSSecurityException.class, "soljms.error.shutdownendpoint", null}, {JCSMPErrorResponseException.class, 503, null, "shutdown", "soljms.operation.send", JMSSecurityException.class, "soljms.error.shutdownendpoint", null}, {JCSMPErrorResponseException.class, 503, null, "unknown", "soljms.operation.consumer.create", JMSSecurityException.class, "soljms.error.unknownendpoint", null}, {JCSMPErrorResponseException.class, 503, null, "unknown", "soljms.operation.queue.browser", JMSSecurityException.class, "soljms.error.unknownendpoint", null}, {JCSMPErrorResponseException.class, 503, null, "unknown", "soljms.operation.unsubscribe", JMSSecurityException.class, "soljms.error.unknownendpoint", null}, {JCSMPErrorResponseException.class, 503, null, "unavailable", "soljms.operation.consumer.create", ConfigurationException.class, "soljms.error.notcapable", null}, {JCSMPErrorResponseException.class, 503, null, "unavailable", "soljms.operation.queue.browser", ConfigurationException.class, "soljms.error.notcapable", null}, {JCSMPErrorResponseException.class, 503, null, "unavailable", "soljms.operation.session.create", ConfigurationException.class, "soljms.error.notcapable", null}, {JCSMPErrorResponseException.class, 503, null, "Max Transacted Sessions Exceeded", "soljms.operation.session.create", ResourceAllocationException.class, "soljms.error.transactedsession.maxexceeded", null}, {JCSMPErrorResponseException.class, 503, null, "Max Transactions Exceeded", "soljms.operation.session.create", ResourceAllocationException.class, "soljms.error.transaction.maxexceeded", null}, {JCSMPErrorResponseException.class, 403, null, "Binding to an LVQ within an XASession is not allowed", "soljms.operation.consumer.create", ResourceAllocationException.class, "soljms.error.xa.lvqbinderror", null}, {JCSMPErrorResponseException.class, 403, null, "Non-XASession Cannot Bind to XA Endpoint", "soljms.operation.consumer.create", ResourceAllocationException.class, "soljms.error.xa.nonxasessiontoxaendpointbinderror", null}, {JCSMPErrorResponseException.class, 403, null, "XASession Cannot Bind to Non-XA Endpoint", "soljms.operation.consumer.create", ResourceAllocationException.class, "soljms.error.xa.xasessiontononxaendpointbinderror", null}, {JCSMPErrorResponseException.class, 403, null, "Replication Is Standby", null, ConfigurationException.class, "soljms.error.replicationisstandby", null}, {JCSMPErrorResponseException.class, 503, null, "Replication Is Standby", null, ConfigurationException.class, "soljms.error.replicationisstandby", null}, {JCSMPErrorResponseException.class, 401, null, "Unauthorized", null, JMSSecurityException.class, "soljms.error.loginfailure", null}, {JCSMPErrorResponseException.class, 403, null, "Client Certificate Authentication Is Shutdown", null, JMSSecurityException.class, "soljms.error.loginfailure.clientcertificateauthenticationisshutdown", null}, {JCSMPErrorResponseException.class, 403, null, "Basic Authentication Is Shutdown", null, JMSSecurityException.class, "soljms.error.loginfailure.basicauthenticationisshutdown", null}, {JCSMPErrorResponseException.class, 403, null, "Kerberos Authentication Is Shutdown", null, JMSSecurityException.class, "soljms.error.loginfailure.kerberosauthenticationisshutdown", null}, {JCSMPErrorResponseException.class, 403, null, "Untrusted Client Certificate", null, JMSSecurityException.class, "soljms.error.loginfailure.untrustedclientcertificate", null}, {JCSMPErrorResponseException.class, 403, null, "Client Certificate Not Yet Valid", null, JMSSecurityException.class, "soljms.error.loginfailure.clientcertificatedateinvalid", null}, {JCSMPErrorResponseException.class, 403, null, "Client Certificate Expired", null, JMSSecurityException.class, "soljms.error.loginfailure.clientcertificatedateinvalid", null}, {JCSMPErrorResponseException.class, 403, null, "Client Certificate Chain Too Long", null, JMSSecurityException.class, "soljms.error.loginfailure.untrustedclientcertificate", null}, {JCSMPErrorResponseException.class, 403, null, "Client Certificate Error", null, JMSSecurityException.class, "soljms.error.loginfailure.untrustedclientcertificate", null}, {JCSMPErrorResponseException.class, 400, null, "invalid selector", "soljms.operation.consumer.create", InvalidSelectorException.class, "soljms.error.invalidselector", null}, {JCSMPErrorResponseException.class, 403, 72, null, "soljms.operation.consumer.create", ConfigurationException.class, "soljms.error.topicendpointselectormatcherror", null}, {JCSMPErrorResponseException.class, 403, 71, null, "soljms.operation.consumer.create", ConfigurationException.class, "soljms.error.topicendpointsubscriptionmatcherror", null}, {JCSMPErrorResponseException.class, 400, null, "too many subscribers", "soljms.operation.consumer.create", ConfigurationException.class, "soljms.error.toomanysubscribers", null}, {JCSMPErrorResponseException.class, 400, null, "invalid selector", "soljms.operation.queue.browser", InvalidSelectorException.class, "soljms.error.invalidselector", null}, {JCSMPErrorResponseException.class, 400, null, null, "soljms.operation.consumer.create", DuplicateDurableSubscriptionException.class, "soljms.error.duplicatesubscriber", null}, {JCSMPErrorResponseException.class, 400, null, "Document Is Too Large", "soljms.operation.send", JMSException.class, "soljms.error.documenttoolarge", null}, {JCSMPErrorResponseException.class, 400, null, null, "soljms.operation.send", InvalidDestinationException.class, "soljms.error.queuenotfound", null}, {JCSMPErrorResponseException.class, 400, null, "invalid queue name", null, InvalidDestinationException.class, "soljms.error.illegaldestination", null}, {JCSMPErrorResponseException.class, 400, null, "Client Name Parse Error", null, InvalidClientIDException.class, "soljms.error.clientid.invalid", null}, {JCSMPErrorResponseException.class, 403, null, "Client Name Already In Use", null, InvalidClientIDException.class, "soljms.error.clientid.alreadyinuse", null}, {JCSMPErrorResponseException.class, 403, 38, null, "soljms.operation.send", ConfigurationException.class, "soljms.error.notcapable", null}, {IllegalArgumentException.class, "selector", "soljms.operation.consumer.create", InvalidSelectorException.class, "soljms.error.invalidselector", null}, {IllegalArgumentException.class, "selector", "soljms.operation.queue.browser", InvalidSelectorException.class, "soljms.error.invalidselector", null}, {IllegalArgumentException.class, JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.invalidTTL"), "soljms.operation.send", ConfigurationException.class, "soljms.error.invalidttl", null}, {IllegalArgumentException.class, "The maximum large message size exceeded", "soljms.operation.send", JMSException.class, "soljms.error.documenttoolarge", null}, {IllegalArgumentException.class, null, "soljms.operation.send", InvalidDestinationException.class, "soljms.error.illegaldestination", null}, {IllegalArgumentException.class, null, "soljms.operation.clientid.set", InvalidClientIDException.class, "soljms.error.clientid.invalid", null}, {PropertyMismatchException.class, "Respect TTL", null, ConfigurationException.class, "soljms.error.mismatchrespectttl", null}, {RollbackException.class, null, "soljms.operation.session.commit", TransactionRolledBackException.class, "soljms.error.transaction.rolledback", null}, {TransactionResultUnknownException.class, null, null, JMSException.class, "soljms.error.internal", null}, {JCSMPSecurityException.class, null, "soljms.operation.connection.create", JMSSecurityException.class, "soljms.error.loginfailure", null}, {JCSMPErrorResponseException.class, 403, null, "GSS Invalid Authentication", null, JMSSecurityException.class, "soljms.error.loginfailure", null}, {JCSMPErrorResponseException.class, 503, null, "Spool Over Quota", "soljms.operation.send", ResourceAllocationException.class, "soljms.error.spool.overquota", null}};
    private static JCSMPExceptionMapper ExceptionMapper = Validator.createMapper();

    public static void checkClosed(JMSState state, String component) throws JMSException {
        if (state == JMSState.Closed) {
            throw new javax.jms.IllegalStateException("The " + component + " is closed", "soljms.error.closed");
        }
    }

    public static void checkClientId(String jndiClientID, String dataClientID) throws InvalidClientIDException {
        if (jndiClientID != null && jndiClientID.equals(dataClientID)) {
            throw new InvalidClientIDException("Duplicate client IDs used for JNDI and data connections");
        }
    }

    public static void checkDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode != 2 && deliveryMode != 1) {
            throw new ConfigurationException("invalid deliveryMode specified");
        }
    }

    public static void checkConsumerDestination(Destination destination, SolConnectionIF conn) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("a null destination is invalid");
        }
        if (!(destination instanceof Queue) && !(destination instanceof Topic)) {
            throw new InvalidDestinationException("invalid destination provided");
        }
        Validator.checkConsumerTempDestination(destination, conn);
    }

    public static void checkConsumerTopicDestination(Destination destination, SolConnectionIF conn, boolean durable) throws JMSException {
        Validator.checkConsumerDestination(destination, conn);
        if (destination instanceof TemporaryTopic && durable) {
            throw new InvalidDestinationException("invalid destination provided - TemporaryTopic for a durable consumer");
        }
    }

    public static void checkProducerDestination(boolean crMode, Destination destination) throws JMSException {
        Validator.checkProducerTempDestination(destination);
        if (destination instanceof Topic && crMode && DestinationUtil.isWildCardedCrb(((SolDestination)destination).getPhysicalName())) {
            throw new InvalidDestinationException("cannot send to wildcard topic");
        }
    }

    public static Destination checkSendDestination(boolean crMode, Destination defaultDest, Destination dest) throws JMSException {
        SolTemporaryQueueIF tempQueue;
        SolTemporaryTopicIF tempTopic;
        if (dest == null) {
            if (defaultDest == null) {
                throw new InvalidDestinationException("a null destination is invalid");
            }
            return defaultDest;
        }
        if (dest instanceof Topic ? dest instanceof TemporaryTopic && (tempTopic = (SolTemporaryTopicIF)dest).isDeleted() : dest instanceof TemporaryQueue && (tempQueue = (SolTemporaryQueueIF)dest).isDeleted()) {
            throw new InvalidDestinationException(SolJMSErrorMessages.getMessage("soljms.operation.send", "soljms.error.tempdestination.deleted", null), "soljms.error.tempdestination.deleted");
        }
        return dest;
    }

    public static void checkProducerTempDestination(Destination destination) throws InvalidDestinationException {
        SolTemporaryQueueIF tempQueue;
        SolTemporaryTopicIF tempTopic;
        if (destination instanceof TemporaryTopic ? (tempTopic = (SolTemporaryTopicIF)destination).isDeleted() : destination instanceof TemporaryQueue && (tempQueue = (SolTemporaryQueueIF)destination).isDeleted()) {
            throw new InvalidDestinationException(SolJMSErrorMessages.getMessage("soljms.operation.producer.create", "soljms.error.tempdestination.deleted", null), "soljms.error.tempdestination.deleted");
        }
    }

    public static void checkConsumerTempDestination(Destination destination, SolConnectionIF conn) throws InvalidDestinationException {
        if (destination instanceof TemporaryTopic) {
            SolTemporaryTopicIF tempTopic = (SolTemporaryTopicIF)destination;
            SolConnectionIF tempTopicConn = tempTopic.getConnection();
            if (tempTopicConn == null || tempTopicConn != conn) {
                throw new InvalidDestinationException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.tempdestination.notcreator", null), "soljms.error.tempdestination.notcreator");
            }
            if (tempTopic.isDeleted()) {
                throw new InvalidDestinationException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.tempdestination.deleted", null), "soljms.error.tempdestination.deleted");
            }
        } else if (destination instanceof TemporaryQueue) {
            SolTemporaryQueueIF tempQueue = (SolTemporaryQueueIF)destination;
            SolConnectionIF tempQueueConn = tempQueue.getConnection();
            if (tempQueueConn == null || tempQueueConn != conn) {
                throw new InvalidDestinationException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.tempdestination.notcreator", null), "soljms.error.tempdestination.notcreator");
            }
            if (tempQueue.isDeleted()) {
                throw new InvalidDestinationException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.tempdestination.deleted", null), "soljms.error.tempdestination.deleted");
            }
        }
    }

    public static void checkDeleteTempDestination(Destination destination, SolConnectionIF conn) throws InvalidDestinationException {
        SolTemporaryQueueIF tempQueue;
        SolConnectionIF tempQueueConn;
        SolTemporaryTopicIF tempTopic;
        SolConnectionIF tempTopicConn;
        if (destination instanceof TemporaryTopic ? (tempTopicConn = (tempTopic = (SolTemporaryTopicIF)destination).getConnection()) == null || tempTopicConn != conn : destination instanceof TemporaryQueue && ((tempQueueConn = (tempQueue = (SolTemporaryQueueIF)destination).getConnection()) == null || tempQueueConn != conn)) {
            throw new InvalidDestinationException(SolJMSErrorMessages.getMessage("soljms.operation.temp.destination.delete", "soljms.error.tempdestination.notcreator", null), "soljms.error.tempdestination.notcreator");
        }
    }

    public static void checkMessage(Message message) throws JMSException {
        if (message == null) {
            throw new JMSException("null message supplied", "soljms.error.nullmessage");
        }
    }

    public static void checkPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 9) {
            throw new ConfigurationException("invalid priority specified");
        }
    }

    public static void checkSubscriptionName(String name) throws JMSException {
        if (name == null || name.length() == 0) {
            throw new ConfigurationException("invalid subscription name provided");
        }
    }

    public static void checkTimeToLive(long timeToLive) throws JMSException {
        if (timeToLive < 0L) {
            throw new ConfigurationException("cannot set a negative timeToLive");
        }
    }

    public static void checkTransactedAndAckMode(SessionTransactionType transactionType, int acknowledgeMode, boolean useDirect) throws JMSException {
        if (transactionType != SessionTransactionType.NoTransaction) {
            if (useDirect) {
                throw new ConfigurationException("Transacted sessions or XA sessions are not supported with direct transport", "soljms.error.transactedsessiondirectmismatch");
            }
        } else if (acknowledgeMode != 1 && acknowledgeMode != 2 && acknowledgeMode != 3 && acknowledgeMode != 4 && acknowledgeMode != 23) {
            throw new ConfigurationException("invalid acknowledgeMode");
        }
    }

    public static void checkTransactedAndLargeMessaging(SessionTransactionType transactedType, boolean largeMessaging) throws JMSException {
        if (largeMessaging && (transactedType == SessionTransactionType.LocalTransaction || transactedType == SessionTransactionType.XATransaction)) {
            throw new ConfigurationException("Large messaging is not supported for transacted sessions");
        }
    }

    public static void checkTransacted(SessionTransactionType transactionType, String operation) throws JMSException {
        if (transactionType == SessionTransactionType.NoTransaction) {
            throw new javax.jms.IllegalStateException(SolJMSErrorMessages.getMessage(operation, "soljms.error.nontransactedsession.illegaloperation", null), "soljms.error.nontransactedsession.illegaloperation");
        }
    }

    public static void checkNotTransacted(SessionTransactionType transactionType, String operation) throws JMSException {
        if (transactionType != SessionTransactionType.NoTransaction) {
            throw new javax.jms.IllegalStateException(SolJMSErrorMessages.getMessage(operation, "soljms.error.transactedsession.illegaloperation", null), "soljms.error.transactedsession.illegaloperation");
        }
    }

    public static boolean wasConsumerClosedInReceive(JCSMPException e) throws JMSException {
        return e instanceof JCSMPTransportException && JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageConsumer.recvTransportException").equals(e.getMessage());
    }

    public static void checkServerSessionPool(ServerSessionPool pool) throws JMSException {
        if (pool == null) {
            throw new ConfigurationException("a null ServerSessionPool is invalid");
        }
    }

    public static void checkConnectionConsumerMaxMessages(int maxMessages) throws JMSException {
        if (maxMessages <= 0) {
            throw new ConfigurationException(String.format("maxMessages (%s) must be at least 1", maxMessages));
        }
    }

    public static String checkSelector(String selector) {
        if (selector == null || selector.length() == 0) {
            return null;
        }
        return selector;
    }

    private static JCSMPExceptionMapper createMapper() {
        JCSMPExceptionMapper mapper = new JCSMPExceptionMapper();
        for (int i = 0; i < ExceptionMap.length; ++i) {
            JMSExceptionValue value;
            JCSMPExceptionKey key;
            if (((Class)ExceptionMap[i][0]).equals(JCSMPErrorResponseException.class)) {
                key = new JCSMPErrorExceptionKey((Class)ExceptionMap[i][0], (Integer)ExceptionMap[i][1], (Integer)ExceptionMap[i][2], (String)ExceptionMap[i][3], (String)ExceptionMap[i][4]);
                value = new JMSExceptionValue((Class)ExceptionMap[i][5], (String)ExceptionMap[i][6], (String)ExceptionMap[i][7]);
            } else {
                key = new JCSMPExceptionKey((Class)ExceptionMap[i][0], (String)ExceptionMap[i][1], (String)ExceptionMap[i][2]);
                value = new JMSExceptionValue((Class)ExceptionMap[i][3], (String)ExceptionMap[i][4], (String)ExceptionMap[i][5]);
            }
            mapper.put(key, value);
        }
        return mapper;
    }

    public static JMSException createJMSException(String operation, Throwable t) {
        return ExceptionMapper.get(operation, t);
    }
}

