/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.impl.MessageMetadataAdapter;
import com.solacesystems.jcsmp.impl.PubSubMode;
import com.solacesystems.jcsmp.impl.TargetRouterMode;
import java.io.Serializable;

public abstract class AbstractDestination
implements Destination,
Serializable {
    private static final long serialVersionUID = 4028520745614794276L;
    protected static final String DEST_INVALID_IN_MODE = "Destination (%s) invalid in specified mode (%s).";
    protected static final String DEST_INVALID_FOR_MSGTYPE = "Destination (%s) invalid for publishing message type (%s) in specified mode (%s).";
    protected String name;
    protected String hostId;
    protected MessageMetadataAdapter m_adaptor;
    protected byte[] trmTopicBytes = null;
    protected int trmDestOffset = 0;
    protected int trmDestLength = 0;
    protected volatile boolean isInitialized = false;
    protected volatile boolean isValidatedCrbPub = false;
    protected volatile boolean isValidatedCrbSub = false;
    protected volatile boolean isValidCrbPub = false;
    protected volatile boolean isValidCrbSub = false;
    protected volatile boolean isValidatedTrbPub = false;
    protected volatile boolean isValidatedTrbSub = false;
    protected volatile boolean isValidTrbPub = false;
    protected volatile boolean isValidTrbSub = false;

    protected AbstractDestination(String name) {
        this.name = name;
        this.hostId = null;
    }

    protected AbstractDestination(String name, String hostId) {
        this.name = name;
        this.hostId = hostId == null || hostId.length() == 0 ? null : hostId;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void initIfRequired() {
        if (!this.isInitialized) {
            this.init();
        }
    }

    protected abstract void init();

    protected abstract void validateCommon();

    protected abstract void validate(TargetRouterMode var1, PubSubMode var2);

    protected abstract void validateModeForPublish(DeliveryMode var1, TargetRouterMode var2, boolean var3);

    protected String fmtInvalidDestinationErr(String mode) {
        return String.format(DEST_INVALID_IN_MODE, this.toString(), mode);
    }

    protected String fmtInvalidDestinationForMsgtype(DeliveryMode mt, TargetRouterMode vm) {
        return String.format(DEST_INVALID_FOR_MSGTYPE, this.toString(), mt.toString(), vm.toString());
    }

    protected abstract byte[] getTrmTopicRepresentation();

    protected int getTrmDestOffset() {
        return this.trmDestOffset;
    }

    protected int getTrmDestLength() {
        return this.trmDestLength;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    public String getVirtualRouterName() {
        return this.hostId;
    }

    protected static enum ValidationMode {
        CRB,
        TRB;

    }
}

