/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.encoding;

import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.MapMessage;
import com.solacesystems.jcsmp.StreamMessage;
import com.solacesystems.jcsmp.TextMessage;
import com.solacesystems.jcsmp.XMLContentMessage;
import com.solacesystems.jms.message.SolBytesMessage;
import com.solacesystems.jms.message.SolMapMessage;
import com.solacesystems.jms.message.SolMessage;
import com.solacesystems.jms.message.SolObjectMessage;
import com.solacesystems.jms.message.SolStreamMessage;
import com.solacesystems.jms.message.SolTextMessage;
import javax.jms.JMSException;

public class JMSDecoder {
    public static SolMessage createJMSMessage(BytesXMLMessage message) {
        byte msgType;
        SolMessage jmsMessage = null;
        int priority = 0;
        jmsMessage = message instanceof MapMessage ? new SolMapMessage((MapMessage)message) : (message instanceof StreamMessage ? new SolStreamMessage((StreamMessage)message) : (message instanceof TextMessage ? new SolTextMessage(message) : (message instanceof XMLContentMessage ? new SolTextMessage(message) : ((msgType = message.getStructuredMsgType()) == 2 ? new SolBytesMessage(message) : (msgType == 3 ? new SolObjectMessage(message) : (msgType == 4 ? new SolMessage(message) : (message.getContentLength() > 0 ? new SolTextMessage(message) : new SolBytesMessage(message))))))));
        if (message.getDeliveryMode() == DeliveryMode.PERSISTENT) {
            jmsMessage.setJMSDeliveryMode(2);
        } else {
            jmsMessage.setJMSDeliveryMode(1);
            if (message.getDeliveryMode() == DeliveryMode.DIRECT) {
                jmsMessage.setDiscardIndication(message.getDiscardIndication());
            }
        }
        if (jmsMessage instanceof SolTextMessage) {
            jmsMessage.setIsXML(message.getContentLength() > 0);
        }
        jmsMessage.setIsDMQEligible(message.isDMQEligible());
        jmsMessage.setIsElidingEligible(message.isElidingEligible());
        jmsMessage.setIsDTO(message.getDeliverToOne());
        jmsMessage.setIsReplyMsg(message.isReplyMessage());
        priority = message.getPriority();
        if (priority > 9) {
            priority = 9;
        }
        if (priority != -1) {
            try {
                jmsMessage.setJMSPriority(priority);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        jmsMessage.setJMSRedelivered(message.getRedelivered());
        if (message.isDeliveryCountSupported()) {
            jmsMessage.setJMSXDeliveryCount(message.getDeliveryCount());
        } else {
            jmsMessage.setJMSXDeliveryCount(message.getRedelivered() ? 2 : 1);
        }
        jmsMessage.setJMSExpiration(message.getExpiration());
        if (message.getTopicSequenceNumber() != null) {
            jmsMessage.setTopicSequenceNumber(message.getTopicSequenceNumber());
        }
        jmsMessage.setHTTPContentType(message.getHTTPContentType());
        jmsMessage.setHTTPContentEncoding(message.getHTTPContentEncoding());
        jmsMessage.setSenderID(message.getSenderId());
        return jmsMessage;
    }
}

