/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.UUID;

public class DestinationUtil {
    private static final String ERROR_TOPIC_IS_NULL = "Topic cannot be null";
    private static final String ERROR_TOPIC_TOO_SHORT = "Topic must have a minimum length of ";
    private static final String ERROR_TOPIC_TOO_LONG = "Topic must have a maximum length of ";
    private static final String ERROR_TOPIC_HAS_ILLEGAL_GREATER_THAN = "Topic contains illegally used character [>]";
    private static final String ERROR_TOPIC_HAS_ILLEGAL_STAR = "Topic contains illegally used character [*]";
    private static final String ERROR_TOPIC_HAS_EMPTY_LEVEL = "Topic contains empty level";
    private static final String ERROR_TOPIC_HAS_ILLEGAL_CHAR = "Topic contains illegal character [";
    private static final String ERROR_TOPIC_HAS_ILLEGAL_CONTROL_CHAR = "Topic contains illegal control character [";
    private static final String ERROR_TOPIC_HAS_ILLEGAL_WHITESPACE = "Topic contains illegal whitespace";
    public static final String ERROR_TOPIC_IS_WILD = "Cannot publish to wildcard topic";
    private static final String ERROR_ILLEGAL_CHAR = "%s name \"%s\" contains illegal character [%s]";
    private static final String ERROR_ILLEGAL_CONTROL_CHAR = "%s name \"%s\" contains illegal control character [%d]";
    public static final char DestinationDelimiter = '/';
    public static final char WildCardChar = '>';
    public static final String WildCardStr = new String(new char[]{'>'});
    public static final byte WildCardByte = 62;
    public static final int MIN_TOPIC_LENGTH = 1;
    public static final int MAX_TOPIC_LENGTH = 250;
    public static final int MIN_QUEUE_LENGTH = 1;
    public static final int MAX_QUEUE_LENGTH = 200;
    public static final int MAX_QUEUE_LENGTH_TEMPQUEUE = 250;
    private static final String ERROR_NAME_IS_NULL = "Name cannot be null";
    private static final String ERROR_QUEUE_HAS_EMPTY_LEVEL = "Queue name \"%s\" contains empty level";
    private static final String ERROR_NAME_TOO_LONG = "%s name \"%s\" must have a maximum length of %s";
    private static final String QUEUE = "Queue";
    private static final String TOPIC = "Topic Endpoint";

    public static boolean isWildCardedCrb(String topic) {
        if (DestinationUtil.isGlobalWildcard(topic)) {
            return true;
        }
        int l = topic.length();
        return l > 2 && topic.charAt(l - 1) == '>' && topic.charAt(l - 2) == '/';
    }

    public static boolean isWildCardedCrb(byte[] topic) {
        if (DestinationUtil.isGlobalWildcard(topic)) {
            return true;
        }
        int l = topic.length;
        return l > 2 && topic[l - 1] == 62 && topic[l - 2] == 47;
    }

    public static boolean isWildCardedTrb(String topic) {
        if (DestinationUtil.isGlobalWildcard(topic)) {
            return true;
        }
        int l = topic.length();
        if (l >= 2 && topic.charAt(l - 2) == '/' && topic.charAt(l - 1) == '>') {
            return true;
        }
        for (int i = 0; i < l; ++i) {
            if (topic.charAt(i) != '*') continue;
            return true;
        }
        return false;
    }

    public static boolean isGlobalWildcard(String topic) {
        return topic.equals(WildCardStr);
    }

    public static boolean isGlobalWildcard(byte[] topic) {
        return topic.length == 1 && topic[0] == 62;
    }

    public static void isValidTopicTrb(String topic, boolean isPub) throws IllegalArgumentException {
        int length = DestinationUtil.validateLength(topic, true);
        int numchars = topic.length();
        for (int i = 0; i < numchars; ++i) {
            char c = topic.charAt(i);
            if (c != '/') continue;
            if (i == 0 || i == length - 1) {
                throw new IllegalArgumentException("Topic contains empty level - " + topic);
            }
            if (topic.charAt(i - 1) != '/') continue;
            throw new IllegalArgumentException("Topic contains empty level - " + topic);
        }
    }

    public static int validateLength(String topic, boolean includeTopic) {
        if (topic == null) {
            throw new IllegalArgumentException(ERROR_TOPIC_IS_NULL);
        }
        byte[] topic_data_utf8 = null;
        try {
            topic_data_utf8 = topic.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            topic_data_utf8 = topic.getBytes(Charset.forName("UTF-8"));
        }
        int length = topic_data_utf8.length;
        if (length < 1) {
            throw new IllegalArgumentException("Topic must have a minimum length of 1");
        }
        if (length > 250) {
            String exMsg = "Topic must have a maximum length of 250";
            if (includeTopic) {
                exMsg = exMsg + " - " + topic;
            }
            throw new IllegalArgumentException(exMsg);
        }
        return length;
    }

    public static void isValidTopic(String topic, boolean isPub) throws IllegalArgumentException {
        if (topic == null) {
            throw new IllegalArgumentException(ERROR_TOPIC_IS_NULL);
        }
        int length = topic.length();
        if (length < 1) {
            throw new IllegalArgumentException("Topic must have a minimum length of 1");
        }
        if (length > 250) {
            throw new IllegalArgumentException("Topic must have a maximum length of 250");
        }
        for (int i = 0; i < length; ++i) {
            char c = topic.charAt(i);
            if (c == '>') {
                if (isPub) {
                    throw new IllegalArgumentException(ERROR_TOPIC_HAS_ILLEGAL_GREATER_THAN);
                }
                if (length == 1 || i == length - 1 && topic.charAt(i - 1) == '/') continue;
                throw new IllegalArgumentException(ERROR_TOPIC_HAS_ILLEGAL_GREATER_THAN);
            }
            if (c == '/') {
                if (i == 0 || i == length - 1) {
                    throw new IllegalArgumentException(ERROR_TOPIC_HAS_EMPTY_LEVEL);
                }
                if (topic.charAt(i - 1) != '/') continue;
                throw new IllegalArgumentException(ERROR_TOPIC_HAS_EMPTY_LEVEL);
            }
            if (c == '\"' || c == '&' || c == '*' || c == '\'' || c == '<') {
                throw new IllegalArgumentException(ERROR_TOPIC_HAS_ILLEGAL_CHAR + c + "]");
            }
            if (c == ' ' || c == '\t') {
                throw new IllegalArgumentException(ERROR_TOPIC_HAS_ILLEGAL_WHITESPACE);
            }
            if (!Character.isISOControl(c)) continue;
            throw new IllegalArgumentException(ERROR_TOPIC_HAS_ILLEGAL_CONTROL_CHAR + c + "]");
        }
    }

    public static String normalizeDestination(String destination) {
        return destination.toLowerCase();
    }

    public static void isValidQueuePhysicalName(String name, boolean isDurable) throws IllegalArgumentException {
        DestinationUtil.isValidEndpointName(name, isDurable, true);
    }

    public static void isValidTopicEndpointPhysicalName(String name, boolean isDurable) throws IllegalArgumentException {
        DestinationUtil.isValidEndpointName(name, isDurable, false);
    }

    public static void isValidDTEPhysicalName(String name) throws IllegalArgumentException {
        DestinationUtil.isValidTopicEndpointPhysicalName(name, false);
    }

    private static void isValidEndpointName(String name, boolean isDurable, boolean isQueue) throws IllegalArgumentException {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException(ERROR_NAME_IS_NULL);
        }
        int length = name.length();
        String objectType = isQueue ? QUEUE : TOPIC;
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (c == '\'' || c == '*' || c == '<' || c == '>' || c == '&' || c == ';' || c == '?') {
                throw new IllegalArgumentException(String.format(ERROR_ILLEGAL_CHAR, objectType, name, Character.valueOf(c)));
            }
            if (c == '\u0000') {
                throw new IllegalArgumentException(String.format(ERROR_ILLEGAL_CONTROL_CHAR, objectType, name, (int)c));
            }
            if (!isQueue || c != '/') continue;
            if (i == 0 || i == length - 1) {
                throw new IllegalArgumentException(String.format(ERROR_QUEUE_HAS_EMPTY_LEVEL, name));
            }
            if (name.charAt(i - 1) != '/') continue;
            throw new IllegalArgumentException(String.format(ERROR_QUEUE_HAS_EMPTY_LEVEL, name));
        }
        int max_queue_len = isDurable ? 200 : 250;
        try {
            byte[] nameBytes = name.getBytes("UTF-8");
            if (nameBytes.length > max_queue_len) {
                throw new IllegalArgumentException(String.format(ERROR_NAME_TOO_LONG, objectType, name, max_queue_len));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static boolean haslineBreak(String name) throws IllegalArgumentException {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException(ERROR_NAME_IS_NULL);
        }
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '\r' && name.charAt(i) != '\n') continue;
            return true;
        }
        return false;
    }

    public static String createNonDurQueueTrbTopic(String vridName, String name) {
        if (name == null) {
            return String.format("#P2P/QTMP/%s/%s", vridName, UUID.randomUUID().toString());
        }
        return String.format("#P2P/QTMP/%s/%s", vridName, name);
    }

    public static String createDurQueueTrbTopic(String qName, String hostId) {
        return String.format("#P2P/QUE/%s", qName);
    }

    public static String createNonDurTopicTrbTopic(String vridName, String name) {
        if (name == null) {
            return String.format("#P2P/TTMP/%s/%s", vridName, UUID.randomUUID().toString());
        }
        return String.format("#P2P/TTMP/%s/%s", vridName, name);
    }
}

