/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.PubADManager;
import com.solacesystems.jcsmp.impl.WireMessageEncoder;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.WireMessageFactory;

public class OpenFlowWireMessageEncoder
implements WireMessageEncoder {
    private JCSMPBasicSession _session;
    private JCSMPXMLMessageProducer _producer;
    private int _pubWinSz;

    public OpenFlowWireMessageEncoder(JCSMPBasicSession session, JCSMPXMLMessageProducer producer, int pubWinSz) {
        this._session = session;
        this._producer = producer;
        this._pubWinSz = pubWinSz;
    }

    @Override
    public WireMessage encode() {
        PubADManager admgr = this._producer.getPubADManager();
        SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
        Long transactedSessionId = this._producer.getTransactedSession() == null ? null : Long.valueOf(this._producer.getTransactedSession().getTransactedSessionId());
        AssuredCtrlHeaderBean assBean = this._session.getAssuredCtrlFactory().createOpenFlowRequest(admgr.lastMessageIdSent, admgr.lastMessageIdAcked, this._pubWinSz, admgr.flow_Name, transactedSessionId);
        WireMessage msgReq = WireMessageFactory.createWith(smfHeader, assBean);
        msgReq.setFriendlyName("ADCTRL-ProducerOpenFlow");
        return msgReq;
    }
}

