/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.protocol;

import com.solacesystems.common.protocol.ProtocolEvent;
import com.solacesystems.common.protocol.ProtocolEventListener;
import com.solacesystems.common.protocol.ProtocolRequest;
import com.solacesystems.common.protocol.ProtocolRequestException;
import com.solacesystems.common.protocol.ProtocolRequestListener;
import com.solacesystems.common.protocol.ProtocolResponse;
import java.util.ArrayList;

public abstract class ProtocolAdapter
implements ProtocolRequestListener,
ProtocolEventListener {
    public static final String XML_FRAGMENT_START = "<xml-fragment>";
    public static final String XML_FRAGMENT_END = "</xml-fragment>";
    public static final String XML_FRAGMENT_START_END = "<xml-fragment/>";
    public static boolean ReadOnly;
    private ProtocolRequestListener m_requestListener = null;
    private ArrayList<ProtocolEventListener> m_eventListeners = new ArrayList();
    private boolean allowVersionMismatch;

    public void addNBProtocolAdapter(ProtocolAdapter adapter) {
        this.addProtocolEventListener(adapter);
        adapter.setProtocolRequestListener(this);
    }

    public void addSBProtocolAdapter(ProtocolAdapter adapter) {
        this.setProtocolRequestListener(adapter);
        adapter.addProtocolEventListener(this);
    }

    public void setProtocolRequestListener(ProtocolRequestListener listener) {
        if (this.m_requestListener != null && this.m_requestListener instanceof ProtocolAdapter) {
            ((ProtocolAdapter)this.m_requestListener).setProtocolRequestListener(listener);
        } else {
            this.m_requestListener = listener;
        }
    }

    public ProtocolResponse notifyProtocolRequestListener(ProtocolRequest request) throws ProtocolRequestException {
        if (this.m_requestListener != null) {
            return this.m_requestListener.protocolRequestNotify(request);
        }
        throw new UnsupportedOperationException("No request listener");
    }

    public void addProtocolEventListener(ProtocolEventListener listener) {
        this.m_eventListeners.add(listener);
    }

    public void removeProtocolEventListener(ProtocolEventListener listener) {
        this.m_eventListeners.remove(listener);
    }

    public void notifyProtocolEventListeners(ProtocolEvent event) {
        for (int i = 0; i < this.m_eventListeners.size(); ++i) {
            this.m_eventListeners.get(i).protocolEventNotify(event);
        }
    }

    public ProtocolResponse protocolRequestNotify(ProtocolRequest request) throws ProtocolRequestException {
        return this.sendRequest(request);
    }

    public void protocolEventNotify(ProtocolEvent event) {
    }

    protected String getStringContentFromXmlText(String strInXmlText) {
        String str = "";
        if (!strInXmlText.equals(XML_FRAGMENT_START_END) && !strInXmlText.equals("<xml-fragment></xml-fragment>")) {
            int start = strInXmlText.indexOf(XML_FRAGMENT_START);
            int end = strInXmlText.indexOf(XML_FRAGMENT_END);
            if (start >= 0 && end >= 0) {
                str = strInXmlText.substring(start + XML_FRAGMENT_START.length(), end);
            }
        }
        return str;
    }

    protected String modifyElement(String reqString, String elementStrInObject, String elementStrInXmlText, String elementStartTag, String elementEndTag, String elementStartEndTag) {
        return this.modifyElement(reqString, elementStrInObject, elementStrInXmlText, elementStartTag, elementEndTag, elementStartEndTag, 0);
    }

    protected String modifyElement(String reqString, String elementStrInObject, String elementStrInXmlText, String elementStartTag, String elementEndTag, String elementStartEndTag, int startFrom) {
        int len = elementStrInObject.length();
        if (len == 0) {
            return null;
        }
        char firstChar = elementStrInObject.charAt(0);
        char lastChar = elementStrInObject.charAt(len - 1);
        if (firstChar == ' ' || firstChar == '\t' || firstChar == '\n' || firstChar == '\r' || lastChar == ' ' || lastChar == '\t' || lastChar == '\n' || lastChar == '\r') {
            String topicStrInReq = "";
            String topicInReq = "";
            String topicStrInXml = this.getStringContentFromXmlText(elementStrInXmlText);
            int startIndex = reqString.indexOf(elementStartTag, startFrom);
            if (startIndex >= 0) {
                int endIndex = reqString.indexOf(elementEndTag, startIndex);
                topicStrInReq = reqString.substring(startIndex + elementStartTag.length(), endIndex);
                if (!elementStrInObject.equals(topicStrInReq)) {
                    topicInReq = reqString.substring(startIndex, endIndex + elementEndTag.length());
                    String newTopicReq = elementStartTag + topicStrInXml + elementEndTag;
                    String newReqString = reqString.replace(topicInReq, newTopicReq);
                    return newReqString;
                }
            } else if (!elementStrInObject.equals(topicStrInReq)) {
                String newTopicReq = elementStartTag + topicStrInXml + elementEndTag;
                String newReqString = reqString.replace(elementStartEndTag, newTopicReq);
                return newReqString;
            }
        }
        return null;
    }

    public boolean isAllowVersionMismatch() {
        return this.allowVersionMismatch;
    }

    public void setAllowVersionMismatch(boolean allowVersionMismatch) {
        this.allowVersionMismatch = allowVersionMismatch;
    }

    public abstract ProtocolResponse sendRequest(ProtocolRequest var1) throws ProtocolRequestException;

    static {
        String readonlyJsemp = System.getProperty("readOnlyJsemp");
        ReadOnly = readonlyJsemp != null && readonlyJsemp.equalsIgnoreCase("true");
    }
}

