/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jms.encoding.JMSDecoder;
import com.solacesystems.jms.impl.AckHandler;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.message.SolMessage;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCSMPMessageListener
implements XMLMessageListener {
    private static final Log log = LogFactory.getLog(JCSMPMessageListener.class);
    private MessageListener mListener = null;
    private AckHandler mAckHandler;
    private ExceptionListener mExceptionListener;

    public JCSMPMessageListener(AckHandler ackHandler, ExceptionListener exceptionListener) {
        this.mAckHandler = ackHandler;
        this.mExceptionListener = exceptionListener;
    }

    public void setMessageListener(MessageListener listener) {
        this.mListener = listener;
    }

    public MessageListener getMessageListener() {
        return this.mListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.mExceptionListener;
    }

    public void onException(JCSMPException exception) {
        if (log.isInfoEnabled()) {
            log.info((Object)"Exception on async receiving", (Throwable)((Object)exception));
        }
        if (!(exception instanceof JCSMPTransportException)) {
            this.mExceptionListener.onException(Validator.createJMSException("soljms.operation.recv", (Throwable)((Object)exception)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReceive(BytesXMLMessage message) {
        boolean messageProcessed;
        SolMessage jmsMessage;
        block12: {
            jmsMessage = null;
            messageProcessed = false;
            if (this.mListener == null || message == null) break block12;
            jmsMessage = JMSDecoder.createJMSMessage(message);
            jmsMessage.setAckHandler(this.mAckHandler);
            this.mAckHandler.onMessageCreate(jmsMessage);
            this.mListener.onMessage((Message)jmsMessage);
            messageProcessed = true;
        }
        Object var6_4 = null;
        if (jmsMessage == null || !messageProcessed) return;
        try {
            this.mAckHandler.onMessageSent(jmsMessage);
            return;
        }
        catch (JMSException e) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Exception on async receiving", (Throwable)e);
            }
            this.mExceptionListener.onException(e);
        }
        return;
        {
            catch (Throwable t) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Error on async receiving of BytesXMLMessage", t);
                }
                Object var6_5 = null;
                if (jmsMessage == null || !messageProcessed) return;
                try {
                    this.mAckHandler.onMessageSent(jmsMessage);
                    return;
                }
                catch (JMSException e) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Exception on async receiving", (Throwable)e);
                    }
                    this.mExceptionListener.onException(e);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (jmsMessage == null || !messageProcessed) throw throwable;
            try {
                this.mAckHandler.onMessageSent(jmsMessage);
                throw throwable;
            }
            catch (JMSException e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Exception on async receiving", (Throwable)e);
                }
                this.mExceptionListener.onException(e);
            }
            throw throwable;
        }
    }
}

