/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jcsmp.BytesMessage;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPProducerEventHandler;
import com.solacesystems.jcsmp.JCSMPStreamingPublishCorrelatingEventHandler;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.MapMessage;
import com.solacesystems.jcsmp.ProducerEvent;
import com.solacesystems.jcsmp.ProducerEventArgs;
import com.solacesystems.jcsmp.StreamMessage;
import com.solacesystems.jcsmp.TextMessage;
import com.solacesystems.jcsmp.XMLContentMessage;
import com.solacesystems.jms.SolConnection;
import com.solacesystems.jms.SolProducerEventListener;
import com.solacesystems.jms.events.SolRepublishUnackedMessageEvent;
import com.solacesystems.jms.impl.ConnectionProperties;
import com.solacesystems.jms.impl.JCSMPMessageProducer;
import com.solacesystems.jms.impl.MessageProducerAdapter;
import com.solacesystems.jms.impl.SendResult;
import com.solacesystems.jms.impl.SessionProperties;
import com.solacesystems.jms.impl.Validator;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultMessageProducerAdapter
implements MessageProducerAdapter,
JCSMPStreamingPublishCorrelatingEventHandler,
JCSMPProducerEventHandler {
    protected static final String DefaultMessageProducerKey = "DefaultMessageProducerKey";
    protected static final String FlowNumProducersKey = "FlowNumProducers";
    protected SessionProperties mSessionProps;
    protected JCSMPMessageProducer mDefaultProducer;
    protected SendResult mResult;
    protected ArrayBlockingQueue<SendResult> mQueue;
    protected final boolean mOptDirectNoLock;
    private SolProducerEventListener mEventHandler;
    private static final Log log = LogFactory.getLog(SolConnection.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMessageProducerAdapter(SessionProperties props, boolean createSendResult) throws JCSMPException {
        this.mSessionProps = props;
        ConnectionProperties connectionProps = props.getConnectionProperties();
        Map<String, Object> connectionUserProps = connectionProps.getUserProperties();
        this.mOptDirectNoLock = (Boolean)connectionProps.getJCSMPSession().getProperty("topic_dispatch_optimize_direct");
        Map<String, Object> map = connectionUserProps;
        synchronized (map) {
            if (this.mOptDirectNoLock && connectionProps.getPropertyBean().getDirectTransport().booleanValue()) {
                Integer numProducers = (Integer)connectionUserProps.get(FlowNumProducersKey);
                if (numProducers != null && numProducers > 0) {
                    throw new InvalidOperationException("Only a single producer may be created when JCSMPProperties.TOPIC_DISPATCH_OPTIMIZE_DIRECT is set.");
                }
                connectionUserProps.put(FlowNumProducersKey, 1);
            }
            this.mDefaultProducer = (JCSMPMessageProducer)connectionUserProps.get(DefaultMessageProducerKey);
            if (this.mDefaultProducer == null) {
                this.mDefaultProducer = new JCSMPMessageProducer(props.getConnectionProperties().getJCSMPSession().getMessageProducer(this, this), new ReentrantLock());
                connectionUserProps.put(DefaultMessageProducerKey, this.mDefaultProducer);
            }
        }
        if (createSendResult) {
            this.mResult = new SendResult();
            this.mQueue = this.mResult.getQueue();
        } else {
            this.mResult = null;
            this.mQueue = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.mOptDirectNoLock && this.mSessionProps.getConnectionProperties().getPropertyBean().getDirectTransport().booleanValue()) {
            Map<String, Object> userProps;
            Map<String, Object> map = userProps = this.mSessionProps.getConnectionProperties().getUserProperties();
            synchronized (map) {
                userProps.put(FlowNumProducersKey, 0);
            }
        }
    }

    public void cancel(JCSMPException e) {
        if (this.mResult != null) {
            try {
                this.mResult.fail(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setProducerEventListener(SolProducerEventListener eventListener) {
        this.mEventHandler = eventListener;
    }

    public BytesMessage createBytesMessage(DeliveryMode deliveryMode) throws JCSMPException {
        return this.mDefaultProducer.getXMLMessageProducer().createBytesMessage();
    }

    public BytesXMLMessage createBytesXMLMessage(DeliveryMode deliveryMode) throws JCSMPException {
        return this.mDefaultProducer.getXMLMessageProducer().createBytesXMLMessage();
    }

    public MapMessage createMapMessage(DeliveryMode deliveryMode) throws JCSMPException {
        return this.mDefaultProducer.getXMLMessageProducer().createMapMessage();
    }

    public StreamMessage createStreamMessage(DeliveryMode deliveryMode) throws JCSMPException {
        return this.mDefaultProducer.getXMLMessageProducer().createStreamMessage();
    }

    public TextMessage createTextMessage(DeliveryMode deliveryMode) throws JCSMPException {
        return this.mDefaultProducer.getXMLMessageProducer().createTextMessage();
    }

    public XMLContentMessage createXMLContentMessage(DeliveryMode deliveryMode) throws JCSMPException {
        return this.mDefaultProducer.getXMLMessageProducer().createXMLContentMessage();
    }

    public void send(BytesXMLMessage msg, Destination destination) throws JCSMPException {
        block6: {
            if (msg.getDeliveryMode().equals((Object)DeliveryMode.PERSISTENT)) {
                this.mResult.reset();
                msg.setCorrelationKey(this.mResult);
                this.mDefaultProducer.send(msg, destination);
                try {
                    SendResult result = this.mQueue.take();
                    if (!result.isSuccessful()) {
                        throw result.getException();
                    }
                    break block6;
                }
                catch (InterruptedException e) {
                    throw new JCSMPException(e.getMessage());
                }
            }
            if (this.mOptDirectNoLock) {
                this.mDefaultProducer.getXMLMessageProducer().send(msg, destination);
            } else {
                this.mDefaultProducer.send(msg, destination);
            }
        }
    }

    private void deliverException(JMSException ex) {
        ExceptionListener listener = this.mSessionProps.getConnectionProperties().getExceptionListener();
        log.debug((Object)String.format("%s Delivering exception to connection exception listener (%s): %s", this.toString(), listener, ex.toString()));
        if (listener != null) {
            listener.onException(ex);
        }
    }

    public void handleErrorEx(Object key, JCSMPException cause, long timestamp) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering handleErrorEx().  Message: " + cause.getMessage()));
        }
        if (key == null && cause instanceof JCSMPTransportException) {
            this.cancel(cause);
            this.deliverException(Validator.createJMSException("soljms.operation.send", (Throwable)((Object)cause)));
        } else if (key != null) {
            SendResult sendResult = (SendResult)key;
            try {
                sendResult.fail(cause);
            }
            catch (InterruptedException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"error puting on response queue", (Throwable)e);
                }
            }
        } else {
            this.deliverException(Validator.createJMSException("soljms.operation.send", (Throwable)((Object)cause)));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving handleErrorEx()");
        }
    }

    public void handleError(String messageID, JCSMPException cause, long timestamp) {
    }

    public void responseReceivedEx(Object key) {
        block3: {
            if (key != null) {
                SendResult sendResult = (SendResult)key;
                try {
                    sendResult.succeed();
                }
                catch (InterruptedException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"error puting on response queue", (Throwable)e);
                }
            }
        }
    }

    public void responseReceived(String messageID) {
    }

    public void handleEvent(ProducerEventArgs event) {
        if (this.mEventHandler != null) {
            if (event.getEvent() == ProducerEvent.REPUBLISH_UNACKED_MESSAGES) {
                SolRepublishUnackedMessageEvent jmsEvent = new SolRepublishUnackedMessageEvent(new JMSException(event.getInfo(), "soljms.operation.send"), (Integer)event.getEventObject());
                this.mEventHandler.onEvent(jmsEvent);
            } else if (log.isInfoEnabled()) {
                log.info((Object)("Unsupported JCSMP event(" + (Object)((Object)event.getEvent()) + "):" + event.getInfo()));
            }
        }
    }
}

