/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.flow;

import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.ConsumerFlowProperties;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.FlowEvent;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFatalErrorException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.NonDurableTopicEndpointImpl;
import com.solacesystems.jcsmp.impl.flow.FlowEventArgsImpl;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.flow.FlowTask;
import com.solacesystems.jcsmp.impl.flow.TaskSessionRefs;
import com.solacesystems.jcsmp.impl.transaction.BaseTransactedSessionImpl;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BindRequestTask
extends FlowTask {
    private static final Log Trace = LogFactory.getLog(BindRequestTask.class);
    volatile FlowHandleImpl thisOldFlowHandle = null;
    XMLMessageListener listener;
    FlowHandleImpl existingFlowHandle;
    private Topic newTopic;
    private AssuredCtrlEnums.FlowType flowType;
    private EndpointProperties tmpEpCreateProperties;
    private String sqlSelector;
    private ConsumerFlowProperties consumerFlowProps;
    private final JCSMPBasicSession.InternalBindProperties internalBindProp;
    private final FlowEventHandler flowEventHandler;
    private static int counter = 0;
    private int _counter = counter++;

    public BindRequestTask(TaskSessionRefs t_refs, ConsumerFlowProperties f_prop, EndpointProperties e_prop, XMLMessageListener listener, FlowHandleImpl existingFlowHandle, AssuredCtrlEnums.FlowType flowType, JCSMPBasicSession.InternalBindProperties internalBindProp, FlowEventHandler flowEventHandler) {
        super(f_prop.getEndpoint(), t_refs);
        this.consumerFlowProps = f_prop;
        this.newTopic = (Topic)f_prop.getNewSubscription();
        this.listener = listener;
        this.existingFlowHandle = existingFlowHandle;
        this.flowType = flowType;
        this.sqlSelector = f_prop.getSelector();
        this.tmpEpCreateProperties = e_prop;
        this.internalBindProp = internalBindProp;
        this.flowEventHandler = flowEventHandler;
    }

    public String toString() {
        return String.format("[BRT resource=%s existingFH=%s flowType=%s counter=%s]", new Object[]{this.bindToResource, this.existingFlowHandle, this.flowType, this._counter});
    }

    public boolean submit(int corrTag, boolean allowOnStateSub, TcpChannel.WriteBlockPolicy wpolicy) throws JCSMPException {
        TcpClientChannel tcpChannel = this.taskRefs.getChannel();
        this.initTimerFlag();
        String flowName = null;
        long lastAcked = 0L;
        long lastRecved = 0L;
        if (this.existingFlowHandle != null) {
            flowName = this.existingFlowHandle.getFlowName();
            lastAcked = this.existingFlowHandle.getLastInOrderTpMsg();
            lastRecved = this.existingFlowHandle.getLastInOrderTpMsg();
        }
        Long transactedSessionId = null;
        if (this.internalBindProp != null && this.internalBindProp.transactedSession != null) {
            transactedSessionId = this.internalBindProp.transactedSession.getTransactedSessionId();
        }
        tcpChannel.sendBindRequest(this.bindToResource, this.newTopic, 0, corrTag, allowOnStateSub, flowName, this.flowType, lastAcked, lastRecved, this.sqlSelector, this.tmpEpCreateProperties, transactedSessionId, this.consumerFlowProps.isNoLocal(), this.consumerFlowProps.isActiveFlowIndication(), wpolicy);
        this.startTimer();
        return true;
    }

    public Object execute(Object obj) {
        Trace.debug((Object)"Executing response handler.");
        this.cancelTimer();
        assert (obj instanceof WireMessage);
        boolean isRebind = this.existingFlowHandle != null;
        WireMessage respMsg = (WireMessage)obj;
        SMFHeaderBean smfHeader = respMsg.getSmfHeader();
        assert (smfHeader.getProtocol() == 9);
        if (smfHeader.getPm_respcode() == 507 && smfHeader.getPm_respstr().equalsIgnoreCase("ASSURED DELIVERY NOT READY")) {
            Trace.debug((Object)("Got bind response: AD not ready in task " + this.toString()));
            String networkInfoString = new String();
            if (this.subFlowMgr != null && this.subFlowMgr.subChannel != null) {
                networkInfoString = this.subFlowMgr.subChannel.getNetworkInfoString();
            }
            JCSMPErrorResponseException retryableCause = new JCSMPErrorResponseException(smfHeader.getPm_respcode(), smfHeader.getPm_respstr(), "", networkInfoString, JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            this.scheduleResubmit(retryableCause);
            return null;
        }
        if (smfHeader.getPm_respcode() != 200) {
            String networkInfoString = new String();
            if (this.subFlowMgr != null && this.subFlowMgr.subChannel != null) {
                networkInfoString = this.subFlowMgr.subChannel.getNetworkInfoString();
            }
            this.opEx = new JCSMPErrorResponseException(smfHeader.getPm_respcode(), smfHeader.getPm_respstr(), "", networkInfoString, JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            if (Trace.isInfoEnabled()) {
                Trace.info((Object)("Error Response (" + smfHeader.getPm_respcode() + ") - " + smfHeader.getPm_respstr()));
            }
            Trace.debug((Object)"Got bind exception. ", (Throwable)((Object)this.opEx));
        } else {
            AssuredCtrlHeaderBean assBean = (AssuredCtrlHeaderBean)respMsg.getHeaderBean();
            SmfTLVParameter tlv = (SmfTLVParameter)assBean.findFirstParameter(6);
            long respFlowId = TlvParameterParser.getAssuredFlowId(tlv);
            long respEndpointId = 0L;
            tlv = (SmfTLVParameter)assBean.findFirstParameter(44);
            if (tlv != null) {
                respEndpointId = TlvParameterParser.getEndpointId(tlv);
            }
            String respFlowName = null;
            tlv = (SmfTLVParameter)assBean.findFirstParameter(10);
            if (tlv != null) {
                respFlowName = TlvParameterParser.getAssuredFlowName(tlv);
            }
            boolean explicitlyActive = false;
            tlv = (SmfTLVParameter)assBean.findFirstParameter(32);
            if (tlv != null) {
                explicitlyActive = TlvParameterParser.getAssuredActiveFlowIndication(tlv);
            }
            AssuredCtrlEnums.QueueAccessType qat = null;
            tlv = (SmfTLVParameter)assBean.findFirstParameter(12);
            if (tlv != null) {
                qat = TlvParameterParser.getAssuredQueueAccessType(tlv);
            } else if (this.bindToResource instanceof Queue) {
                qat = AssuredCtrlEnums.QueueAccessType.EXCLUSIVE;
            }
            tlv = (SmfTLVParameter)assBean.findFirstParameter(8);
            if (this.bindToResource instanceof NonDurableTopicEndpointImpl && tlv != null) {
                String te_name = TlvCoderUtil.nullTermUtf8ToString(tlv.value);
                NonDurableTopicEndpointImpl ndte = (NonDurableTopicEndpointImpl)this.bindToResource;
                ndte.setName(te_name);
            }
            boolean isCapablePermission = this.taskRefs.getSession().isCapable(CapabilityType.ENDPOINT_MANAGEMENT);
            Long granted_perm = null;
            tlv = (SmfTLVParameter)assBean.findFirstParameter(21);
            if (tlv != null && isCapablePermission) {
                long perm_smf_val = NetworkByteOrderNumberUtil.fourByteToUInt(tlv.value);
                long perm_sdk_val = AssuredCtrlEnums.permBitfieldToSdkPermission(perm_smf_val);
                granted_perm = perm_sdk_val;
            }
            if (!isRebind) {
                BaseTransactedSessionImpl old_ts = this.internalBindProp == null ? null : this.internalBindProp.transactedSession;
                this.thisOldFlowHandle = new FlowHandleImpl(this.bindToResource, this.newTopic, this.listener, this.taskRefs.getChannel(), this.taskRefs.getSession(), true, qat, this.flowType, granted_perm, this.tmpEpCreateProperties, this.sqlSelector, this.consumerFlowProps, old_ts, this.flowEventHandler);
                if (this.newTopic != null) {
                    this.thisOldFlowHandle.setSubscription(this.newTopic);
                }
            } else {
                this.thisOldFlowHandle = this.existingFlowHandle;
            }
            this.thisOldFlowHandle.setFlowId(respFlowId);
            this.thisOldFlowHandle.setEndpointId(respEndpointId);
            this.thisOldFlowHandle.setFlowName(respFlowName);
            this.thisOldFlowHandle.explictlyActive = explicitlyActive;
            this.thisOldFlowHandle.setBoundToResourceState(FlowHandleImpl.ResourceBoundState.BOUND);
            Trace.debug((Object)String.format("Got OK bindresponse, flowId=%s, QueueAccessType=%s, explicitlyActive=%s", new Object[]{respFlowId, qat, explicitlyActive}));
            if (explicitlyActive && this.thisOldFlowHandle.getFlowEventHandler() != null) {
                Trace.debug((Object)("Send out flow active event after bind, flowId=" + respFlowId));
                this.thisOldFlowHandle.notifyFlowEventHandler(new FlowEventArgsImpl(FlowEvent.FLOW_ACTIVE, "Flow becomes active", null, 0));
            }
        }
        this.responseLatch.countDown();
        if (this.opEx != null && isRebind) {
            this.existingFlowHandle.handleException(this.opEx);
        }
        return null;
    }

    public void handleTimeout() {
        boolean isRebind;
        super.handleTimeout();
        boolean bl = isRebind = this.existingFlowHandle != null;
        if (isRebind) {
            JCSMPTransportException timeout_ex = new JCSMPTransportException(JCSMPRB.BUNDLE.getStringSafely("TcpSubscriberChannel.timeoutReadingResponseToAdctrl") + " (" + this.toString() + ")");
            this.cancel(timeout_ex);
        }
    }

    public FlowHandleImpl getFlowHandler() throws JCSMPException {
        block3: {
            try {
                this.responseLatch.await();
            }
            catch (InterruptedException e) {
                if (this.opEx != null) break block3;
                this.opEx = new JCSMPFatalErrorException("Interrupted.", e);
            }
        }
        if (this.opEx != null) {
            throw this.opEx;
        }
        return this.thisOldFlowHandle;
    }
}

