/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import com.solacesystems.common.util.AbstractCipherTool;
import com.solacesystems.common.util.Base64;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;

public class ApplicationCipherTool
extends AbstractCipherTool {
    private static final byte[] default_sk = new byte[]{27, 82, 99, -9, -42, 104, 76, 79, -26, 122, -66, 88, 61, 81, 102, -23};
    private static final byte[] default_ek = new byte[]{-106, 92, -44, 101, 126, 121, 59, -48, 94, -40, 77, -77, -48, 121, 60, 31, 38, 95, -83, -9, 106, 108, -12, -80, -68, -56, 0, 106, 114, 56, 50, -66};
    private final byte[] ek;

    public ApplicationCipherTool() throws GeneralSecurityException {
        this(default_sk, default_ek);
    }

    public ApplicationCipherTool(byte[] sk, byte[] ek) throws GeneralSecurityException {
        super(sk);
        this.ek = ek;
    }

    byte[] getEk() {
        return this.ek;
    }

    public String get_property(String someString) {
        if (someString == null) {
            throw new IllegalArgumentException("Please provide a non null input");
        }
        try {
            return new String(this.decrypt(Base64.decode(someString)), Charset.forName("UTF-8"));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Sorry I was unable to decrypt", e);
        }
    }

    public String set_property(String someString) {
        if (someString == null) {
            throw new IllegalArgumentException("Please provide a non null input");
        }
        try {
            String encoding = Base64.getPreferredEncoding();
            return Base64.encodeBytes(this.encrypt(someString.getBytes(encoding)));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Sorry I was unable to encrypt", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Sorry I was unable to encrypt", e);
        }
    }
}

