/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction;

import com.solacesystems.jcsmp.ClosedFacilityException;
import com.solacesystems.jcsmp.InvalidMessageReceivedException;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.StaleSessionException;
import com.solacesystems.jcsmp.impl.Closeable;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.transaction.BaseTransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionImpl;
import com.solacesystems.jcsmp.protocol.impl.WriteDroppedException;
import com.solacesystems.jcsmp.protocol.smf.AbstractTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderParameters;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterParser;
import com.solacesystems.jcsmp.transaction.RollbackException;
import com.solacesystems.jcsmp.transaction.TransactionResultUnknownException;
import com.solacesystems.jcsmp.transaction.TransactionStatus;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TSState {
    private static final Log Trace = LogFactory.getLog(TSState.class);
    private static final String STR_ADCTRL_REQ_TIMEOUT = "TransactedSession assuredctrl request timed out.";
    protected final TransactedSessionImpl tsession;
    private static final int REQUEST_ATTEMPT_MAX = 5;
    protected int request_post_count = 0;

    public TSState(TransactedSessionImpl parentSession) {
        this.tsession = parentSession;
    }

    public TSStorage getStateCache() {
        return this.tsession.sessionStateStorage;
    }

    protected abstract TransactionStatus getStatusEnum();

    protected void notifyBound(AssuredCtrlEnums.TransactedSessionState routerState, AssuredCtrlHeaderParameters.ParamTransactionId routerTid) throws JCSMPException {
    }

    protected void notifyFlowRebindFinished() throws JCSMPException {
    }

    protected void notifyRetransmitsComplete() {
    }

    protected void enter() throws JCSMPException {
    }

    protected void setState(TSState next) throws JCSMPException {
        this.tsession.switchStateIfNotIn(next);
    }

    protected AssuredCtrlHeaderParameters.ParamTransactionId getTransactionId() {
        return this.tsession.transactionIds.getCurrentAndNext();
    }

    protected void handleAsyncAdCtrl(AssuredCtrlEnums.TransactionCtrlMessageType mtype, AssuredCtrlHeaderBean adctrl, JCSMPErrorResponseException err_resp) {
    }

    protected void handleResponseTimeout() {
    }

    public void allowOperation(BaseTransactedSessionImpl.AllowedOperation op) throws InvalidOperationException {
        this.throwDisallowedOp(op);
    }

    protected void throwDisallowedOp(BaseTransactedSessionImpl.AllowedOperation op) throws InvalidOperationException {
        throw new InvalidOperationException(String.format("Operation %s disallowed in state %s.", new Object[]{op, this.getStatusEnum()}));
    }

    public void doCommit() throws JCSMPException {
        throw new InvalidOperationException(String.format("Invalid call to commit in state '%s'.", new Object[]{this.getStatusEnum()}));
    }

    public void doRollback() throws JCSMPException {
        throw new InvalidOperationException(String.format("Invalid call to rollback in state '%s'.", new Object[]{this.getStatusEnum()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ackEverythingSent() {
        try {
            Set<JCSMPXMLMessageProducer> set = this.tsession.outputFlows;
            synchronized (set) {
                for (JCSMPXMLMessageProducer prodflow : this.tsession.outputFlows) {
                    long last_sent = prodflow.getPubADManager().lastMessageIdSent;
                    prodflow.handleAckAD(last_sent, null);
                }
            }
        }
        catch (JCSMPException e) {
            this.tsession.handleUnrecoverableException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePubAcks(AssuredCtrlHeaderParameters.ParamTransactionFDPubAck param_pubacks, JCSMPErrorResponseException err) {
        try {
            for (AssuredCtrlHeaderParameters.ParamTransactionFDPubAck.PubAckTuple pubAck : param_pubacks.getTuples()) {
                Set<JCSMPXMLMessageProducer> set = this.tsession.outputFlows;
                synchronized (set) {
                    for (JCSMPXMLMessageProducer prodflow : this.tsession.outputFlows) {
                        if (prodflow.getPubADManager().flow_Id != (long)pubAck.flowId) continue;
                        prodflow.handleCommitResponse(pubAck.lastMessageId, err);
                        break;
                    }
                }
            }
            return;
        }
        catch (JCSMPException e) {
            this.tsession.handleUnrecoverableException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackFlows() {
        LinkedHashSet<FlowHandleImpl> toRollback = null;
        Set<FlowHandleImpl> set = this.tsession.inputFlows;
        synchronized (set) {
            toRollback = new LinkedHashSet<FlowHandleImpl>(this.tsession.inputFlows);
        }
        for (FlowHandleImpl fh : toRollback) {
            fh.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRollbackOkResp(AssuredCtrlHeaderParameters.ParamTransactionFDPubAck param_pubacks) {
        for (AssuredCtrlHeaderParameters.ParamTransactionFDPubAck.PubAckTuple pubAck : param_pubacks.getTuples()) {
            Set<JCSMPXMLMessageProducer> set = this.tsession.outputFlows;
            synchronized (set) {
                for (JCSMPXMLMessageProducer prodflow : this.tsession.outputFlows) {
                    if (prodflow.getPubADManager().flow_Id != (long)pubAck.flowId) continue;
                    prodflow.getPubADManager().handleRollback(pubAck.lastMessageId);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackFlowControl() {
        LinkedHashSet<FlowHandleImpl> toRollback = null;
        Set<FlowHandleImpl> set = this.tsession.inputFlows;
        synchronized (set) {
            toRollback = new LinkedHashSet<FlowHandleImpl>(this.tsession.inputFlows);
        }
        for (FlowHandleImpl fh : toRollback) {
            fh.openWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postCommit() {
        LinkedHashSet<FlowHandleImpl> flows = null;
        Set<FlowHandleImpl> set = this.tsession.inputFlows;
        synchronized (set) {
            flows = new LinkedHashSet<FlowHandleImpl>(this.tsession.inputFlows);
        }
        for (FlowHandleImpl fh : flows) {
            fh.handleUnackedMsgSegments();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFlowControl() {
        HashSet<FlowHandleImpl> toRollback = null;
        Set<FlowHandleImpl> set = this.tsession.inputFlows;
        synchronized (set) {
            toRollback = new HashSet<FlowHandleImpl>(this.tsession.inputFlows);
        }
        for (FlowHandleImpl fh : toRollback) {
            fh.closeWindow();
        }
    }

    protected void checkMaxPostTries() throws JCSMPException {
        if (this.tsession.cur_post_tries > this.tsession.max_post_tries) {
            JCSMPTransportException err = new JCSMPTransportException(String.format("Transacted Session exceeded maximum configured request attempts (%s) in state %s.", new Object[]{this.tsession.max_post_tries, this.getStatusEnum()}));
            throw err;
        }
    }

    public static class StateCommitRollingBack
    extends TSState {
        public StateCommitRollingBack(TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        protected void enter() throws JCSMPException {
            try {
                this.tsession.retransmission.waitCompletion();
            }
            catch (InterruptedException e1) {
                this.rollbackFlows();
                this.closeFlowControl();
                JCSMPInterruptedException ex = new JCSMPInterruptedException("Interrupted", e1);
                this.tsession.handleInterruptedException(ex);
                throw ex;
            }
            try {
                this.rollbackFlows();
                this.closeFlowControl();
                this.tsession.responseTimerSetter.enableStartTimer();
                int loop = 1;
                while (!this.tsession.reconnectInProgress()) {
                    try {
                        this.tsession.sendRollbackRequest(true, this.tsession.getConnTag());
                        break;
                    }
                    catch (WriteDroppedException e1) {
                        if (loop++ > 5) {
                            throw e1;
                        }
                        Random random = new Random();
                        int millis = random.nextInt(100) + loop * 50;
                        try {
                            Thread.sleep(millis);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (JCSMPException e1) {
                        throw e1;
                    }
                }
                this.tsession.responseTimerSetter.startTimer();
            }
            catch (JCSMPInterruptedException e) {
                this.tsession.handleInterruptedException(e);
                throw e;
            }
            catch (JCSMPTransportException e) {
                if (e instanceof WriteDroppedException) {
                    Trace.debug((Object)String.format("%s commit rollback not sent on unavailable socket, will retry after reconnect.", this.tsession));
                } else {
                    this.tsession.handleTransportException(e);
                }
            }
            catch (JCSMPException e) {
                this.tsession.handleUnrecoverableException(e);
            }
        }

        protected void handleResponseTimeout() {
            super.handleResponseTimeout();
            JCSMPTransportException exTimeout = new JCSMPTransportException(TSState.STR_ADCTRL_REQ_TIMEOUT);
            this.tsession.handleTransportException(exTimeout);
        }

        private void refireRequest() throws JCSMPException {
            ++this.tsession.cur_post_tries;
            try {
                this.checkMaxPostTries();
            }
            catch (JCSMPException err) {
                this.tsession.handleUnrecoverableException(err);
                return;
            }
            this.rollbackFlows();
            Integer currConnTag = this.tsession._parentSessionMgr.subChannel.getConnCounterTag();
            Integer reqConnTag = this.tsession.getConnTag();
            if (reqConnTag == null || !reqConnTag.equals(currConnTag)) {
                this.tsession.responseTimerSetter.enableStartTimer();
                this.tsession.sendRollbackRequest(false, currConnTag);
                this.tsession.responseTimerSetter.startTimer();
            }
            this.rollbackFlowControl();
        }

        protected void notifyFlowRebindFinished() throws JCSMPException {
            super.notifyFlowRebindFinished();
            boolean isRetransmitting = this.tsession.startAdRetransmission();
            if (!isRetransmitting) {
                this.refireRequest();
            }
        }

        protected void notifyRetransmitsComplete() {
            super.notifyRetransmitsComplete();
            try {
                this.refireRequest();
            }
            catch (JCSMPTransportException e) {
                this.tsession.handleTransportException(e);
            }
            catch (JCSMPException e) {
                this.tsession.handleUnrecoverableException(e);
            }
        }

        protected void handleAsyncAdCtrl(AssuredCtrlEnums.TransactionCtrlMessageType mtype, AssuredCtrlHeaderBean adctrl, JCSMPErrorResponseException err_resp) {
            SmfTLVParameter param;
            if (mtype != AssuredCtrlEnums.TransactionCtrlMessageType.ROLLBACK_TRANSACTION) {
                Trace.info((Object)("Ignoring invalid AssuredCtrl message in state " + String.valueOf((Object)this.getStatusEnum())));
                return;
            }
            if (err_resp != null && err_resp.getSubcodeEx() == 52) {
                Trace.info((Object)"(OK) INVALID_TRANSACTION_ID, Rollback operation skipped due to loss of sync during reconnect; continuing.");
                err_resp = null;
            }
            if ((param = (SmfTLVParameter)adctrl.findFirstParameter(26)) == null) {
                Trace.warn((Object)"Invalid AssuredCtrl rollback response, no TransactionId.");
                return;
            }
            AssuredCtrlHeaderParameters.ParamTransactionId txid = TlvParameterParser.getAssuredTransactionId(param);
            this.rollbackFlows();
            this.tsession.responseTimerSetter.stopTimer();
            AbstractTLVParameter pub_ack_param = adctrl.findFirstParameter(29);
            if (pub_ack_param != null) {
                AssuredCtrlHeaderParameters.ParamTransactionFDPubAck pubackParam = AssuredCtrlHeaderParameters.ParamTransactionFDPubAck.fromValueBytes(pub_ack_param.value, 0, pub_ack_param.value.length);
                this.handleRollbackOkResp(pubackParam);
            }
            this.tsession.setTransactionID(txid.b);
            JCSMPErrorResponseSubcodeMapper.ESTR eStr = JCSMPErrorResponseSubcodeMapper.ESTR.ER_FLOW_UNBOUND;
            JCSMPErrorResponseException err_resp1 = new JCSMPErrorResponseException(900, eStr.getS(), eStr.getS(), "", JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            try {
                this.setState(this.tsession.sessionStateStorage.STATE_ACTIVE);
            }
            catch (JCSMPException e) {
                Trace.debug((Object)("got exception: " + e.getMessage()));
            }
            String err_rollback = String.format("Transaction '%s' unexpectedly rolled back due to UNBOUND transacted consumer flows", txid.a);
            this.tsession.responseQueue.add((Object)new RollbackException(err_rollback, (Throwable)((Object)err_resp1)));
            this.rollbackFlowControl();
        }

        protected void notifyBound(AssuredCtrlEnums.TransactedSessionState routerState, AssuredCtrlHeaderParameters.ParamTransactionId routerTid) throws JCSMPException {
            super.notifyBound(routerState, routerTid);
            long tid_rtr_last = routerTid.a;
            long tid_rtr_in_progress = routerTid.b;
            long tid_local_in_progress = this.tsession.getTransactionId().a;
            boolean isContinuation = tid_rtr_in_progress == tid_local_in_progress;
            String err_rollback = null;
            if (Trace.isInfoEnabled()) {
                Trace.info((Object)String.format("%s notifyBound in state COMMIT_ROLLINGBACK, local_in_progress=%s, router_in_progress=%s, router_session_status=%s", new Object[]{this.tsession, tid_local_in_progress, tid_rtr_in_progress, routerState}));
            }
            if (!isContinuation) {
                this.tsession.setTransactionID(tid_rtr_in_progress);
                switch (routerState) {
                    case ROLLEDBACK: 
                    case NEW: {
                        this.rollbackFlows();
                        this.setState(this.tsession.sessionStateStorage.STATE_ACTIVE);
                        err_rollback = String.format("Transaction '%s' unexpectedly rolled back due to UNBOUND transacted consumer flows.", tid_local_in_progress);
                        this.tsession.responseQueue.add((Object)new RollbackException(err_rollback));
                        break;
                    }
                    default: {
                        this.tsession.handleUnrecoverableException(new InvalidOperationException("Lost transaction sync in ROLLINGBACK: router state should not be " + routerState.toString()));
                    }
                }
            }
        }

        public TransactionStatus getStatusEnum() {
            return TransactionStatus.COMMIT_ROLLING_BACK;
        }
    }

    public static class StateMarkedRollback
    extends TSState {
        public StateMarkedRollback(TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        protected void enter() throws JCSMPException {
            super.enter();
            this.rollbackFlows();
        }

        public TransactionStatus getStatusEnum() {
            return TransactionStatus.MARKED_ROLLBACK;
        }

        public void allowOperation(BaseTransactedSessionImpl.AllowedOperation op) throws InvalidOperationException {
            this.getStateCache().STATE_ACTIVE.allowOperation(op);
        }

        public void doCommit() throws JCSMPException {
            this.getStateCache().STATE_ACTIVE.doCommit();
        }

        public void doRollback() throws JCSMPException {
            this.getStateCache().STATE_ACTIVE.doRollback();
        }

        protected void notifyBound(AssuredCtrlEnums.TransactedSessionState routerState, AssuredCtrlHeaderParameters.ParamTransactionId routerTid) throws JCSMPException {
            this.getStateCache().STATE_ACTIVE.notifyBound(routerState, routerTid);
        }
    }

    public static class StateRollingBack
    extends TSState {
        public StateRollingBack(TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        protected void enter() throws JCSMPException {
            try {
                this.tsession.retransmission.waitCompletion();
            }
            catch (InterruptedException e1) {
                JCSMPInterruptedException ex = new JCSMPInterruptedException("Interrupted", e1);
                this.rollbackFlows();
                this.closeFlowControl();
                this.tsession.handleInterruptedException(ex);
                throw ex;
            }
            try {
                this.rollbackFlows();
                this.closeFlowControl();
                this.tsession.responseTimerSetter.enableStartTimer();
                int loop = 1;
                while (!this.tsession.reconnectInProgress()) {
                    try {
                        this.tsession.sendRollbackRequest(true, this.tsession.getConnTag());
                        break;
                    }
                    catch (WriteDroppedException e1) {
                        if (loop++ > 5) {
                            throw e1;
                        }
                        Random random = new Random();
                        int millis = random.nextInt(100) + loop * 50;
                        try {
                            Thread.sleep(millis);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (JCSMPException e1) {
                        throw e1;
                    }
                }
                this.tsession.responseTimerSetter.startTimer();
            }
            catch (JCSMPInterruptedException e) {
                this.tsession.handleInterruptedException(e);
                throw e;
            }
            catch (JCSMPTransportException e) {
                if (e instanceof WriteDroppedException) {
                    Trace.debug((Object)String.format("%s rollback not sent on unavailable socket, will retry after reconnect.", this.tsession));
                } else {
                    this.tsession.handleTransportException(e);
                }
            }
            catch (JCSMPException e) {
                this.tsession.handleUnrecoverableException(e);
            }
        }

        protected void handleResponseTimeout() {
            super.handleResponseTimeout();
            JCSMPTransportException exTimeout = new JCSMPTransportException(TSState.STR_ADCTRL_REQ_TIMEOUT);
            this.tsession.handleTransportException(exTimeout);
        }

        private void refireRequest() throws JCSMPException {
            ++this.tsession.cur_post_tries;
            try {
                this.checkMaxPostTries();
            }
            catch (JCSMPException err) {
                this.tsession.handleUnrecoverableException(err);
                return;
            }
            this.rollbackFlows();
            Integer currConnTag = this.tsession._parentSessionMgr.subChannel.getConnCounterTag();
            Integer reqConnTag = this.tsession.getConnTag();
            if (reqConnTag == null || !reqConnTag.equals(currConnTag)) {
                this.tsession.responseTimerSetter.enableStartTimer();
                this.tsession.sendRollbackRequest(false, currConnTag);
                this.tsession.responseTimerSetter.startTimer();
            }
            this.rollbackFlowControl();
        }

        protected void notifyFlowRebindFinished() throws JCSMPException {
            super.notifyFlowRebindFinished();
            boolean isRetransmitting = this.tsession.startAdRetransmission();
            if (!isRetransmitting) {
                this.refireRequest();
            }
        }

        protected void notifyRetransmitsComplete() {
            super.notifyRetransmitsComplete();
            try {
                this.refireRequest();
            }
            catch (JCSMPTransportException e) {
                this.tsession.handleTransportException(e);
            }
            catch (JCSMPException e) {
                this.tsession.handleUnrecoverableException(e);
            }
        }

        protected void handleAsyncAdCtrl(AssuredCtrlEnums.TransactionCtrlMessageType mtype, AssuredCtrlHeaderBean adctrl, JCSMPErrorResponseException err_resp) {
            SmfTLVParameter param;
            if (mtype != AssuredCtrlEnums.TransactionCtrlMessageType.ROLLBACK_TRANSACTION) {
                Trace.info((Object)("Ignoring invalid AssuredCtrl message in state " + String.valueOf((Object)this.getStatusEnum())));
                return;
            }
            if (err_resp != null && err_resp.getSubcodeEx() == 52) {
                Trace.info((Object)"(OK) INVALID_TRANSACTION_ID, Rollback operation skipped due to loss of sync during reconnect; continuing.");
                err_resp = null;
            }
            if ((param = (SmfTLVParameter)adctrl.findFirstParameter(26)) == null) {
                Trace.warn((Object)"Invalid AssuredCtrl rollback response, no TransactionId.");
                return;
            }
            AssuredCtrlHeaderParameters.ParamTransactionId txid = TlvParameterParser.getAssuredTransactionId(param);
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)String.format("%s Transaction roolback, new TID:%s", this.tsession, txid.b));
            }
            this.rollbackFlows();
            this.tsession.responseTimerSetter.stopTimer();
            AbstractTLVParameter pub_ack_param = adctrl.findFirstParameter(29);
            if (pub_ack_param != null) {
                AssuredCtrlHeaderParameters.ParamTransactionFDPubAck pubackParam = AssuredCtrlHeaderParameters.ParamTransactionFDPubAck.fromValueBytes(pub_ack_param.value, 0, pub_ack_param.value.length);
                this.handleRollbackOkResp(pubackParam);
            }
            this.tsession.setTransactionID(txid.b);
            try {
                this.setState(this.tsession.sessionStateStorage.STATE_ACTIVE);
            }
            catch (JCSMPException e) {
                Trace.debug((Object)("got exception: " + e.getMessage()));
            }
            if (err_resp == null) {
                this.tsession.responseQueue.add(txid);
            } else {
                this.tsession.responseQueue.add((Object)err_resp);
            }
            this.rollbackFlowControl();
        }

        protected void notifyBound(AssuredCtrlEnums.TransactedSessionState routerState, AssuredCtrlHeaderParameters.ParamTransactionId routerTid) throws JCSMPException {
            boolean isContinuation;
            super.notifyBound(routerState, routerTid);
            long tid_rtr_last = routerTid.a;
            long tid_rtr_in_progress = routerTid.b;
            long tid_local_in_progress = this.tsession.getTransactionId().a;
            boolean bl = isContinuation = tid_rtr_in_progress == tid_local_in_progress;
            if (Trace.isInfoEnabled()) {
                Trace.info((Object)String.format("%s notifyBound in state ROLLINGBACK, local_in_progress=%s, router_in_progress=%s, router_session_status=%s", new Object[]{this.tsession, tid_local_in_progress, tid_rtr_in_progress, routerState}));
            }
            if (!isContinuation) {
                this.tsession.setTransactionID(tid_rtr_in_progress);
                switch (routerState) {
                    case ROLLEDBACK: 
                    case NEW: {
                        this.rollbackFlows();
                        this.setState(this.tsession.sessionStateStorage.STATE_ACTIVE);
                        this.tsession.responseQueue.add(routerTid);
                        break;
                    }
                    default: {
                        this.tsession.handleUnrecoverableException(new InvalidOperationException("Lost transaction sync in ROLLINGBACK: router state should not be " + routerState.toString()));
                    }
                }
            }
        }

        public TransactionStatus getStatusEnum() {
            return TransactionStatus.ROLLING_BACK;
        }
    }

    public static class StateCommitting
    extends TSState {
        public StateCommitting(TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        public TransactionStatus getStatusEnum() {
            return TransactionStatus.COMMITTING;
        }

        protected void enter() throws JCSMPException {
            try {
                this.tsession.retransmission.waitCompletion();
            }
            catch (InterruptedException e1) {
                JCSMPInterruptedException ex = new JCSMPInterruptedException("Interrupted", e1);
                this.tsession.handleInterruptedException(ex);
                throw ex;
            }
            try {
                this.tsession.responseTimerSetter.enableStartTimer();
                int loop = 1;
                while (!this.tsession.reconnectInProgress()) {
                    try {
                        this.tsession.sendCommitRequest(true, this.tsession.getConnTag());
                        break;
                    }
                    catch (WriteDroppedException e1) {
                        if (loop++ > 5) {
                            throw e1;
                        }
                        Random random = new Random();
                        int millis = random.nextInt(100) + loop * 50;
                        try {
                            Thread.sleep(millis);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (JCSMPException e1) {
                        throw e1;
                    }
                }
                this.tsession.responseTimerSetter.startTimer();
            }
            catch (JCSMPInterruptedException e) {
                this.tsession.handleInterruptedException(e);
                throw e;
            }
            catch (JCSMPTransportException e) {
                if (e instanceof WriteDroppedException) {
                    Trace.debug((Object)String.format("%s commit not sent on unavailable socket, will retry after reconnect.", this.tsession));
                } else {
                    this.tsession.handleTransportException(e);
                }
            }
            catch (JCSMPException e) {
                this.tsession.handleUnrecoverableException(e);
            }
        }

        private void refireRequest() throws JCSMPException {
            ++this.tsession.cur_post_tries;
            try {
                this.checkMaxPostTries();
            }
            catch (JCSMPException err) {
                this.tsession.handleUnrecoverableException(err);
                return;
            }
            Integer currConnTag = this.tsession._parentSessionMgr.subChannel.getConnCounterTag();
            Integer reqConnTag = this.tsession.getConnTag();
            if (reqConnTag == null || !reqConnTag.equals(currConnTag)) {
                this.tsession.responseTimerSetter.enableStartTimer();
                this.tsession.sendCommitRequest(false, currConnTag);
                this.tsession.responseTimerSetter.startTimer();
            }
        }

        protected void notifyFlowRebindFinished() throws JCSMPException {
            if (this.tsession.hasUnboundSubFlows()) {
                this.setState(this.tsession.sessionStateStorage.STATE_COMMIT_ROLLINGBACK);
                this.tsession.sessionState.notifyFlowRebindFinished();
            } else {
                super.notifyFlowRebindFinished();
                boolean isRetransmitting = this.tsession.startAdRetransmission();
                if (!isRetransmitting) {
                    this.refireRequest();
                }
            }
        }

        protected void notifyRetransmitsComplete() {
            super.notifyRetransmitsComplete();
            try {
                this.refireRequest();
            }
            catch (JCSMPTransportException e) {
                this.tsession.handleTransportException(e);
            }
            catch (JCSMPException e) {
                this.tsession.handleUnrecoverableException(e);
            }
        }

        protected void handleResponseTimeout() {
            super.handleResponseTimeout();
            JCSMPTransportException exTimeout = new JCSMPTransportException(TSState.STR_ADCTRL_REQ_TIMEOUT);
            this.tsession.handleTransportException(exTimeout);
        }

        protected void handleAsyncAdCtrl(AssuredCtrlEnums.TransactionCtrlMessageType mtype, AssuredCtrlHeaderBean adctrl, JCSMPErrorResponseException err_resp) {
            if (mtype != AssuredCtrlEnums.TransactionCtrlMessageType.COMMIT_TRANSACTION && mtype != AssuredCtrlEnums.TransactionCtrlMessageType.ROLLBACK_TRANSACTION) {
                Trace.info((Object)("Ignoring invalid AssuredCtrl message in state " + String.valueOf((Object)this.getStatusEnum())));
                return;
            }
            SmfTLVParameter param = (SmfTLVParameter)adctrl.findFirstParameter(26);
            if (param == null) {
                Trace.warn((Object)"Invalid AssuredCtrl commit response, no TransactionId.");
                return;
            }
            AssuredCtrlHeaderParameters.ParamTransactionId txid = TlvParameterParser.getAssuredTransactionId(param);
            this.tsession.responseTimerSetter.stopTimer();
            AbstractTLVParameter pub_ack_param = adctrl.findFirstParameter(29);
            if (pub_ack_param != null) {
                AssuredCtrlHeaderParameters.ParamTransactionFDPubAck pubackParam = AssuredCtrlHeaderParameters.ParamTransactionFDPubAck.fromValueBytes(pub_ack_param.value, 0, pub_ack_param.value.length);
                this.handlePubAcks(pubackParam, err_resp);
            }
            if (mtype == AssuredCtrlEnums.TransactionCtrlMessageType.COMMIT_TRANSACTION) {
                if (err_resp != null && err_resp.getSubcodeEx() != 54) {
                    this.tsession.handleUnrecoverableException(new InvalidMessageReceivedException(String.format("Got exception response (%s) on a COMMIT response (invalid), expecting a ROLLBACK response.", new Object[]{err_resp})));
                    return;
                }
                if (err_resp != null && err_resp.getSubcodeEx() == 54) {
                    this.tsession.responseTimerSetter.enableStartTimer();
                    this.tsession.responseTimerSetter.startTimer();
                    return;
                }
                this.tsession.setTransactionID(txid.b);
                if (Trace.isDebugEnabled()) {
                    Trace.debug((Object)String.format("%s Transaction committed, new TID:%s", this.tsession, txid.b));
                }
                this.postCommit();
                try {
                    this.setState(this.tsession.sessionStateStorage.STATE_ACTIVE);
                }
                catch (JCSMPException e) {
                    Trace.debug((Object)("got exception: " + e.getMessage()));
                }
                this.tsession.responseQueue.add(txid);
            } else if (mtype == AssuredCtrlEnums.TransactionCtrlMessageType.ROLLBACK_TRANSACTION) {
                String err_rollback;
                block17: {
                    if (Trace.isDebugEnabled()) {
                        Trace.debug((Object)String.format("Transaction unexpected rollback %s from router, new TID:%s", txid.a, txid.b));
                    }
                    this.tsession.transactionIds.set(txid.b);
                    err_rollback = String.format("%s Transaction '%s' unexpectedly rolled back during commit attempt.", this.tsession, txid.a);
                    if (err_resp != null) {
                        err_rollback = err_rollback + String.format(" (%s)", new Object[]{err_resp});
                    }
                    this.rollbackFlows();
                    try {
                        this.setState(this.tsession.sessionStateStorage.STATE_ACTIVE);
                    }
                    catch (JCSMPException e) {
                        if (!Trace.isDebugEnabled()) break block17;
                        Trace.debug((Object)("gor exception: " + e.getMessage()));
                    }
                }
                this.tsession.responseQueue.add((Object)new RollbackException(err_rollback, (Throwable)((Object)err_resp)));
                if (Trace.isWarnEnabled()) {
                    Trace.warn((Object)String.format("Commit failure: %s", new Object[]{err_resp}));
                }
                this.rollbackFlowControl();
            } else {
                Trace.info((Object)("Ignoring invalid AssuredCtrl message in state " + String.valueOf((Object)this.getStatusEnum())));
            }
        }

        protected void notifyBound(AssuredCtrlEnums.TransactedSessionState routerState, AssuredCtrlHeaderParameters.ParamTransactionId routerTid) throws JCSMPException {
            boolean isContinuation;
            super.notifyBound(routerState, routerTid);
            long tid_rtr_in_progress = routerTid.b;
            long tid_local_in_progress = this.tsession.getTransactionId().a;
            boolean bl = isContinuation = tid_rtr_in_progress == tid_local_in_progress;
            if (Trace.isInfoEnabled()) {
                Trace.info((Object)String.format("%s notifyBound in state COMMITTING, local_in_progress=%s, router_in_progress=%s, router_session_status=%s", new Object[]{this.tsession, tid_local_in_progress, tid_rtr_in_progress, routerState}));
            }
            if (!isContinuation) {
                this.tsession.setTransactionID(tid_rtr_in_progress);
                switch (routerState) {
                    case COMMITTED: {
                        this.setState(this.tsession.sessionStateStorage.STATE_ACTIVE);
                        this.tsession.responseQueue.add(routerTid);
                        break;
                    }
                    case ROLLEDBACK: {
                        String err_rollback = String.format("%s Transaction '%s' unexpectedly rolled back during commit attempt.", this.tsession, tid_local_in_progress);
                        this.rollbackFlows();
                        this.setState(this.tsession.sessionStateStorage.STATE_ACTIVE);
                        this.tsession.responseQueue.add((Object)new RollbackException(err_rollback));
                        break;
                    }
                    case NEW: {
                        String err_unknown = String.format("%s Commit Error on transaction '%s' due to the transacted session failed to resume. The transaction may or may not be committed on the router.", this.tsession, tid_local_in_progress);
                        this.rollbackFlows();
                        this.setState(this.tsession.sessionStateStorage.STATE_ACTIVE);
                        this.tsession.responseQueue.add((Object)new TransactionResultUnknownException(err_unknown));
                        break;
                    }
                    default: {
                        this.tsession.handleUnrecoverableException(new InvalidOperationException("Lost transaction sync in COMMITTING: router state should not be " + routerState.toString()));
                    }
                }
            }
        }
    }

    public static class StateActive
    extends TSState {
        public StateActive(TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        public TransactionStatus getStatusEnum() {
            return TransactionStatus.ACTIVE;
        }

        public void allowOperation(BaseTransactedSessionImpl.AllowedOperation op) throws InvalidOperationException {
            switch (op) {
                case CREATEFLOW: 
                case COMMIT: 
                case ROLLBACK: 
                case RECEIVE: 
                case SEND: {
                    break;
                }
                default: {
                    this.throwDisallowedOp(op);
                }
            }
        }

        protected void enter() throws JCSMPException {
            super.enter();
            this.tsession.resetTransactionSteps();
            this.tsession.processFlowsToClose();
            this.tsession.retransmission.reset();
            this.tsession.cur_post_tries = 0;
            this.ackEverythingSent();
        }

        protected void notifyBound(AssuredCtrlEnums.TransactedSessionState routerState, AssuredCtrlHeaderParameters.ParamTransactionId routerTid) throws JCSMPException {
            boolean isContinuation;
            long tid_rtr_last = routerTid.a;
            long tid_rtr_in_progress = routerTid.b;
            long tid_local_in_progress = this.tsession.getTransactionId().a;
            boolean bl = isContinuation = tid_rtr_in_progress == tid_local_in_progress;
            if (Trace.isInfoEnabled()) {
                Trace.info((Object)String.format("%s notifyBound in state ACTIVE, local_in_progress=%s, router_in_progress=%s, router_session_status=%s", new Object[]{this.tsession, tid_local_in_progress, tid_rtr_in_progress, routerState}));
            }
            if (isContinuation) {
                Trace.debug((Object)String.format("Transacted session (%s) continuing transaction.", this.tsession.toString()));
            } else {
                String errInfo = String.format("(local_tx_inprogress:%s, router_last_tx:%s, router_tx_inprogress:%s)", tid_local_in_progress, tid_rtr_last, tid_rtr_in_progress);
                switch (routerState) {
                    case COMMITTED: {
                        this.tsession.handleUnrecoverableException(new InvalidOperationException("Lost sync with transaction peer: rebound in ACTIVE, peer last state is COMMITTED, but didn't continue transaction. " + errInfo));
                        break;
                    }
                    case ROLLEDBACK: {
                        if (tid_rtr_last == tid_local_in_progress) {
                            this.setState(this.getStateCache().STATE_MARKEDROLLBACK);
                            break;
                        }
                        this.tsession.handleUnrecoverableException(new InvalidOperationException("Lost sync with transaction peer: rebound in ACTIVE, peer last state is ROLLEDBACK, but transaction IDs mismatched. " + errInfo));
                        break;
                    }
                    case NEW: {
                        this.tsession.setTransactionID(routerTid.b);
                        break;
                    }
                    default: {
                        this.tsession.handleUnrecoverableException(new InvalidOperationException("Lost sync with transaction peer: Got rebind with invalid state. " + errInfo));
                    }
                }
            }
        }

        protected void notifyFlowRebindFinished() throws JCSMPException {
            super.notifyFlowRebindFinished();
            this.tsession.startAdRetransmission();
        }

        public void doCommit() throws JCSMPException {
            if (this.tsession.hasUnboundSubFlows()) {
                this.setState(this.tsession.sessionStateStorage.STATE_COMMIT_ROLLINGBACK);
            } else {
                this.setState(this.tsession.sessionStateStorage.STATE_COMMITTING);
            }
        }

        public void doRollback() throws JCSMPException {
            this.setState(this.tsession.sessionStateStorage.STATE_ROLLINGBACK);
        }
    }

    public static class StateClosed
    extends TSState {
        public StateClosed(TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        public TransactionStatus getStatusEnum() {
            return TransactionStatus.CLOSED;
        }

        protected void throwDisallowedOp(BaseTransactedSessionImpl.AllowedOperation op) throws InvalidOperationException {
            if (this.tsession.marked_close_exception != null) {
                throw new StaleSessionException(String.format("Operation %s disallowed in state %s.", new Object[]{op, this.getStatusEnum()}), this.tsession.marked_close_exception);
            }
            throw new ClosedFacilityException(String.format("Operation %s disallowed in state %s.", new Object[]{op, this.getStatusEnum()}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void enter() throws JCSMPException {
            super.enter();
            Trace.debug((Object)String.format("Closing TransactedSession (%s).", this.tsession.toString()));
            if (this.tsession.marked_close_exception != null) {
                this.tsession.responseQueue.add((Object)this.tsession.marked_close_exception);
            } else {
                this.tsession.responseQueue.add(new Object());
            }
            LinkedList<Closeable> to_close = new LinkedList<Closeable>();
            Object object = this.tsession.inputFlows;
            synchronized (object) {
                to_close.addAll(this.tsession.inputFlows);
            }
            object = this.tsession.outputFlows;
            synchronized (object) {
                to_close.addAll(this.tsession.outputFlows);
            }
            Trace.debug((Object)String.format("Transacted session (%s) closing; closing %s managed guaranteed delivery flows.", this.tsession.getName(), to_close.size()));
            for (Closeable obj : to_close) {
                try {
                    obj.close();
                }
                catch (Throwable t) {
                    Trace.info((Object)"Error closing GD flow", t);
                }
            }
            this.tsession.processFlowsToClose();
            this.tsession.resetTransactionSteps();
            this.tsession._parentSessionMgr.closeTransactedSession(this.tsession, true);
            this.tsession._parentSessionMgr.removeManagedTransactedSession(this.tsession);
        }
    }

    public static class StateNew
    extends TSState {
        public StateNew(TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        public TransactionStatus getStatusEnum() {
            return TransactionStatus.UNKNOWN;
        }

        protected void notifyBound(AssuredCtrlEnums.TransactedSessionState routerState, AssuredCtrlHeaderParameters.ParamTransactionId tid) throws JCSMPException {
            if (!routerState.equals((Object)AssuredCtrlEnums.TransactedSessionState.NEW)) {
                throw new InvalidMessageReceivedException("Failed to bind TransactedSession, expected state NEW, got " + routerState.toString());
            }
            this.tsession._parentSessionMgr.addManagedTransactedSession(this.tsession);
            this.tsession.setTransactionID(tid.b);
            this.setState(this.getStateCache().STATE_ACTIVE);
        }
    }

    public static class TSStorage {
        public final TSState STATE_NEW;
        public final TSState STATE_ACTIVE;
        public final TSState STATE_ROLLINGBACK;
        public final TSState STATE_COMMITTING;
        public final TSState STATE_CLOSED;
        public final TSState STATE_MARKEDROLLBACK;
        public final TSState STATE_COMMIT_ROLLINGBACK;

        public TSStorage(TransactedSessionImpl parentSession) {
            this.STATE_NEW = new StateNew(parentSession);
            this.STATE_ACTIVE = new StateActive(parentSession);
            this.STATE_ROLLINGBACK = new StateRollingBack(parentSession);
            this.STATE_COMMITTING = new StateCommitting(parentSession);
            this.STATE_CLOSED = new StateClosed(parentSession);
            this.STATE_MARKEDROLLBACK = new StateMarkedRollback(parentSession);
            this.STATE_COMMIT_ROLLINGBACK = new StateCommitRollingBack(parentSession);
        }
    }
}

