/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.queues;

import com.solacesystems.jcsmp.impl.XMLMessageQueue;
import com.solacesystems.jcsmp.impl.flow.FlowHandle;
import com.solacesystems.jcsmp.impl.queues.AbstractUnackedMessageList;
import com.solacesystems.jcsmp.impl.queues.AppAckRangeCache;
import com.solacesystems.jcsmp.impl.queues.CircularBufferList;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnackedMessageList2
extends AbstractUnackedMessageList {
    private static final Log Trace = LogFactory.getLog(UnackedMessageList2.class);
    private CircularBufferList<AbstractUnackedMessageList.MessageAckInfo> clist;
    private int unsentAcks;
    private int thresholdCount;
    private final XMLMessageQueue messageQueue;
    private final int sz;
    private final HashMap<Long, AbstractUnackedMessageList.MessageAckInfo> overflow;

    public UnackedMessageList2(int size, FlowHandle flow, int thresholdCount, XMLMessageQueue messageQueue) {
        super(flow);
        this.sz = size;
        this.clist = new CircularBufferList(this.sz);
        this.unsentAcks = 0;
        this.thresholdCount = thresholdCount;
        this.messageQueue = messageQueue;
        this.overflow = new HashMap(1000);
    }

    @Override
    public void clear() {
        this.rLock.lock();
        try {
            this.unsentAcks = 0;
            this.clist = new CircularBufferList(this.sz);
            this.overflow.clear();
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractUnackedMessageList.EAddResult add(long msgId) {
        this.rLock.lock();
        try {
            if (this.clist.getCount() > 0 && this.clist.get(this.clist.getCount() - 1) != null && this.clist.get((int)(this.clist.getCount() - 1)).msgId >= msgId) {
                AbstractUnackedMessageList.EAddResult eAddResult = AbstractUnackedMessageList.EAddResult.DUPLICATE;
                return eAddResult;
            }
            if (this.clist.getCapacity() == 0) {
                AbstractUnackedMessageList.MessageAckInfo trampled_record = this.clist.get(0);
                if (trampled_record != null && trampled_record.appAcked && !trampled_record.ackSent) {
                    this.sendAcks("trample-record", false);
                } else if (trampled_record != null && !trampled_record.appAcked) {
                    this.overflow.put(trampled_record.msgId, trampled_record);
                }
            }
            this.clist.add(new AbstractUnackedMessageList.MessageAckInfo(msgId));
            AbstractUnackedMessageList.EAddResult eAddResult = AbstractUnackedMessageList.EAddResult.OK;
            return eAddResult;
        }
        finally {
            this.rLock.unlock();
        }
    }

    private int bsearchCircularBuffer(CircularBufferList<AbstractUnackedMessageList.MessageAckInfo> list, long msgId) {
        int cnt = list.getCount();
        int low = 0;
        int high = cnt - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (list.get((int)mid).msgId > msgId) {
                high = mid - 1;
                continue;
            }
            if (list.get((int)mid).msgId < msgId) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isKnownAppAcked(long msgId) {
        this.rLock.lock();
        try {
            int index = this.bsearchCircularBuffer(this.clist, msgId);
            if (index != -1) {
                AbstractUnackedMessageList.MessageAckInfo m = this.clist.get(index);
                boolean bl = m.appAcked;
                return bl;
            }
            boolean bl = !this.overflow.containsKey(msgId);
            return bl;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public void setAckThreshold(int threshold) {
        this.thresholdCount = threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractUnackedMessageList.EAppAckResult applicationAck(long msgId, boolean force_send) {
        this.rLock.lock();
        int index = -1;
        int localUnsentAcks = 0;
        try {
            index = this.bsearchCircularBuffer(this.clist, msgId);
            if (index != -1) {
                AbstractUnackedMessageList.MessageAckInfo m = this.clist.get(index);
                assert (m.msgId == msgId);
                if (!m.appAcked) {
                    this.flowHandle.startAckTimer();
                    m.appAcked = true;
                    ++this.unsentAcks;
                } else {
                    AbstractUnackedMessageList.EAppAckResult eAppAckResult = AbstractUnackedMessageList.EAppAckResult.DUPLICATE_ACK;
                    return eAppAckResult;
                }
                localUnsentAcks = this.unsentAcks;
            } else {
                this.overflow.remove(msgId);
            }
        }
        finally {
            this.rLock.unlock();
        }
        if (index == -1 || force_send) {
            this.flowHandle.sendSingleAck(msgId, false);
            return AbstractUnackedMessageList.EAppAckResult.NOT_FOUND;
        }
        if (localUnsentAcks >= this.thresholdCount) {
            this.sendAcks("appack", false);
        }
        return AbstractUnackedMessageList.EAppAckResult.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendAcks(String reason, boolean allowReactorComplete) {
        WireMessage ackMsg = null;
        AppAckRangeCache rangecache = new AppAckRangeCache();
        this.rLock.lock();
        try {
            Object object = this.flowHandle.getAckCreateSendLock();
            synchronized (object) {
                this.flowHandle.stopAckTimer();
                this.flowHandle.setNumUnackedTpMsgs(0);
                this.unsentAcks = 0;
                int chunks = 0;
                ackMsg = this.flowHandle.tpCreateAck();
                if (Trace.isDebugEnabled()) {
                    Trace.debug((Object)String.format("UNACKLIST-ack>>> reason=%s flow=%s", reason, this.flowHandle.getFlowId()));
                }
                int cnt = this.clist.getCount();
                int i = 0;
                while (i < cnt) {
                    while (i < cnt && !this.clist.get((int)i).appAcked) {
                        ++i;
                    }
                    if (i == cnt) break;
                    long first = this.clist.get((int)i).msgId;
                    this.clist.get((int)i).ackSent = true;
                    while (i < cnt && this.clist.get((int)i).appAcked) {
                        this.clist.get((int)i).ackSent = true;
                        ++i;
                    }
                    long last = this.clist.get((int)(i - 1)).msgId;
                    rangecache.addTmp(first, last);
                    if (Trace.isDebugEnabled()) {
                        Trace.debug((Object)String.format("UNACKLIST-ack-range>>> reason=%s; flow=%s; %s-%s", reason, this.flowHandle.getFlowId(), first, last));
                    }
                    if (++chunks != 64) continue;
                    chunks = 0;
                    this.tpAddApplicationAcks((AssuredCtrlHeaderBean)ackMsg.getHeaderBean(), rangecache);
                    rangecache.clear();
                    this.flowHandle.tpSendAck(ackMsg, false, allowReactorComplete);
                    ackMsg = this.flowHandle.tpCreateAck();
                }
                this.tpAddApplicationAcks((AssuredCtrlHeaderBean)ackMsg.getHeaderBean(), rangecache);
                this.flowHandle.tpSendAck(ackMsg, false, allowReactorComplete);
            }
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUnsentAcks() {
        this.rLock.lock();
        try {
            int cnt = this.clist.getCount();
            for (int i = 0; i < cnt; ++i) {
                if (this.clist.get((int)i).ackSent) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public int getWindowSize() {
        return this.messageQueue.capacityToCongestion();
    }

    @Override
    public void sendCloseAcks(String reason, boolean allowReactorComplete) {
    }

    @Override
    public AbstractUnackedMessageList.UnackedMessageListInfo getCurrentUnackedMessageListInfo() {
        return null;
    }
}

