/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction;

import com.solacesystems.common.util.ThreadUtil;
import com.solacesystems.jcsmp.ConsumerFlowProperties;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.FlowReceiver;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFatalErrorException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.JCSMPProducerEventHandler;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.ProducerFlowProperties;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.XMLMessageProducer;
import com.solacesystems.jcsmp.impl.Closeable;
import com.solacesystems.jcsmp.impl.ContextBlockingOpCheck;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimeoutHandler;
import com.solacesystems.jcsmp.impl.transaction.BaseTransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TSState;
import com.solacesystems.jcsmp.impl.transaction.TimerSetter;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionManager;
import com.solacesystems.jcsmp.impl.transaction.TransactionIdGen;
import com.solacesystems.jcsmp.impl.transaction.TransactionSteps;
import com.solacesystems.jcsmp.management.SolJmxSupport;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderParameters;
import com.solacesystems.jcsmp.transaction.RollbackException;
import com.solacesystems.jcsmp.transaction.TransactedSession;
import com.solacesystems.jcsmp.transaction.TransactionStatus;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactedSessionImpl
extends BaseTransactedSessionImpl
implements TransactedSession {
    private static final AtomicLong _uidGen = new AtomicLong();
    private final Log Trace = LogFactory.getLog(TransactedSessionImpl.class);
    final TransactedSessionManager _parentSessionMgr;
    final long private_uid;
    Set<FlowHandleImpl> inputFlows = null;
    Set<JCSMPXMLMessageProducer> outputFlows = null;
    Set<Closeable> flowsToClose = null;
    volatile TSState sessionState = null;
    TSState.TSStorage sessionStateStorage = null;
    TransactionIdGen transactionIds = null;
    ContextImpl context;
    final int max_post_tries;
    private final ContextBlockingOpCheck contextOpCheck;
    private volatile Integer connTag;
    volatile int cur_post_tries;
    volatile JCSMPException marked_close_exception = null;
    ArrayBlockingQueue<Object> responseQueue = new ArrayBlockingQueue(10);
    final TimerSetter responseTimerSetter;
    final RetransmissionTracking retransmission = new RetransmissionTracking();

    public TransactedSessionImpl(TransactedSessionManager mgr, JCSMPChannelProperties channelProperties) {
        this._parentSessionMgr = mgr;
        this.context = mgr.context;
        this.contextOpCheck = new ContextBlockingOpCheck(this.context, mgr.getSession().getJCSMPProperties());
        this.private_uid = _uidGen.incrementAndGet();
        this.transactionIds = new TransactionIdGen();
        this.inputFlows = new LinkedHashSet<FlowHandleImpl>();
        this.outputFlows = new LinkedHashSet<JCSMPXMLMessageProducer>();
        this.flowsToClose = new LinkedHashSet<Closeable>();
        this.sessionStateStorage = new TSState.TSStorage(this);
        int responseTimeout = channelProperties.getReadTimeoutInMillis();
        this.max_post_tries = channelProperties.getReconnectRetries() == -1 ? Integer.MAX_VALUE : Math.max(channelProperties.getReconnectRetries() + 1, 1);
        this.responseTimerSetter = new TimerSetter(this.context.getIOReactor(), responseTimeout, new JCSMPTimeoutHandler(){

            public void handleTimeout() {
                TransactedSessionImpl.this.sessionState.handleResponseTimeout();
            }
        });
        this.connTag = null;
        try {
            this.switchState(this.sessionStateStorage.STATE_NEW);
        }
        catch (JCSMPException jCSMPException) {
            // empty catch block
        }
        SolJmxSupport.instance().register(this, mgr._session);
    }

    public JCSMPBasicSession getParentSession() {
        return this._parentSessionMgr.getSession();
    }

    public void allowOperation(BaseTransactedSessionImpl.AllowedOperation op) throws InvalidOperationException {
        this.sessionState.allowOperation(op);
    }

    public void notifyVridChange() {
        this.setName(null);
    }

    public void notifyUnknownName() {
    }

    public synchronized void setConnTag(Integer connTag) {
        this.connTag = connTag;
    }

    public synchronized Integer getConnTag() {
        return this.connTag;
    }

    public TransactionStatus getStatus() {
        return this.sessionState.getStatusEnum();
    }

    public void commit() throws RollbackException, JCSMPException {
        block6: {
            this.contextOpCheck.check();
            this.sessionState.allowOperation(BaseTransactedSessionImpl.AllowedOperation.COMMIT);
            AssuredCtrlHeaderParameters.ParamTransactionId txids = this.transactionIds.getCurrentAndNext();
            this.setConnTag(this._parentSessionMgr.subChannel.getConnCounterTag());
            JCSMPBasicSession session = this._parentSessionMgr.getSession();
            if (session != null) {
                session.waitUntilSessionReconnectDone("commit");
            }
            this.sessionState.doCommit();
            try {
                Object response;
                while ((response = this.responseQueue.take()) instanceof AssuredCtrlHeaderParameters.ParamTransactionId) {
                    AssuredCtrlHeaderParameters.ParamTransactionId responseTxid = (AssuredCtrlHeaderParameters.ParamTransactionId)response;
                    if (txids.a != responseTxid.a) continue;
                    break block6;
                }
                if (response instanceof JCSMPException) {
                    throw (JCSMPException)((Object)response);
                }
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug((Object)"No commit response, not exception");
                }
            }
            catch (InterruptedException e) {
                this.Trace.warn((Object)"Thread interrupted unexpectedly in waiting for a commit response");
                JCSMPInterruptedException ex = new JCSMPInterruptedException("wait for commit response interrupted", e);
                this.handleInterruptedException(ex);
                throw ex;
            }
        }
    }

    public void rollback() throws JCSMPException {
        block8: {
            this.contextOpCheck.check();
            this.sessionState.allowOperation(BaseTransactedSessionImpl.AllowedOperation.ROLLBACK);
            AssuredCtrlHeaderParameters.ParamTransactionId txids = this.transactionIds.getCurrentAndNext();
            this.setConnTag(this._parentSessionMgr.subChannel.getConnCounterTag());
            JCSMPBasicSession session = this._parentSessionMgr.getSession();
            if (session != null) {
                session.waitUntilSessionReconnectDone("rollback");
            }
            this.sessionState.doRollback();
            try {
                Object response;
                while ((response = this.responseQueue.take()) instanceof AssuredCtrlHeaderParameters.ParamTransactionId) {
                    AssuredCtrlHeaderParameters.ParamTransactionId responseTxid = (AssuredCtrlHeaderParameters.ParamTransactionId)response;
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug((Object)("Got rollback response for transaction " + txids.a + "," + txids.b + "/" + responseTxid.a + "," + responseTxid.b));
                    }
                    if (txids.a != responseTxid.a) continue;
                    break block8;
                }
                if (response instanceof JCSMPException) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug((Object)("Got exception: " + ((JCSMPException)((Object)response)).getMessage()));
                    }
                    throw (JCSMPException)((Object)response);
                }
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug((Object)"No rollback response, not exception");
                }
            }
            catch (InterruptedException e) {
                this.Trace.warn((Object)"Thread interrupted unexpectedly in waiting for rollback response");
                JCSMPInterruptedException ex = new JCSMPInterruptedException("wait for rollback response interrupted", e);
                this.handleInterruptedException(ex);
                throw ex;
            }
        }
    }

    public boolean reconnectInProgress() {
        return this._parentSessionMgr.reconnectInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnboundSubFlows() {
        Map<FlowHandleImpl, TransactionSteps.InputFlowInfo> m;
        Map<FlowHandleImpl, TransactionSteps.InputFlowInfo> map = m = this.getTransactionInputSteps();
        synchronized (map) {
            if (m.size() == 0) {
                return false;
            }
            for (Map.Entry<FlowHandleImpl, TransactionSteps.InputFlowInfo> e : m.entrySet()) {
                FlowHandleImpl fh = e.getKey();
                if (fh.isBoundToResource()) continue;
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug((Object)String.format("hasUnboundSubFlows: FlowId %d, TransactedSession(id:%s)", fh.getFlowId(), this.getTransactedSessionId()));
                }
                return this._parentSessionMgr.checkUnboundFlows();
            }
        }
        return false;
    }

    void sendCommitRequest(boolean blockOnAppThread, Integer connIdx) throws JCSMPException {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug((Object)String.format("sendCommitRequest: TransactedSession(id:%s), transaction(id:%d", this.getTransactedSessionId(), this.getTransactionId().a));
        }
        this._parentSessionMgr.sendCommitRequest(this.getTransactedSessionId(), this.getTransactionId(), this.getParamPubNotify(), this.getParamSubAck(), blockOnAppThread, connIdx);
    }

    void sendRollbackRequest(boolean blockOnAppThread, Integer connIdx) throws JCSMPException {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug((Object)String.format("sendRollbackRequest: TransactedSession(id:%s), transaction(id:%d", this.getTransactedSessionId(), this.getTransactionId().a));
        }
        this._parentSessionMgr.sendRollbackRequest(this.getTransactedSessionId(), this.getTransactionId(), null, null, blockOnAppThread, connIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssuredCtrlHeaderParameters.ParamTransactionFDSubAck getParamSubAck() {
        Map<FlowHandleImpl, TransactionSteps.InputFlowInfo> m;
        Map<FlowHandleImpl, TransactionSteps.InputFlowInfo> map = m = this.getTransactionInputSteps();
        synchronized (map) {
            if (m.size() == 0) {
                return null;
            }
            AssuredCtrlHeaderParameters.ParamTransactionFDSubAck p = new AssuredCtrlHeaderParameters.ParamTransactionFDSubAck();
            for (Map.Entry<FlowHandleImpl, TransactionSteps.InputFlowInfo> e : m.entrySet()) {
                FlowHandleImpl fh = e.getKey();
                TransactionSteps.InputFlowInfo fi = e.getValue();
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug((Object)String.format("getParamSubAck: TransactedSession(id:%s), FlowId %d,  minAck:maxAck:count:lastTpMsg:winSz (%d:%d:%d:%d:%d)", this.getTransactedSessionId(), fh.getFlowId(), fi.minAck, fi.maxAck, fi.messageCount, fh.getLastInOrderTpMsg(), fh.getWindowSize()));
                }
                p.addTuple(AssuredCtrlHeaderParameters.ParamTransactionFDSubAck.SubAckTuple.newTuple(fh.getFlowId(), fi.minAck, fi.maxAck, fi.messageCount, fh.getLastInOrderTpMsg(), fh.getWindowSize()));
                fh.setNumUnackedTpMsgs(0);
            }
            return p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify getParamPubNotify() {
        Map<JCSMPXMLMessageProducer, TransactionSteps.OutputFlowInfo> m;
        Map<JCSMPXMLMessageProducer, TransactionSteps.OutputFlowInfo> map = m = this.getTransactionOutputSteps();
        synchronized (map) {
            if (m.size() == 0) {
                return null;
            }
            AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify p = new AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify();
            for (Map.Entry<JCSMPXMLMessageProducer, TransactionSteps.OutputFlowInfo> e : m.entrySet()) {
                JCSMPXMLMessageProducer prod = e.getKey();
                TransactionSteps.OutputFlowInfo fi = e.getValue();
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug((Object)String.format("getParamPubNotify: TransactedSession(id:%s), FlowId %d, count:lastMsgId (%d:%d)", this.getTransactedSessionId(), prod.getPubADManager().flow_Id, fi.messageCount, fi.lastMsgId));
                }
                p.addTuple(AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify.PubNotifyTuple.newTuple(prod.getPubADManager().flow_Id, fi.messageCount, fi.lastMsgId));
            }
            return p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties flowProps, EndpointProperties endpointProps) throws JCSMPException {
        this.contextOpCheck.check();
        this.sessionState.allowOperation(BaseTransactedSessionImpl.AllowedOperation.CREATEFLOW);
        JCSMPBasicSession.InternalBindProperties bindprops = JCSMPBasicSession.InternalBindProperties.create().with(this);
        FlowReceiver fr = this._parentSessionMgr.getSession().createFlow(listener, flowProps, endpointProps, bindprops);
        Set<FlowHandleImpl> set = this.inputFlows;
        synchronized (set) {
            this.inputFlows.add((FlowHandleImpl)fr);
        }
        return fr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties flowProps, EndpointProperties endpointProps, FlowEventHandler flowEventHander) throws JCSMPException {
        this.contextOpCheck.check();
        this.sessionState.allowOperation(BaseTransactedSessionImpl.AllowedOperation.CREATEFLOW);
        JCSMPBasicSession.InternalBindProperties bindprops = JCSMPBasicSession.InternalBindProperties.create().with(this);
        FlowReceiver fr = this._parentSessionMgr.getSession().createFlow(listener, flowProps, endpointProps, bindprops, flowEventHander);
        Set<FlowHandleImpl> set = this.inputFlows;
        synchronized (set) {
            this.inputFlows.add((FlowHandleImpl)fr);
        }
        return fr;
    }

    public XMLMessageProducer createProducer(ProducerFlowProperties fprop, JCSMPStreamingPublishEventHandler callback) throws JCSMPException {
        return this.createProducer(fprop, callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLMessageProducer createProducer(ProducerFlowProperties fprop, JCSMPStreamingPublishEventHandler callback, JCSMPProducerEventHandler eventCallback) throws JCSMPException {
        this.contextOpCheck.check();
        this.sessionState.allowOperation(BaseTransactedSessionImpl.AllowedOperation.CREATEFLOW);
        JCSMPBasicSession.InternalBindProperties bindprops = JCSMPBasicSession.InternalBindProperties.create().with(this, this._parentSessionMgr.subChannel.getConnCounterTag());
        JCSMPXMLMessageProducer prod = (JCSMPXMLMessageProducer)this._parentSessionMgr.getSession().createProducer(fprop, callback, eventCallback, bindprops);
        Set<JCSMPXMLMessageProducer> set = this.outputFlows;
        synchronized (set) {
            this.outputFlows.add(prod);
        }
        return prod;
    }

    public void close() {
        try {
            JCSMPBasicSession session = this._parentSessionMgr.getSession();
            if (session != null) {
                session.waitUntilSessionReconnectDone("close");
            }
            this.switchStateIfNotIn(this.sessionStateStorage.STATE_CLOSED);
        }
        catch (JCSMPException jCSMPException) {
            // empty catch block
        }
        SolJmxSupport.instance().deregister(this);
    }

    private void close(JCSMPException e) {
        this.marked_close_exception = e;
        this.close();
    }

    public void handleTransportException(JCSMPTransportException e) {
        this._parentSessionMgr.subChannel.handleException((Exception)((Object)e));
    }

    public void handleInterruptedException(JCSMPInterruptedException e) {
        this._parentSessionMgr.subChannel.startReconnect(e, false);
    }

    public void handleUnrecoverableException(JCSMPException e) {
        this.Trace.info((Object)String.format("TransactedSession (%s) handling unrecoverable exception: %s", new Object[]{this.toString(), e}), (Throwable)((Object)e));
        this.close(e);
    }

    public AssuredCtrlHeaderParameters.ParamTransactionId getTransactionId() {
        return this.sessionState.getTransactionId();
    }

    public void notifyBound(String txSessionName, long txSessionId, AssuredCtrlEnums.TransactedSessionState routerState, AssuredCtrlHeaderParameters.ParamTransactionId routerTid) throws JCSMPException {
        this.setName(txSessionName);
        this.setTransactedSessionId(txSessionId);
        this.sessionState.notifyBound(routerState, routerTid);
    }

    public void notifyFlowRebindFinished() throws JCSMPException {
        this.sessionState.notifyFlowRebindFinished();
    }

    public void setTransactionID(long txid) {
        this.transactionIds.set(txid);
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug((Object)("setTransactionID: " + this.toString()));
        }
    }

    private void switchState(TSState newstate) throws JCSMPException {
        if (this.Trace.isInfoEnabled()) {
            String cur_status = this.sessionState != null ? String.valueOf((Object)this.sessionState.getStatusEnum()) : "null";
            String next_status = String.valueOf((Object)newstate.getStatusEnum());
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug((Object)String.format("TransactedSession(id:%s) state_change: %s -> %s", this.getTransactedSessionId(), cur_status, next_status));
            }
        }
        this.sessionState = newstate;
        newstate.enter();
    }

    public boolean switchStateIfNotIn(TSState newstate) throws JCSMPException {
        if (this.sessionState == null || this.sessionState == newstate) {
            return false;
        }
        this.switchState(newstate);
        return true;
    }

    public TSState getCurrentSessionState() {
        return this.sessionState;
    }

    public void handleControlMessage(AssuredCtrlEnums.TransactionCtrlMessageType mtype, AssuredCtrlHeaderBean adctrl, JCSMPErrorResponseException err_resp) {
        try {
            this.sessionState.handleAsyncAdCtrl(mtype, adctrl, err_resp);
        }
        catch (Exception e) {
            this.Trace.warn((Object)"Unexpected error occurred during handleAsyncAdCtrl. ", (Throwable)e);
            this.handleUnrecoverableException(TransactedSessionImpl.wrapInJCSMPException(e));
        }
    }

    public int hashCode() {
        return Long.valueOf(this.private_uid).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TransactedSessionImpl)) {
            return false;
        }
        return ((TransactedSessionImpl)obj).private_uid == this.private_uid;
    }

    public String toString() {
        return String.format("(TransactedSessionId:%s, Name:%s, Status:%s, TransactionId:%s)", new Object[]{this.getTransactedSessionId(), this.getName(), this.getStatus(), this.getTransactionId().a});
    }

    public boolean getExpectsAcks() {
        return false;
    }

    public void closeFlow(Closeable c) {
        boolean closeflownow = false;
        if (c instanceof FlowHandleImpl) {
            Map<FlowHandleImpl, TransactionSteps.InputFlowInfo> inpsteps = this.getTransactionInputSteps();
            closeflownow = !inpsteps.containsKey(c) || inpsteps.get((Object)c).messageCount == 0;
        } else if (c instanceof JCSMPXMLMessageProducer) {
            Map<JCSMPXMLMessageProducer, TransactionSteps.OutputFlowInfo> outsteps = this.getTransactionOutputSteps();
            boolean bl = closeflownow = !outsteps.containsKey(c) || outsteps.get((Object)c).messageCount == 0;
        }
        if (closeflownow) {
            this.Trace.debug((Object)"Destroying flow which has not consumed any messages without waiting for a commit or rollback operation");
            this.closeFlowNow(c);
        } else {
            this.enqueueFlowToClose(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueFlowToClose(Closeable flow) {
        Set<Closeable> set = this.flowsToClose;
        synchronized (set) {
            this.flowsToClose.add(flow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFlowsToClose() {
        LinkedHashSet<Closeable> tmp_toClose;
        Set<Closeable> set = this.flowsToClose;
        synchronized (set) {
            if (this.flowsToClose.size() == 0) {
                return;
            }
            tmp_toClose = new LinkedHashSet<Closeable>(this.flowsToClose);
            this.flowsToClose.clear();
        }
        for (Closeable c : tmp_toClose) {
            this.closeFlowNow(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFlowNow(Closeable c) {
        if (c instanceof FlowHandleImpl) {
            this.Trace.debug((Object)("closeFlowNow, flowId=" + ((FlowHandleImpl)c).getFlowId()));
            ((FlowHandleImpl)c).closeImpl(true, false, TcpChannel.WriteBlockPolicy.DROP_AND_IGNORE);
            Set<FlowHandleImpl> set = this.inputFlows;
            synchronized (set) {
                this.inputFlows.remove(c);
            }
        } else if (c instanceof JCSMPXMLMessageProducer) {
            ((JCSMPXMLMessageProducer)c).closeImpl(false);
        }
    }

    public void notifyFinishedAdRetransmissions() {
        this.sessionState.notifyRetransmitsComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startAdRetransmission() {
        LinkedHashSet<JCSMPXMLMessageProducer> producers;
        this.retransmission.reset();
        Set<JCSMPXMLMessageProducer> set = this.outputFlows;
        synchronized (set) {
            producers = new LinkedHashSet<JCSMPXMLMessageProducer>(this.outputFlows);
        }
        final String sess_name = this.getName();
        Runnable r_complete = new Runnable(){

            public void run() {
                RetransmissionTracking retr = TransactedSessionImpl.this.retransmission;
                retr.taskCompleted();
                TransactedSessionImpl.this.Trace.debug((Object)String.format("TransactedSession AdRetransmission complete, session=%s, isAllFinished=%s, taskInfo=%s, state=%s, stack=%s", new Object[]{sess_name, retr.isAllFinished(), retr, TransactedSessionImpl.this.getStatus(), ThreadUtil.getMyStackTrace()}));
                if (retr.isAllFinished()) {
                    TransactedSessionImpl.this.notifyFinishedAdRetransmissions();
                }
            }
        };
        this.Trace.debug((Object)String.format("TransactedSession AdRetransmission START, session=%s, producers=%s, stack=%s", sess_name, producers.size(), ThreadUtil.getMyStackTrace()));
        boolean did_something = false;
        for (JCSMPXMLMessageProducer p : producers) {
            this.retransmission.taskStarted();
            p.handleRetransmitADMsgs(r_complete, false);
            did_something = true;
        }
        return did_something;
    }

    protected static JCSMPException wrapInJCSMPException(Exception e) {
        if (e instanceof JCSMPException) {
            return (JCSMPException)((Object)e);
        }
        return new JCSMPFatalErrorException("Exception occurred.", e);
    }

    public boolean isXA() {
        return false;
    }

    static class RetransmissionTracking {
        int _tasks_started = 0;
        int _tasks_completed = 0;
        final Lock lock = new ReentrantLock();
        final Condition notDone = this.lock.newCondition();

        RetransmissionTracking() {
        }

        public void reset() {
            this.lock.lock();
            try {
                this._tasks_started = 0;
                this._tasks_completed = 0;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void taskStarted() {
            this.lock.lock();
            try {
                ++this._tasks_started;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void taskCompleted() {
            this.lock.lock();
            try {
                ++this._tasks_completed;
                if (this.isAllFinished()) {
                    this.notDone.signal();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean isAllFinished() {
            this.lock.lock();
            try {
                boolean bl = this._tasks_completed >= this._tasks_started;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public String toString() {
            return String.format("TasksStarted:%s, TasksCompleted:%s", this._tasks_started, this._tasks_completed);
        }

        public void waitCompletion() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.isAllFinished()) {
                    this.notDone.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

