/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

public abstract class AbstractTLVParameter {
    public int uh;
    public int type;
    public byte[] value;

    public AbstractTLVParameter(int uh, int type, byte[] value) {
        this.uh = uh;
        this.type = type;
        this.value = value;
    }

    public abstract int getSmfEncodedLength();

    public String toString() {
        String strValue = AbstractTLVParameter.toPrintableString(this.value);
        String s = "uh=" + this.uh + ";type=" + this.type + ";valuelength=" + this.value.length + ";value=[" + strValue + "]";
        return s;
    }

    private static boolean isPrintableAscii(byte[] value) {
        for (byte b : value) {
            if (b == 0 || b >= 32 && b <= 126) continue;
            return false;
        }
        return true;
    }

    private static String toPrintableString(byte[] value) {
        String strValue = "";
        if (value == null || value.length == 0) {
            return "";
        }
        if (!AbstractTLVParameter.isPrintableAscii(value)) {
            StringBuilder sb = new StringBuilder();
            for (byte b : value) {
                sb.append(String.format("%02x ", b));
            }
            strValue = sb.toString();
        } else {
            strValue = new String(value, 0, value[value.length - 1] == 0 ? value.length - 1 : value.length);
        }
        return strValue;
    }
}

