/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.nio.impl;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.protocol.nio.Notification;
import com.solacesystems.jcsmp.protocol.nio.impl.AbstractNotification;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsumerErrorNotification
extends AbstractNotification
implements Notification {
    private static final Log log = LogFactory.getLog(ConsumerErrorNotification.class);
    private XMLMessageListener _listener;
    private JCSMPException _cause;
    private FlowHandleImpl _consumer;

    public ConsumerErrorNotification(XMLMessageListener listener, JCSMPException cause, FlowHandleImpl consumer) {
        this._listener = listener;
        this._cause = cause;
        this._consumer = consumer;
    }

    public int handleNotification() {
        if (this._listener != null && !this.is_canceled()) {
            if (this._listener != this._consumer.getMessageListener()) {
                log.info((Object)"XML message listener has been changed, abort notify");
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Notify exception occurred during receiving: " + this._cause.getMessage()));
                }
                this._listener.onException(this._cause);
            }
        } else {
            log.info((Object)"XML message listener is null");
        }
        return 0;
    }

    public boolean usesHandler(JCSMPStreamingPublishEventHandler handler) {
        return false;
    }

    public boolean usesListener(XMLMessageListener listener) {
        return this._listener == listener;
    }
}

