/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.solcache;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.impl.Request;
import com.solacesystems.jcsmp.impl.solcache.CacheGetResponse;

public class CacheGetResult {
    private Request mRequest = null;
    private CacheGetResponse mResponse = null;
    private JCSMPException mException = null;
    private GetRequestStatus mStatus = GetRequestStatus.Opened;

    public GetRequestStatus getStatus() {
        return this.mStatus;
    }

    public CacheGetResponse getResponse() {
        return this.mResponse;
    }

    public void setResponse(CacheGetResponse response) {
        this.mStatus = GetRequestStatus.Completed;
        this.mResponse = response;
    }

    public void validateResponse() {
        if (!this.mResponse.getResponseCode().equals(CacheGetResponse.OK)) {
            this.mStatus = GetRequestStatus.Errored;
            this.mException = new JCSMPException(this.mResponse.getResponseString() + "(" + this.mResponse.getResponseCode() + ")");
        }
    }

    public JCSMPException getException() {
        return this.mException;
    }

    public void setException(JCSMPException exception) {
        this.mStatus = GetRequestStatus.Errored;
        this.mException = exception;
    }

    public Request getRequest() {
        return this.mRequest;
    }

    public void setRequest(Request request) {
        this.mRequest = request;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("status=");
        bldr.append((Object)this.mStatus);
        if (this.mException != null) {
            bldr.append(", exception=");
            bldr.append(this.mException.getMessage());
        }
        bldr.append(", request={");
        bldr.append(this.mRequest);
        bldr.append("}");
        if (this.mResponse != null) {
            bldr.append(", response={");
            bldr.append(this.mResponse);
            bldr.append("}");
        }
        return bldr.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GetRequestStatus {
        Opened,
        Completed,
        Errored;

    }
}

