/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.queues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularBufferList<E> {
    private int readIndex = 0;
    private int writeIndex = 0;
    private final int MAX_SIZE;
    private E[] list;

    public CircularBufferList(int sz) {
        this.MAX_SIZE = sz + 1;
        this.clear();
    }

    public final void clear() {
        this.readIndex = 0;
        this.writeIndex = 0;
        this.list = new Object[this.MAX_SIZE];
    }

    int getPrevIndex(int index) {
        return --index < 0 ? this.MAX_SIZE - 1 : index;
    }

    int getNextIndex(int index) {
        return ++index >= this.MAX_SIZE ? 0 : index;
    }

    public int getCapacity() {
        return this.MAX_SIZE - 1 - this.getCount();
    }

    public int getCount() {
        return (this.writeIndex - this.readIndex + this.MAX_SIZE) % this.MAX_SIZE;
    }

    public E get(int i) {
        return this.list[(i + this.readIndex) % this.MAX_SIZE];
    }

    public void add(E obj) {
        this.list[this.writeIndex] = obj;
        this.writeIndex = this.getNextIndex(this.writeIndex);
        if (this.writeIndex == this.readIndex) {
            this.readIndex = this.getNextIndex(this.readIndex);
        }
    }
}

