/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.solcache;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.impl.solcache.CacheClusterRequestListener;
import com.solacesystems.jcsmp.impl.solcache.CacheGetRequest;
import com.solacesystems.jcsmp.impl.solcache.CacheGetRequestListener;
import com.solacesystems.jcsmp.impl.solcache.CacheGetResult;
import com.solacesystems.jcsmp.impl.solcache.CacheRequestProperties;

public class CacheClusterRequest
implements CacheGetRequestListener {
    private static long ID = 0L;
    private CacheRequestProperties mProps;
    private Topic mTopic;
    private boolean mIncClusters;
    private CacheClusterRequestListener mListener;
    private long mId;

    private static synchronized long getNextID() {
        return ID++;
    }

    public CacheClusterRequest(CacheRequestProperties props, Topic topic, boolean incClusters, CacheClusterRequestListener listener) {
        this.mProps = props;
        this.mTopic = topic;
        this.mIncClusters = incClusters;
        this.mListener = listener;
        this.mId = CacheClusterRequest.getNextID();
    }

    public long getId() {
        return this.mId;
    }

    public void send() throws JCSMPException {
        CacheGetRequest request = new CacheGetRequest(this.mProps, this.mTopic, this.mIncClusters, this);
        request.send();
    }

    @Override
    public boolean onResult(CacheGetResult result) {
        boolean cont = this.mListener.onGetResult(this.mTopic, result);
        if (!result.getStatus().equals((Object)CacheGetResult.GetRequestStatus.Completed) || !result.getResponse().hasMore().booleanValue()) {
            this.mListener.onClusterResult(this.mTopic, this.mId);
        }
        return cont;
    }
}

