/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.compression;

import com.jcraft.jzlib.ZStream;
import com.solacesystems.jcsmp.impl.compression.LookbackBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;

public class SolZlibLookbackPipe {
    static final byte[] hello = "hello! thisisareallyloooooooooooooooooooooooooooongwordthaaaaaaaaaaaaaaaaaaaaaaaaaatdemonstratestheabilitytosetwindowsizeandbythewaywestillnothappywiththeproperlength".getBytes(Charset.forName("UTF-8"));
    static final byte[] dict = "hello word aaaaaaaaaaaaaaaaaaa demonstratestheabilitytosetwindowsizeandbythewaywe".getBytes(Charset.forName("UTF-8"));
    private LookbackBuffer _deflateLookback;
    private LookbackBuffer _inflateLookback;
    ZStream infl_stream = new ZStream();
    boolean infl_stream_init = false;
    final int compressionLevel;

    public SolZlibLookbackPipe(int lookbackSize, int solCompressionLevel) {
        this.init();
        this.compressionLevel = SolZlibLookbackPipe.mapCompressionLevel(solCompressionLevel);
        this._deflateLookback = new LookbackBuffer(50);
        this._inflateLookback = new LookbackBuffer(50);
    }

    private static int mapCompressionLevel(int solCompressionLevel) {
        if (0 < solCompressionLevel && solCompressionLevel <= 5) {
            return 1;
        }
        if (solCompressionLevel > 5) {
            return 9;
        }
        throw new IllegalArgumentException("Invalid solCompressionLevel " + String.valueOf(solCompressionLevel));
    }

    private void init() {
    }

    public long deflateWithLookback(byte[] input, int inputStart, int inputEnd, byte[] output, int outputStart, int outputEnd) {
        ZStream c_stream;
        block6: {
            c_stream = new ZStream();
            int returnCode = 0;
            returnCode = c_stream.deflateInit(this.compressionLevel);
            if (returnCode != 0) {
                return -1L;
            }
            if (this._deflateLookback.available() > 0) {
                System.out.println(String.format("DEFL>>> set dictionary from lookback [%s]", new String(this._deflateLookback.getLookback(), 0, this._deflateLookback.available(), Charset.forName("UTF-8"))));
                if (c_stream.deflateSetDictionary(this._deflateLookback.getLookback(), this._deflateLookback.available()) != 0) {
                    return -1L;
                }
            }
            int uncompressedSize = inputEnd - inputStart;
            int compressedAvailable = outputEnd - outputStart;
            c_stream.next_out = output;
            c_stream.next_out_index = outputStart;
            c_stream.avail_out = compressedAvailable;
            c_stream.next_in = input;
            c_stream.next_in_index = inputStart;
            c_stream.avail_in = uncompressedSize;
            int availableIn = uncompressedSize;
            int availableOut = compressedAvailable;
            while (c_stream.total_in != (long)uncompressedSize && c_stream.total_out < (long)compressedAvailable) {
                c_stream.avail_in = availableIn;
                c_stream.avail_out = availableOut;
                if (c_stream.deflate(0) != 0) {
                    return -1L;
                }
                availableIn = (int)((long)availableIn - c_stream.total_in);
                availableOut = (int)((long)availableOut - c_stream.total_out);
            }
            do {
                c_stream.avail_out = availableOut;
                returnCode = c_stream.deflate(4);
                if (returnCode == 1) break block6;
            } while (returnCode == 0);
            return -1L;
        }
        c_stream.deflateEnd();
        this._deflateLookback.put(input, inputStart, inputEnd - inputStart);
        return c_stream.total_out;
    }

    public long inflateWithLookback(byte[] input, int inputStart, int inputEnd, byte[] output, int outputStart, int outputEnd) {
        AtomicInteger inp_consumed;
        long output_this_chunk;
        int to_process = inputEnd - inputStart;
        long decompressed = 0L;
        System.out.println(String.format("INFL>>> starting block set input, to_process=%s", to_process));
        while ((output_this_chunk = this.inflateChunkWithLookback(input, inputStart, inputEnd, output, outputStart, outputEnd, inp_consumed = new AtomicInteger(0))) != -1L) {
            inputStart += inp_consumed.get();
            outputStart = (int)((long)outputStart + output_this_chunk);
            System.out.println(String.format("  INFL>>> block decode, to_process=%s, decompressed=%s", to_process -= inp_consumed.get(), decompressed += output_this_chunk));
            if (to_process > 0) continue;
        }
        return decompressed;
    }

    public long inflateChunkWithLookback(byte[] input, int inputStart, int inputEnd, byte[] output, int outputStart, int outputEnd, AtomicInteger inputConsumed) {
        long outBytesThisCallStart;
        long inBytesThisPassStart;
        block9: {
            int compressedBufferSize = inputEnd - inputStart;
            int uncompressedBufferAvailableSize = outputEnd - outputStart;
            this.infl_stream.next_in = input;
            this.infl_stream.next_in_index = inputStart;
            this.infl_stream.avail_in = compressedBufferSize;
            this.infl_stream.next_out = output;
            this.infl_stream.next_out_index = outputStart;
            this.infl_stream.avail_out = uncompressedBufferAvailableSize;
            int returnCode = 0;
            if (!this.infl_stream_init) {
                this.infl_stream_init = true;
                returnCode = this.infl_stream.inflateInit();
                if (returnCode != 0) {
                    return -1L;
                }
            }
            inBytesThisPassStart = this.infl_stream.total_in;
            outBytesThisCallStart = this.infl_stream.total_out;
            while (true) {
                long outBytesThisPassStart = this.infl_stream.total_out;
                returnCode = this.infl_stream.inflate(2);
                if (returnCode == 2) {
                    if (this._inflateLookback.available() > 0) {
                        System.out.println(String.format("INFL>>> set dictionary from lookback [%s]", new String(this._inflateLookback.getLookback(), 0, this._inflateLookback.available(), Charset.forName("UTF-8"))));
                        if (this.infl_stream.inflateSetDictionary(this._inflateLookback.getLookback(), this._inflateLookback.available()) != 0) {
                            return -1L;
                        }
                    } else {
                        return -1L;
                    }
                }
                long bytesThisPass = this.infl_stream.total_out - outBytesThisPassStart;
                if (returnCode == 1 || returnCode == 0) {
                    this._inflateLookback.put(output, outputStart + (int)outBytesThisPassStart, (int)bytesThisPass);
                }
                if (returnCode == 1) {
                    this.infl_stream.inflateEnd();
                    this.infl_stream_init = false;
                    break block9;
                }
                if (returnCode == 0) continue;
                if (returnCode == -5) break block9;
                if (returnCode == -1 || returnCode == -2 || returnCode == -3 || returnCode == -6) break;
            }
            return -1L;
        }
        inputConsumed.set((int)this.infl_stream.total_in - (int)inBytesThisPassStart);
        return this.infl_stream.total_out - outBytesThisCallStart;
    }
}

