/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.common.util.SolByteBuffer;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.MapMessage;
import com.solacesystems.jcsmp.SDTEOFException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.impl.ContentBuffer;
import com.solacesystems.jcsmp.impl.JCSMPGenericXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.MessageImpl;
import com.solacesystems.jcsmp.impl.sdt.MapImpl;
import com.solacesystems.jcsmp.impl.sdt.TLVBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapMessageImpl
extends MessageImpl
implements MapMessage {
    private static final Log Trace = LogFactory.getLog(MapMessageImpl.class);
    protected SDTMap mMap;
    protected boolean mInitialized;

    public MapMessageImpl(BytesXMLMessage message) {
        super(message);
        ((JCSMPXMLMessage)((Object)message)).setStructuredMsg(true);
        ((JCSMPXMLMessage)((Object)message)).setStructuredMsgType((byte)10);
        this.mMap = null;
        this.mInitialized = false;
    }

    @Override
    public synchronized SDTMap getMap() {
        block7: {
            if (!this.mInitialized) {
                this.mInitialized = true;
                ContentBuffer cb = ((JCSMPXMLMessage)((Object)this.mMessage)).attachmentCB;
                if (cb != null && cb.getLimit() > 0) {
                    ByteArray ba = new ByteArray(cb.getBufferRefInternal(), 0, cb.getLimit());
                    TLVBuffer buf = new TLVBuffer(ba);
                    try {
                        Object obj = buf.read();
                        if (obj instanceof SDTMap) {
                            this.mMap = (SDTMap)obj;
                        } else if (Trace.isWarnEnabled()) {
                            Trace.warn((Object)"Message payload does not contain a map");
                        }
                    }
                    catch (SDTEOFException e) {
                        if (!Trace.isWarnEnabled()) break block7;
                        Trace.warn((Object)"Message payload does not contain a map", (Throwable)e);
                    }
                }
            }
        }
        return this.mMap;
    }

    @Override
    public synchronized void setMap(SDTMap map) {
        if (map != null) {
            TLVBuffer buffer = ((JCSMPGenericXMLMessage)this.mMessage).getTLVBuffer();
            buffer.clear();
            ((MapImpl)map).serialize(buffer);
            SolByteBuffer byteBuf = buffer.getSolByteBuffer();
            this.mMessage.writeAttachment(byteBuf.getBackingArray(), byteBuf.getBackingArrayOffset(), byteBuf.getLength());
        }
        this.mMap = map;
        this.mInitialized = true;
    }

    @Override
    public void reset() {
        super.reset();
        this.setMap(null);
    }
}

