/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol;

import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.SubCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
@ProviderType
public class CSMPResponseParser {
    private static final Log Trace = LogFactory.getLog(CSMPResponseParser.class);
    public static final String OK_TRUE = "1";
    public static final String OK_FALSE = "0";
    public static final String ADD_FLAG_FALSE = "0";
    public static final String ISFILTER_FALSE = "0";
    private static CSMPResponseParser m_self = null;
    private SAXParserFactory m_saxFactory = SAXParserFactory.newInstance();

    private CSMPResponseParser() {
    }

    public static synchronized CSMPResponseParser onlyInstance() {
        if (m_self == null) {
            m_self = new CSMPResponseParser();
        }
        return m_self;
    }

    private String getFirstAttributeValue(String attName, Attributes attrs) {
        int index;
        if (attrs != null && attrs.getLength() != 0 && (index = attrs.getIndex(attName)) >= 0) {
            return attrs.getValue(index).trim();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SUResponseBean parseSUResponse(JCSMPErrorResponseException opEx) {
        block10: {
            if (opEx != null && opEx.getResponseBody() != null && opEx.getResponseBody().length() > 0) {
                try {
                    SAXParser saxParser;
                    ByteArrayInputStream bufIS = new ByteArrayInputStream(opEx.getResponseBody().getBytes("UTF-8"));
                    SAXParserFactory sAXParserFactory = this.m_saxFactory;
                    synchronized (sAXParserFactory) {
                        saxParser = this.m_saxFactory.newSAXParser();
                    }
                    SUResponseHandler m_suResponseHandler = new SUResponseHandler();
                    saxParser.parse((InputStream)bufIS, (DefaultHandler)m_suResponseHandler);
                    return m_suResponseHandler.getSUResponseBean();
                }
                catch (ParserConfigurationException e) {
                    if (Trace.isErrorEnabled()) {
                        Trace.error((Object)JCSMPRB.BUNDLE.getStringSafely("CSMPResponseParser.exceptionOccurred"), (Throwable)e);
                    }
                }
                catch (SAXException e) {
                    if (Trace.isErrorEnabled()) {
                        Trace.error((Object)JCSMPRB.BUNDLE.getStringSafely("CSMPResponseParser.exceptionOccurred"), (Throwable)e);
                    }
                }
                catch (IOException e) {
                    if (!Trace.isErrorEnabled()) break block10;
                    Trace.error((Object)JCSMPRB.BUNDLE.getStringSafely("CSMPResponseParser.exceptionOccurred"), (Throwable)e);
                }
            }
        }
        return null;
    }

    public SUSubscriberCtrlBean parseSUSubscriberCtrlResponse(SubCtrlHeaderBean messageBean) {
        if (messageBean != null) {
            SUSubscriberCtrlBean hydratedBean = new SUSubscriberCtrlBean();
            SmfTLVParameter param = (SmfTLVParameter)messageBean.findFirstParameter(5);
            if (param != null) {
                hydratedBean.setMulticastIP(TlvParameterParser.getSubCtrlUdpMcastAddress(param));
                hydratedBean.setMulticastPort(TlvParameterParser.getSubCtrlUdpMcastPort(param));
                hydratedBean.setSubscriberId((short)TlvParameterParser.getSubCtrlUdpMcastSubscriberId(param));
            }
            if ((param = (SmfTLVParameter)messageBean.findFirstParameter(6)) != null) {
                hydratedBean.setRefreshRequired(true);
            } else {
                hydratedBean.setRefreshRequired(false);
            }
            return hydratedBean;
        }
        return null;
    }

    protected class SUResponseHandler
    extends DefaultHandler {
        public static final String SU_ATT_VAL = "val";
        public static final String SU_TAG_ENTIREPACKET_REJECTED = "entirePacketRejected";
        public static final String SU_TAG_ENTIREUPDATE_REJECTED = "entireUpdateRejected";
        public static final String SU_TAG_RESPONSE = "SubscriptionUpdateResponse";
        public static final String SU_TAG_SINGLE_PACKET = "SubscriptionPacket";
        public static final String SU_TAG_ISOK = "isOk";
        public static final String SU_TAG_VERSION = "version";
        public static final String SU_TAG_SINGLE_PACKET_FAILURE = "failureReason";
        public static final String SU_TAG_SEQNUM = "seqNum";
        public static final String SU_TAG_ADD_FLAG = "addFlag";
        public static final String SU_TAG_FILTER_TAG = "filterFlag";
        public static final String SU_TAG_SUBCRIPTION = "subscription";
        public static final String SU_ATT_XPE = "xpe";
        private SUResponseBean m_responseBean;
        private SUPacketBean m_packetBean;

        protected SUResponseHandler() {
        }

        @Override
        public void startDocument() {
            this.m_responseBean = null;
        }

        public SUResponseBean getSUResponseBean() {
            return this.m_responseBean;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            String eName = localName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (eName.equals(SU_TAG_SINGLE_PACKET) && this.m_packetBean != null) {
                this.m_responseBean.addPacketResponse(this.m_packetBean);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            super.endPrefixMapping(prefix);
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) {
            String eName = lName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (eName.equals(SU_TAG_RESPONSE)) {
                this.m_responseBean = new SUResponseBean();
                return;
            }
            if (eName.equals(SU_TAG_ISOK)) {
                this.m_responseBean.setIsOK(CSMPResponseParser.this.getFirstAttributeValue(SU_ATT_VAL, attrs));
                return;
            }
            if (eName.equals(SU_TAG_ENTIREPACKET_REJECTED) || eName.equals(SU_TAG_ENTIREUPDATE_REJECTED)) {
                this.m_responseBean.setEntirePacketRejectionReason(CSMPResponseParser.this.getFirstAttributeValue(SU_ATT_VAL, attrs));
                return;
            }
            if (eName.equals(SU_TAG_SINGLE_PACKET)) {
                if (this.m_responseBean != null) {
                    this.m_packetBean = new SUPacketBean();
                }
                return;
            }
            if (eName.equals(SU_TAG_SINGLE_PACKET_FAILURE)) {
                this.m_packetBean.setFailureReason(CSMPResponseParser.this.getFirstAttributeValue(SU_ATT_VAL, attrs));
                return;
            }
            if (eName.equals(SU_TAG_SEQNUM)) {
                block13: {
                    String seqNum = CSMPResponseParser.this.getFirstAttributeValue(SU_ATT_VAL, attrs);
                    try {
                        this.m_packetBean.setSequenceNumber(Integer.parseInt(seqNum));
                    }
                    catch (NumberFormatException e) {
                        if (!Trace.isErrorEnabled()) break block13;
                        Trace.error((Object)JCSMPRB.BUNDLE.getStringSafely("CSMPResponseParser.unableToParseSeqNumForPacket"), (Throwable)e);
                    }
                }
                return;
            }
            if (eName.equals(SU_TAG_ADD_FLAG)) {
                String addFlag = CSMPResponseParser.this.getFirstAttributeValue(SU_ATT_VAL, attrs);
                boolean add = addFlag == null || !"0".equals(addFlag);
                this.m_packetBean.setAddFlag(add);
                return;
            }
            if (eName.equals(SU_TAG_FILTER_TAG)) {
                String filterFlag = CSMPResponseParser.this.getFirstAttributeValue(SU_ATT_VAL, attrs);
                boolean add = filterFlag == null || !"0".equals(filterFlag);
                this.m_packetBean.setFilterFlag(add);
                return;
            }
            if (eName.equals(SU_TAG_SUBCRIPTION)) {
                this.m_packetBean.setSubscriptionXpe(CSMPResponseParser.this.getFirstAttributeValue(SU_ATT_XPE, attrs));
                return;
            }
        }
    }

    protected class SUSubscriberCtrlHandler
    extends DefaultHandler {
        public static final String SU_ATT_VAL = "val";
        public static final String SU_TAG_RESPONSE = "SubscriberControlInfoResponse";
        public static final String SU_TAG_ISOK = "isOk";
        public static final String SU_TAG_VERSION = "subCtrlVersion";
        public static final String SU_TAG_REFRESH_REQUIRED = "refreshRequired";
        public static final String SU_TAG_MCAST_ADDRESS = "mcastUdpAddress";
        public static final String SU_TAG_MCAST_PORT = "mcastUdpPort";
        public static final String SU_TAG_SUBSCRIBERId = "subscriberId";
        private SUSubscriberCtrlBean m_subCtrlBean = null;

        protected SUSubscriberCtrlHandler() {
        }

        @Override
        public void startDocument() {
            this.m_subCtrlBean = null;
        }

        public SUSubscriberCtrlBean getSUSubCtrlBean() {
            return this.m_subCtrlBean;
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) {
            String eName = lName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (eName.equals(SU_TAG_RESPONSE)) {
                this.m_subCtrlBean = new SUSubscriberCtrlBean();
                return;
            }
            if (eName.equals(SU_TAG_ISOK)) {
                this.m_subCtrlBean.setIsOK(CSMPResponseParser.this.getFirstAttributeValue(SU_ATT_VAL, attrs));
                return;
            }
            if (eName.equals(SU_TAG_VERSION)) {
                this.m_subCtrlBean.setVersion(CSMPResponseParser.this.getFirstAttributeValue(SU_ATT_VAL, attrs));
                return;
            }
            if (eName.equals(SU_TAG_REFRESH_REQUIRED)) {
                String valFlag = CSMPResponseParser.this.getFirstAttributeValue(SU_ATT_VAL, attrs);
                boolean val = valFlag == null || !"0".equals(valFlag);
                this.m_subCtrlBean.setRefreshRequired(val);
                return;
            }
            if (eName.equals(SU_TAG_MCAST_ADDRESS)) {
                String val = CSMPResponseParser.this.getFirstAttributeValue(SU_ATT_VAL, attrs);
                this.m_subCtrlBean.setMulticastIP(val);
                return;
            }
            if (eName.equals(SU_TAG_MCAST_PORT)) {
                String val = CSMPResponseParser.this.getFirstAttributeValue(SU_ATT_VAL, attrs);
                this.m_subCtrlBean.setMulticastPort(Integer.parseInt(val));
                return;
            }
            if (eName.equals(SU_TAG_SUBSCRIBERId)) {
                String val = CSMPResponseParser.this.getFirstAttributeValue(SU_ATT_VAL, attrs);
                this.m_subCtrlBean.setSubscriberId(Short.parseShort(val));
                return;
            }
        }
    }

    public static final class SUPacketBean {
        private int m_sequenceNumber = -1;
        private boolean m_addFlag = true;
        private boolean m_filterFlag = false;
        private String m_failureReason;
        private String m_subscriptionXpe;

        public String getFailureReason() {
            return this.m_failureReason;
        }

        public void setFailureReason(String failureReason) {
            this.m_failureReason = failureReason;
        }

        public String getSubscriptionXpe() {
            return this.m_subscriptionXpe;
        }

        public void setSubscriptionXpe(String subscriptionXpe) {
            this.m_subscriptionXpe = subscriptionXpe;
        }

        public int getSequenceNumber() {
            return this.m_sequenceNumber;
        }

        public void setSequenceNumber(int sequenceNumber) {
            this.m_sequenceNumber = sequenceNumber;
        }

        public boolean isAddFlag() {
            return this.m_addFlag;
        }

        public void setAddFlag(boolean addFlag) {
            this.m_addFlag = addFlag;
        }

        public boolean isFilterFlag() {
            return this.m_filterFlag;
        }

        public void setFilterFlag(boolean filterFlag) {
            this.m_filterFlag = filterFlag;
        }
    }

    public static final class SUResponseBean {
        private String m_isOK = "0";
        private String m_entirePacketRejectionReason = null;
        private List<SUPacketBean> m_subscriptionPacketResponseList = null;

        public List<SUPacketBean> getSubscriptionPacketResponseList() {
            return this.m_subscriptionPacketResponseList;
        }

        public void addPacketResponse(SUPacketBean responseBean) {
            if (this.m_subscriptionPacketResponseList == null) {
                this.m_subscriptionPacketResponseList = new ArrayList<SUPacketBean>();
            }
            this.m_subscriptionPacketResponseList.add(responseBean);
        }

        public String getEntirePacketRejectionReason() {
            return this.m_entirePacketRejectionReason;
        }

        public void setEntirePacketRejectionReason(String entirePacketRejectionReason) {
            this.m_entirePacketRejectionReason = entirePacketRejectionReason;
        }

        public String getIsOK() {
            return this.m_isOK;
        }

        public void setIsOK(String isOK) {
            this.m_isOK = isOK;
        }
    }

    public static final class SUSubscriberCtrlBean {
        private String m_isOK = "0";
        private String version;
        private boolean m_refreshRequired = false;
        private String multicastIP;
        private int multicastPort;
        private short subscriberId;

        public boolean isOK() {
            return this.m_isOK.equalsIgnoreCase(CSMPResponseParser.OK_TRUE);
        }

        public String getIsOK() {
            return this.m_isOK;
        }

        public void setIsOK(String isOK) {
            this.m_isOK = isOK;
        }

        public boolean isRefreshRequired() {
            return this.m_refreshRequired;
        }

        public void setRefreshRequired(boolean refreshRequired) {
            this.m_refreshRequired = refreshRequired;
        }

        public int getMulticastPort() {
            return this.multicastPort;
        }

        public void setMulticastPort(int multicastPort) {
            this.multicastPort = multicastPort;
        }

        public String getMulticastIP() {
            return this.multicastIP;
        }

        public void setMulticastIP(String multicastIP) {
            this.multicastIP = multicastIP;
        }

        public short getSubscriberId() {
            return this.subscriberId;
        }

        public void setSubscriberId(short subscriberId) {
            this.subscriberId = subscriberId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

