/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireDecoder;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.NetworkIOUtil;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import java.io.IOException;
import java.io.InputStream;

public class AssuredCtrlHeaderDecoder
implements WireDecoder {
    @Override
    public void decodeHeader(InputStream in, HeaderDescriptionBean headerBean) throws IOException {
        int msgType;
        if (!(headerBean instanceof AssuredCtrlHeaderBean)) {
            throw new IllegalArgumentException();
        }
        AssuredCtrlHeaderBean h = (AssuredCtrlHeaderBean)headerBean;
        int hdrLenWords = 0;
        int reportedLenBytes = 0;
        int bytesRead = 0;
        byte[] onebyte = new byte[1];
        byte[] twobytes = new byte[2];
        byte[] fourbytes = new byte[4];
        NetworkIOUtil.readDataSafely(in, onebyte, 0, 1);
        long onebyteLong = NetworkByteOrderNumberUtil.oneByteToUInt(onebyte[0]);
        h.setAssuredCtrlVersion((int)BitTwiddleUtil.extractBits(onebyteLong, 6L, 0L));
        if (h.getAssuredCtrlVersion() == 3 || h.getAssuredCtrlVersion() == 4) {
            NetworkIOUtil.readDataSafely(in, onebyte, 0, 1);
            onebyteLong = NetworkByteOrderNumberUtil.oneByteToUInt(onebyte[0]);
            msgType = (int)onebyteLong;
            h.setMsgType(msgType);
            NetworkIOUtil.readDataSafely(in, fourbytes, 0, 4);
            reportedLenBytes = (int)NetworkByteOrderNumberUtil.fourByteToUInt(fourbytes);
            bytesRead += 6;
        } else {
            NetworkIOUtil.readDataSafely(in, twobytes, 0, 2);
            long twobytesLong = NetworkByteOrderNumberUtil.twoByteToUInt(twobytes);
            msgType = (int)BitTwiddleUtil.extractBits(twobytesLong, 4L, 12L);
            h.setMsgType(msgType);
            hdrLenWords = (int)BitTwiddleUtil.extractBits(twobytesLong, 12L, 0L);
            reportedLenBytes = hdrLenWords * 4;
            bytesRead += 3;
        }
        int guard = 100;
        while (bytesRead < reportedLenBytes) {
            bytesRead = TlvCoderUtil.readTlvParam(in, bytesRead, reportedLenBytes, h, AssuredCtrlHeaderParameters.KNOWN_PARAMS);
            if (guard-- > 0) continue;
            throw new IOException("Error parsing parameters, invalid message.");
        }
    }
}

