/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.jcsmp.protocol.impl.SeqNumAbstractAllocator;
import java.util.concurrent.atomic.AtomicLong;

public class SeqNum63bAllocator
extends SeqNumAbstractAllocator {
    private AtomicLong _atomLong = new AtomicLong(0L);

    public SeqNum63bAllocator(String namepart) {
        super(namepart);
    }

    @Override
    public void reset() {
        this._atomLong.set(0L);
    }

    @Override
    public int getNext24b() {
        long low24b = BitTwiddleUtil.extractBits(this._atomLong.getAndIncrement(), 24L, 0L);
        return (int)low24b;
    }

    @Override
    public long getNext63b() {
        return this._atomLong.getAndIncrement();
    }

    @Override
    public void setTo(long value) {
        if (this._atomLong.get() <= 1L) {
            this._atomLong.set(value);
        }
    }

    @Override
    public void setToNoCheck(long value) {
        this._atomLong.set(value);
    }
}

