/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubscriptionMatchEntry<T> {
    private static final Log Trace = LogFactory.getLog(SubscriptionMatchEntry.class);
    private byte[] mMatch;
    private List<T> mEntries;

    public SubscriptionMatchEntry(byte[] match, List<T> entries) {
        this.mMatch = match;
        if (entries == null) {
            if (Trace.isErrorEnabled()) {
                Trace.error((Object)"Null entries found in a match");
            }
            this.mEntries = new ArrayList<T>();
        } else {
            this.mEntries = new ArrayList<T>(entries.size());
            for (int i = 0; i < entries.size(); ++i) {
                this.mEntries.add(entries.get(i));
            }
        }
    }

    public boolean equals(SubscriptionMatchEntry<T> another) {
        return this.mMatch.equals(another.getMatch()) && this.mEntries.equals(another.getEntries());
    }

    public byte[] getMatch() {
        return this.mMatch;
    }

    public List<T> getEntries() {
        return this.mEntries;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("match = \"");
        bldr.append(new String(this.mMatch, Charset.forName("UTF-8")));
        bldr.append("\", entries = [");
        if (this.mEntries == null) {
            bldr.append("null");
        } else {
            for (int i = 0; i < this.mEntries.size(); ++i) {
                if (i > 0) {
                    bldr.append(",");
                }
                bldr.append(this.mEntries.get(i));
            }
        }
        bldr.append("]");
        return bldr.toString();
    }
}

