/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.common.SolReserved;
import com.solacesystems.jcsmp.JCSMPProperties;

public class ProducerFlowProperties {
    protected int windowSize = 255;
    private boolean isRtrWindowedAck = true;
    private String ackEventMode = "SUPPORTED_ACK_EVENT_MODE_PER_MSG";
    private Boolean isGenerateSenderId;
    private Boolean isGenerateSendTimeStamp;
    private Boolean isGenerateSequenceNumber;
    private Boolean isCalculateMessageExpiration;
    private Boolean isPubMultiThreaded;
    private Integer pubAckTime;

    public ProducerFlowProperties() {
    }

    public ProducerFlowProperties(JCSMPProperties props) {
        this.windowSize = props.getIntegerProperty("pub_ack_window_size");
        this.isRtrWindowedAck = props.getBooleanProperty("ad_pub_router_windowed_ack");
        this.ackEventMode = props.getStringProperty("ACK_EVENT_MODE");
    }

    public ProducerFlowProperties(ProducerFlowProperties tocopy) {
        this();
        if (tocopy != null) {
            this.windowSize = tocopy.windowSize;
            this.isRtrWindowedAck = tocopy.isRtrWindowedAck;
            this.ackEventMode = tocopy.ackEventMode;
            this.isGenerateSenderId = tocopy.isGenerateSenderId;
            this.isGenerateSendTimeStamp = tocopy.isGenerateSendTimeStamp;
            this.isGenerateSequenceNumber = tocopy.isGenerateSequenceNumber;
            this.isCalculateMessageExpiration = tocopy.isCalculateMessageExpiration;
            this.isPubMultiThreaded = tocopy.isPubMultiThreaded;
            this.pubAckTime = tocopy.pubAckTime;
        }
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public ProducerFlowProperties setWindowSize(int windowSize) {
        if (windowSize < 1 || windowSize > 255) {
            throw new IllegalArgumentException(String.format("Illegal window size %d, must be in the range [1,255]", windowSize));
        }
        this.windowSize = windowSize;
        return this;
    }

    @SolReserved
    public boolean isRtrWindowedAck() {
        return this.isRtrWindowedAck;
    }

    @SolReserved
    public ProducerFlowProperties setRtrWindowedAck(boolean isRtrWindowedAck) {
        this.isRtrWindowedAck = isRtrWindowedAck;
        return this;
    }

    @SolReserved
    public String getAckEventMode() {
        return this.ackEventMode;
    }

    @SolReserved
    public ProducerFlowProperties setAckEventMode(String ackEventMode) {
        this.ackEventMode = ackEventMode;
        return this;
    }

    @SolReserved
    public Boolean isGenerateSenderId() {
        return this.isGenerateSenderId;
    }

    @SolReserved
    public ProducerFlowProperties setGenerateSenderId(Boolean generateSenderId) {
        this.isGenerateSenderId = generateSenderId;
        return this;
    }

    @SolReserved
    public Boolean isGenerateSendTimeStamp() {
        return this.isGenerateSendTimeStamp;
    }

    @SolReserved
    public ProducerFlowProperties setGenerateSendTimeStamp(Boolean generateSendTimeStamp) {
        this.isGenerateSendTimeStamp = generateSendTimeStamp;
        return this;
    }

    @SolReserved
    public Boolean isGenerateSequenceNumber() {
        return this.isGenerateSequenceNumber;
    }

    @SolReserved
    public ProducerFlowProperties setGenerateSequenceNumber(Boolean generateSequenceNumber) {
        this.isGenerateSequenceNumber = generateSequenceNumber;
        return this;
    }

    @SolReserved
    public Boolean isCalculateMessageExpiration() {
        return this.isCalculateMessageExpiration;
    }

    @SolReserved
    public ProducerFlowProperties setCalculateMessageExpiration(Boolean calculateMessageExpiration) {
        this.isCalculateMessageExpiration = calculateMessageExpiration;
        return this;
    }

    @SolReserved
    public Boolean isPubMultiThreaded() {
        return this.isPubMultiThreaded;
    }

    @SolReserved
    public ProducerFlowProperties setPubMultiThreaded(Boolean pubMultiThreaded) {
        this.isPubMultiThreaded = pubMultiThreaded;
        return this;
    }

    @SolReserved
    public Integer getPubAckTime() {
        return this.pubAckTime;
    }

    @SolReserved
    public ProducerFlowProperties setPubAckTime(Integer pubAckTime) {
        if (pubAckTime < 20 || pubAckTime > 60000) {
            throw new IllegalArgumentException(String.format("Illegal Publisher Ack Time %d, must be in the range [20,60000]", pubAckTime));
        }
        this.pubAckTime = pubAckTime;
        return this;
    }
}

