/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import com.solacesystems.common.util.NetworkByteOrderNumberUtil;

public class TLVParameter {
    protected byte[] mTag;
    protected byte[] mLength;
    protected byte[] mValue;

    public TLVParameter(byte[] tag, byte[] length, byte[] value) {
        if (tag == null || length == null || value == null) {
            throw new IllegalArgumentException("Illegal value for TLV: null");
        }
        this.mTag = tag;
        this.mLength = length;
        this.mValue = value;
    }

    public TLVParameter(int tagLength, int lengthLength, byte[] data, int offset) {
        if (tagLength <= 0) {
            throw new IllegalArgumentException("illegal value for tagLength: " + tagLength);
        }
        if (lengthLength <= 0) {
            throw new IllegalArgumentException("illegal value for lengthLength: " + lengthLength);
        }
        if (data == null) {
            throw new IllegalArgumentException("Illegal value for data: null");
        }
        int tlSize = tagLength + lengthLength;
        int dataSize = data.length - offset;
        if (tlSize > dataSize) {
            throw new IllegalArgumentException("Not enough data for tlv");
        }
        int index = offset;
        this.mTag = new byte[tagLength];
        System.arraycopy(data, index, this.mTag, 0, tagLength);
        this.mLength = new byte[lengthLength];
        System.arraycopy(data, index += tagLength, this.mLength, 0, lengthLength);
        index += lengthLength;
        int totalLength = this.getLengthAsInt();
        int valueLength = totalLength - tagLength - lengthLength;
        if (valueLength < 0) {
            throw new IllegalArgumentException("Illegal tlv length specified");
        }
        if (totalLength > dataSize) {
            throw new IllegalArgumentException("Not enough data for tlv");
        }
        this.mValue = new byte[valueLength];
        System.arraycopy(data, index, this.mValue, 0, valueLength);
    }

    public byte[] getTag() {
        return this.mTag;
    }

    public int getTagAsInt() {
        return NetworkByteOrderNumberUtil.oneTwoThreeFourByteToInt(this.mTag);
    }

    public byte[] getLength() {
        return this.mLength;
    }

    public int getLengthAsInt() {
        return NetworkByteOrderNumberUtil.oneTwoThreeFourByteToInt(this.mLength);
    }

    public byte[] getValue() {
        return this.mValue;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        builder.append("(Tag: ");
        builder.append(this.getTagAsInt());
        builder.append(", Length: ");
        builder.append(this.getLengthAsInt());
        builder.append(", Value: [");
        for (int i = 0; i < this.mValue.length; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(this.mValue[i]);
        }
        builder.append("])");
        return builder.toString();
    }
}

