/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

public class ByteArray {
    protected byte[] mBuffer;
    protected int mOffset;
    protected int mLength;
    protected int mHash;

    public ByteArray(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public ByteArray(byte[] buffer, int offset, int length) {
        this.validate(buffer, offset, length);
        this.mBuffer = buffer;
        this.mOffset = offset;
        this.mLength = length;
        this.mHash = 0;
    }

    public byte[] getBuffer() {
        return this.mBuffer;
    }

    public int getLength() {
        return this.mLength;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public byte[] asBytes() {
        if (this.mOffset == 0 && this.mLength == this.mBuffer.length) {
            return this.mBuffer;
        }
        byte[] ba = new byte[this.mLength];
        System.arraycopy(this.mBuffer, this.mOffset, ba, 0, this.mLength);
        return ba;
    }

    public int hashCode() {
        int h = this.mHash;
        if (h == 0) {
            for (int i = 0; i < this.mLength; ++i) {
                h = 31 * h + this.mBuffer[this.mOffset + i];
            }
            this.mHash = h;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteArray) {
            ByteArray other = (ByteArray)obj;
            if (this.mLength != other.mLength) {
                return false;
            }
            for (int i = 0; i < this.mLength; ++i) {
                if (this.mBuffer[this.mOffset + i] == other.mBuffer[other.mOffset + i]) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof byte[]) {
            byte[] other = (byte[])obj;
            if (this.mLength != other.length) {
                return false;
            }
            for (int i = 0; i < this.mLength; ++i) {
                if (this.mBuffer[this.mOffset + i] == other[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.mBuffer == null) {
            return "null";
        }
        StringBuilder bldr = new StringBuilder();
        int len = this.mLength;
        if (this.mLength > 100) {
            len = 100;
        }
        for (int i = 0; i < len; ++i) {
            if (i == 0) {
                bldr.append("[");
            }
            bldr.append(this.mBuffer[this.mOffset + i]);
            if (i == len - 1) {
                bldr.append("]");
                continue;
            }
            bldr.append(",");
        }
        bldr.append(" (offset=");
        bldr.append(this.mOffset);
        bldr.append(", length=");
        bldr.append(this.mLength);
        bldr.append(")");
        return bldr.toString();
    }

    private void validate(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        if (length > 0) {
            if (offset < 0 || offset >= buffer.length) {
                throw new IllegalArgumentException("illegal offset value - " + offset);
            }
            if (length < 0 || offset + length > buffer.length) {
                throw new IllegalArgumentException("illegal offset/length, offset=" + offset + ", length=" + length);
            }
        }
    }
}

