/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import java.security.InvalidParameterException;
import java.util.EnumMap;
import java.util.Map;

public class Base85 {
    private static final String ADOBE_CHARSET = "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstu";
    private static final String SOLACE_CHARSET = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!#$%&()+,-.:;<=@[^_{|}~";
    private static Map<Version, Base85> instances = new EnumMap<Version, Base85>(Version.class);
    private final Version version;

    private Base85(Version version) {
        this.version = version;
        if (version.encodeCharacters.length() != 85) {
            throw new InvalidParameterException("Requested version has invalid number of encode characters.");
        }
        if (version.compressZero && version.encodeCharacters.contains("z")) {
            throw new InvalidParameterException("Requested version requires compression but contains the letter 'z' in its alphabet.");
        }
    }

    public static Base85 getInstance(Version version) {
        Base85 instance = instances.get((Object)version);
        if (instance == null) {
            instance = new Base85(version);
            instances.put(version, instance);
        }
        return instance;
    }

    private static long getPadded(byte[] bytes, int index) {
        if (index < bytes.length) {
            return (long)bytes[index] & 0xFFL;
        }
        return 0L;
    }

    public String encode(byte[] inputBytes) {
        return this.encode(inputBytes, 0, inputBytes.length);
    }

    public String encode(byte[] inputBytes, int start) {
        return this.encode(inputBytes, start, inputBytes.length);
    }

    public String encode(byte[] inputBytes, int start, int end) {
        int BASE = 85;
        int BASESQUARED = 7225;
        int BASECUBED = 614125;
        int BASEFOURTH = 52200625;
        if (inputBytes == null) {
            throw new InvalidParameterException("Invalid input, input can not be null");
        }
        if (end > inputBytes.length) {
            end = inputBytes.length;
        }
        if (end < start || start > inputBytes.length) {
            throw new InvalidParameterException("Invalid start-end interval.");
        }
        if (!this.version.allowPadding && (end - start) % 4 != 0) {
            throw new InvalidParameterException("Invalid input, length must be divisible by 4. Use padding encoder if appropriate.");
        }
        StringBuilder strBuilder = new StringBuilder();
        for (int i = start; i < end; i += 4) {
            long x = Base85.getPadded(inputBytes, i) << 24 | Base85.getPadded(inputBytes, i + 1) << 16 | Base85.getPadded(inputBytes, i + 2) << 8 | Base85.getPadded(inputBytes, i + 3);
            if (this.version.compressZero && x == 0L && i + 3 < end) {
                strBuilder.append("z");
                continue;
            }
            int B0 = (int)(x / 52200625L);
            int B1 = (int)(x / 614125L) % 85;
            int B2 = (int)(x / 7225L) % 85;
            int B3 = (int)(x / 85L) % 85;
            int B4 = (int)(x % 85L);
            strBuilder.append(this.version.encodeCharacters.charAt(B0));
            strBuilder.append(this.version.encodeCharacters.charAt(B1));
            if (i + 1 >= end) break;
            strBuilder.append(this.version.encodeCharacters.charAt(B2));
            if (i + 2 >= end) break;
            strBuilder.append(this.version.encodeCharacters.charAt(B3));
            if (i + 3 >= end) break;
            strBuilder.append(this.version.encodeCharacters.charAt(B4));
        }
        return strBuilder.toString();
    }

    public static enum Version {
        ADOBE_PADDING_COMPRESSION_VERSION("!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstu", true, true),
        ADOBE_VERSION("!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstu", false, false),
        SOLACE_TOPIC_SAFE_VERSION("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!#$%&()+,-.:;<=@[^_{|}~", true, false);

        public String encodeCharacters;
        public boolean allowPadding;
        public boolean compressZero;

        private Version(String encodeCharacters, boolean allowPadding, boolean compressZero) {
            this.encodeCharacters = encodeCharacters;
            this.allowPadding = allowPadding;
            this.compressZero = compressZero;
        }
    }
}

