/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.expect;

import com.solacesystems.common.expect.ConfigurationMatcher;
import com.solacesystems.common.expect.ExceptionMatcher;
import com.solacesystems.common.expect.Expect;
import com.solacesystems.common.expect.Outcome;
import com.solacesystems.common.expect.UnexpectedException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ExpectDatabase {
    private HashMap<String, ExpectDatabaseEntry> mDB = new HashMap();
    private String[] mSearchPkgPrefixs;

    public ExpectDatabase(String[] searchPkgPrefixs) {
        this.mSearchPkgPrefixs = searchPkgPrefixs;
    }

    public void add(String name, Outcome outcome, ConfigurationMatcher configurationMatcher) {
        this.add(name, outcome, configurationMatcher, null);
    }

    public void add(String name, Outcome outcome, ConfigurationMatcher configurationMatcher, ExceptionMatcher exceptionMatcher) {
        if ((outcome == Outcome.Failure || outcome == Outcome.Success) && exceptionMatcher != null) {
            throw new IllegalArgumentException("An exception matcher can only be specified with an outcome of exception");
        }
        if (outcome == Outcome.Exception && exceptionMatcher == null) {
            throw new IllegalArgumentException("An exception matcher must be specified for outcomes of exception");
        }
        ExpectDatabaseEntry entry = new ExpectDatabaseEntry();
        entry.name = name;
        entry.outcome = outcome;
        entry.configurationMatcher = configurationMatcher;
        entry.exceptionMatcher = exceptionMatcher;
        this.mDB.put(name, entry);
    }

    public void remove(String name) {
        this.mDB.remove(name);
    }

    public void clear() {
        this.mDB.clear();
    }

    public String handleSuccess(Object ctx) throws UnexpectedException {
        List<ExpectDatabaseEntry> expectEntries = this.getExpectDatabaseEntries();
        Iterator<ExpectDatabaseEntry> it = expectEntries.iterator();
        String matchingExpect = null;
        while (it.hasNext()) {
            ExpectDatabaseEntry expectEntry = it.next();
            if (!expectEntry.configurationMatcher.configurationMatches(ctx)) continue;
            if (expectEntry.outcome == Outcome.Success) {
                matchingExpect = expectEntry.name;
                continue;
            }
            throw new UnexpectedException("Matched \"" + expectEntry.name + "\", but outcome \"" + (Object)((Object)Outcome.Success) + "\" didn't match expected outcome of \"" + (Object)((Object)expectEntry.outcome) + "\"");
        }
        return matchingExpect;
    }

    public String handleFailure(Object ctx) throws UnexpectedException {
        List<ExpectDatabaseEntry> expectEntries = this.getExpectDatabaseEntries();
        for (ExpectDatabaseEntry expectEntry : expectEntries) {
            if (!expectEntry.configurationMatcher.configurationMatches(ctx)) continue;
            if (expectEntry.outcome == Outcome.Failure) {
                return expectEntry.name;
            }
            throw new UnexpectedException("Matched \"" + expectEntry.name + "\", but outcome \"" + (Object)((Object)Outcome.Failure) + "\" didn't match expected outcome of \"" + (Object)((Object)expectEntry.outcome) + "\"");
        }
        throw new UnexpectedException("Failure did not match any expectations");
    }

    public String handleException(Object ctx, Exception e) throws UnexpectedException {
        List<ExpectDatabaseEntry> expectEntries = this.getExpectDatabaseEntries();
        for (ExpectDatabaseEntry expectEntry : expectEntries) {
            if (!expectEntry.configurationMatcher.configurationMatches(ctx)) continue;
            if (expectEntry.outcome == Outcome.Exception) {
                if (expectEntry.exceptionMatcher.exceptionMatches(e)) {
                    return expectEntry.name;
                }
                throw new UnexpectedException("Matched \"" + expectEntry.name + "\", but thrown exception didn't match expected exception", e);
            }
            throw new UnexpectedException("Matched \"" + expectEntry.name + "\", but outcome \"" + (Object)((Object)Outcome.Exception) + "\" didn't match expected outcome of \"" + (Object)((Object)expectEntry.outcome) + "\"", e);
        }
        throw new UnexpectedException("Exception did not match any expectations", e);
    }

    public List<ExpectDatabaseEntry> getExpectDatabaseEntries() {
        ArrayList<ExpectDatabaseEntry> expectEntries = new ArrayList<ExpectDatabaseEntry>();
        if (this.mSearchPkgPrefixs != null) {
            try {
                Throwable t = new Throwable();
                t.fillInStackTrace();
                StackTraceElement[] elements = t.getStackTrace();
                block2: for (int i = 0; i < elements.length; ++i) {
                    for (int j = 0; j < this.mSearchPkgPrefixs.length; ++j) {
                        if (!elements[i].getClassName().startsWith(this.mSearchPkgPrefixs[j])) continue;
                        Class<?> testClass = Class.forName(elements[i].getClassName());
                        Method[] methods = testClass.getMethods();
                        for (int k = 0; k < methods.length; ++k) {
                            if (!methods[k].getName().equals(elements[i].getMethodName())) continue;
                            this.getExpectDatabaseEntries(methods[k].getAnnotation(Expect.class), expectEntries);
                            if (expectEntries.size() != 0) continue;
                            this.getExpectDatabaseEntries(testClass.getAnnotation(Expect.class), expectEntries);
                        }
                        continue block2;
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return expectEntries;
    }

    public void getExpectDatabaseEntries(Expect expect, List<ExpectDatabaseEntry> expectEntries) {
        String[] expectStrs;
        if (expect != null && (expectStrs = expect.value()) != null) {
            for (int i = 0; i < expectStrs.length; ++i) {
                ExpectDatabaseEntry entry = this.mDB.get(expectStrs[i]);
                if (entry == null) continue;
                expectEntries.add(entry);
            }
        }
    }

    public String toString() {
        return this.mDB.keySet().toString();
    }

    public static class ExpectDatabaseEntry {
        public String name;
        public Outcome outcome;
        public ConfigurationMatcher configurationMatcher;
        public ExceptionMatcher exceptionMatcher;

        public String toString() {
            return this.name;
        }
    }
}

