/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.bean;

import com.solacesystems.common.bean.SolsuiteBean;
import com.solacesystems.common.util.Arrays;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class SecureConnectionBean
extends SolsuiteBean {
    private static final long serialVersionUID = -5914635300981506324L;
    private String name = "";
    private String file;
    private String password;
    private String[] ciphers;
    private static String[] defaultCiphers;

    public SecureConnectionBean(String name, String file, String password, String[] ciphers) {
        this.name = name;
        this.file = file;
        this.password = password;
        this.ciphers = ciphers;
    }

    public String getKey() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String[] getDefaultCiphers() {
        return Arrays.copyOf(defaultCiphers);
    }

    public String[] getCiphers() {
        return this.ciphers;
    }

    public void setCiphers(String[] ciphers) {
        this.ciphers = ciphers;
    }

    public String getFile() {
        return this.file;
    }

    public URL getFileURL() throws MalformedURLException {
        return new URL(this.file);
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        return this.name + "\nFile: " + this.file + "\nPassword: " + this.password + "\nCiphers:\n[" + this.ciphersToString() + "]";
    }

    public String ciphersToString() {
        String result = "";
        if (this.ciphers.length > 0) {
            for (int i = 0; i < this.ciphers.length; ++i) {
                result = result + this.ciphers[i] + ",";
            }
            return result.substring(0, result.length() - 1);
        }
        return "";
    }

    static {
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1");
            ctx.init(null, null, null);
            SSLSocketFactory sf = ctx.getSocketFactory();
            defaultCiphers = sf.getSupportedCipherSuites();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

