/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.trace.propagation.impl;

import com.solace.messaging.trace.propagation.TraceContext;
import com.solacesystems.common.SolReserved;
import com.solacesystems.common.util.ByteArray;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.common.util.SolByteBuffer;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
@SolReserved
public class TraceContextImpl
implements TraceContext,
Serializable {
    private static final Log Trace = LogFactory.getLog(TraceContextImpl.class);
    private int version = 16;
    private byte[] traceId16byte;
    private byte[] spanId8byte;
    private boolean sampled;
    private String traceState;
    public static final byte[] INVALID_CONTEXT = new byte[0];
    public static final int TRACE_ID_BYTES_LENGTH = 16;
    public static final int SPAN_ID_BYTES_LENGTH = 8;
    public static final int MAX_TRACE_STATE_LENGTH = 512;

    public static TraceContextImpl from(ByteArray content) {
        if (content == null) {
            return null;
        }
        if (content.getLength() < 32) {
            return null;
        }
        try {
            byte[] traceContextBytes = content.asBytes();
            int bytesRead = 0;
            TraceContextImpl traceContext = new TraceContextImpl();
            traceContext.sampled = false;
            traceContext.traceId16byte = new byte[16];
            traceContext.spanId8byte = new byte[8];
            byte byte1 = traceContextBytes[0];
            traceContext.version = byte1 & 0xF;
            traceContext.sampled = (byte1 & 4) == 4;
            System.arraycopy(traceContextBytes, ++bytesRead, traceContext.traceId16byte, 0, traceContext.traceId16byte.length);
            System.arraycopy(traceContextBytes, bytesRead += traceContext.traceId16byte.length, traceContext.spanId8byte, 0, traceContext.spanId8byte.length);
            bytesRead += traceContext.spanId8byte.length;
            ++bytesRead;
            byte[] traceStateLength = new byte[2];
            System.arraycopy(traceContextBytes, bytesRead += 4, traceStateLength, 0, traceStateLength.length);
            bytesRead += traceStateLength.length;
            long traceStateLengthInt = NetworkByteOrderNumberUtil.twoByteToUInt(traceStateLength);
            if (traceStateLengthInt > 0L) {
                byte[] traceState = new byte[(int)traceStateLengthInt];
                System.arraycopy(traceContextBytes, bytesRead, traceState, 0, traceState.length);
                traceContext.traceState = new String(traceState, StandardCharsets.UTF_8);
            }
            return traceContext;
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] getEncodedTraceContext() {
        if (this.traceId16byte == null || this.spanId8byte == null) {
            return null;
        }
        if (this.traceId16byte.length != 16) {
            Trace.error((Object)"Discarding tracing information, the traceId is not valid");
            return INVALID_CONTEXT;
        }
        if (this.spanId8byte.length != 8) {
            Trace.error((Object)"Discarding tracing information, the spanId is not valid");
            return INVALID_CONTEXT;
        }
        int traceStateLength = this.traceState == null ? 0 : this.traceState.length();
        SolByteBuffer contentBuffer = new SolByteBuffer(32 + traceStateLength);
        int byte1 = 0;
        byte1 |= this.version;
        contentBuffer.write(NetworkByteOrderNumberUtil.intToOneByte(byte1 |= this.sampled ? 4 : 0));
        contentBuffer.write(this.traceId16byte);
        contentBuffer.write(this.spanId8byte);
        contentBuffer.write(NetworkByteOrderNumberUtil.intToOneByte(1));
        contentBuffer.write(NetworkByteOrderNumberUtil.intToFourByte(0L));
        if (this.traceState == null) {
            contentBuffer.write(NetworkByteOrderNumberUtil.intToTwoByte(0));
        } else {
            String truncatedTraceState = this.getTruncatedTraceState();
            if (truncatedTraceState != null) {
                contentBuffer.write(NetworkByteOrderNumberUtil.intToTwoByte(truncatedTraceState.length()));
                contentBuffer.write(truncatedTraceState.getBytes(StandardCharsets.UTF_8));
            }
        }
        return contentBuffer.asByteArray().asBytes();
    }

    public void setTraceIdBytes16(byte[] traceId16byte) {
        this.traceId16byte = traceId16byte;
    }

    @Override
    public byte[] getTraceIdBytes16() {
        return this.traceId16byte;
    }

    public String getTraceIdHex32() {
        byte[] b16 = this.getTraceIdBytes16();
        if (b16 == null || b16.length != 16) {
            return null;
        }
        char[] result = CachedBuffer.chars(32);
        Base16Encoder.bytesToBase16(b16, result, 16);
        return new String(result, 0, 32);
    }

    public void setSpanIdBytes8(byte[] spanId8byte) {
        this.spanId8byte = spanId8byte;
    }

    @Override
    public byte[] getSpanIdBytes8() {
        return this.spanId8byte;
    }

    public String getSpanIdHex16() {
        byte[] b8 = this.getSpanIdBytes8();
        if (b8 == null || b8.length != 8) {
            return null;
        }
        char[] result = CachedBuffer.chars(16);
        Base16Encoder.bytesToBase16(b8, result, 8);
        return new String(result, 0, 16);
    }

    public void setSampled(boolean sampled) {
        this.sampled = sampled;
    }

    @Override
    public boolean isSampled() {
        return this.sampled;
    }

    public void setTraceState(String traceState) {
        this.traceState = traceState;
    }

    @Override
    public String getTraceState() {
        return this.traceState;
    }

    private String getTruncatedTraceState() {
        return this.standardTraceStateTruncation(512);
    }

    private String standardTraceStateTruncation(int maxTraceStateLength) {
        if (this.traceState == null) {
            return null;
        }
        if (this.traceState.length() < maxTraceStateLength) {
            return this.traceState;
        }
        StringBuilder traceStateBuilder = new StringBuilder();
        String[] listMembers = this.traceState.split(",");
        ArrayList<String> ignoredMembers = new ArrayList<String>();
        for (String listMember : listMembers) {
            int curMemberLength;
            if (listMember == null) continue;
            if (listMember.length() >= 128) {
                ignoredMembers.add(listMember);
                continue;
            }
            int curTraceStateLength = traceStateBuilder.length();
            int newExpectedLength = curTraceStateLength + (curMemberLength = listMember.length()) + (curTraceStateLength > 0 ? 1 : 0);
            if (newExpectedLength <= maxTraceStateLength) {
                if (curTraceStateLength > 0) {
                    traceStateBuilder.append(",");
                }
                traceStateBuilder.append(listMember);
                continue;
            }
            ignoredMembers.add(listMember);
        }
        for (int i = 0; i < ignoredMembers.size(); ++i) {
            String currentMember;
            int curMemberLength;
            int curTraceStateLength = traceStateBuilder.length();
            int newExpectedLength = curTraceStateLength + (curMemberLength = (currentMember = (String)ignoredMembers.get(i)).length()) + (curTraceStateLength > 0 ? 1 : 0);
            if (newExpectedLength > maxTraceStateLength) continue;
            if (curTraceStateLength > 0) {
                traceStateBuilder.append(",");
            }
            traceStateBuilder.append(currentMember);
        }
        return traceStateBuilder.toString();
    }

    private String simpleTraceStateTruncation(int maxTraceStateLength) {
        if (this.traceState == null) {
            return null;
        }
        if (this.traceState.length() < maxTraceStateLength) {
            return this.traceState;
        }
        String truncatedTraceState = this.traceState.substring(0, maxTraceStateLength);
        int indexOfLastComma = truncatedTraceState.lastIndexOf(",");
        if (indexOfLastComma < maxTraceStateLength) {
            truncatedTraceState = truncatedTraceState.substring(0, indexOfLastComma);
        }
        return truncatedTraceState;
    }

    public String toString() {
        return "{traceId=" + this.getTraceIdHex32() + ", spanId=" + this.getSpanIdHex16() + ", sampled=" + this.sampled + ", traceState=" + (this.traceState == null ? "}" : "'" + this.traceState + "'}");
    }

    private static final class CachedBuffer {
        private static final ThreadLocal<char[]> CHAR_ARRAY = new ThreadLocal();

        public static char[] chars(int len) {
            char[] buffer = CHAR_ARRAY.get();
            if (buffer == null || buffer.length < len) {
                buffer = new char[len];
                CHAR_ARRAY.set(buffer);
            }
            return buffer;
        }

        static void clearChars() {
            CHAR_ARRAY.set(null);
        }

        private CachedBuffer() {
        }
    }

    private static final class Base16Encoder {
        static final int LONG_BYTES = 8;
        static final int BYTE_BASE16 = 2;
        static final int LONG_BASE16 = 16;
        private static final String ALPHABET = "0123456789abcdef";
        private static final int NUM_ASCII_CHARACTERS = 128;
        private static final char[] ENCODING = Base16Encoder.buildEncodingArray();
        private static final byte[] DECODING = Base16Encoder.buildDecodingArray();
        private static final boolean[] VALID_HEX = Base16Encoder.buildValidHexArray();

        private static char[] buildEncodingArray() {
            char[] encoding = new char[512];
            for (int i = 0; i < 256; ++i) {
                encoding[i] = ALPHABET.charAt(i >>> 4);
                encoding[i | 0x100] = ALPHABET.charAt(i & 0xF);
            }
            return encoding;
        }

        private static byte[] buildDecodingArray() {
            byte[] decoding = new byte[128];
            Arrays.fill(decoding, (byte)-1);
            for (int i = 0; i < ALPHABET.length(); ++i) {
                char c = ALPHABET.charAt(i);
                decoding[c] = (byte)i;
            }
            return decoding;
        }

        private static boolean[] buildValidHexArray() {
            boolean[] validHex = new boolean[65535];
            for (int i = 0; i < 65535; ++i) {
                validHex[i] = 48 <= i && i <= 57 || 97 <= i && i <= 102;
            }
            return validHex;
        }

        public static long longFromBase16String(CharSequence chars, int offset) {
            return ((long)Base16Encoder.byteFromBase16(chars.charAt(offset), chars.charAt(offset + 1)) & 0xFFL) << 56 | ((long)Base16Encoder.byteFromBase16(chars.charAt(offset + 2), chars.charAt(offset + 3)) & 0xFFL) << 48 | ((long)Base16Encoder.byteFromBase16(chars.charAt(offset + 4), chars.charAt(offset + 5)) & 0xFFL) << 40 | ((long)Base16Encoder.byteFromBase16(chars.charAt(offset + 6), chars.charAt(offset + 7)) & 0xFFL) << 32 | ((long)Base16Encoder.byteFromBase16(chars.charAt(offset + 8), chars.charAt(offset + 9)) & 0xFFL) << 24 | ((long)Base16Encoder.byteFromBase16(chars.charAt(offset + 10), chars.charAt(offset + 11)) & 0xFFL) << 16 | ((long)Base16Encoder.byteFromBase16(chars.charAt(offset + 12), chars.charAt(offset + 13)) & 0xFFL) << 8 | (long)Base16Encoder.byteFromBase16(chars.charAt(offset + 14), chars.charAt(offset + 15)) & 0xFFL;
        }

        public static void longToBase16String(long value, char[] dest, int destOffset) {
            Base16Encoder.byteToBase16((byte)(value >> 56 & 0xFFL), dest, destOffset);
            Base16Encoder.byteToBase16((byte)(value >> 48 & 0xFFL), dest, destOffset + 2);
            Base16Encoder.byteToBase16((byte)(value >> 40 & 0xFFL), dest, destOffset + 4);
            Base16Encoder.byteToBase16((byte)(value >> 32 & 0xFFL), dest, destOffset + 6);
            Base16Encoder.byteToBase16((byte)(value >> 24 & 0xFFL), dest, destOffset + 8);
            Base16Encoder.byteToBase16((byte)(value >> 16 & 0xFFL), dest, destOffset + 10);
            Base16Encoder.byteToBase16((byte)(value >> 8 & 0xFFL), dest, destOffset + 12);
            Base16Encoder.byteToBase16((byte)(value & 0xFFL), dest, destOffset + 14);
        }

        public static byte[] bytesFromBase16(CharSequence value, int length) {
            byte[] result = new byte[length / 2];
            for (int i = 0; i < length; i += 2) {
                result[i / 2] = Base16Encoder.byteFromBase16(value.charAt(i), value.charAt(i + 1));
            }
            return result;
        }

        public static void bytesToBase16(byte[] bytes, char[] dest, int length) {
            for (int i = 0; i < length; ++i) {
                Base16Encoder.byteToBase16(bytes[i], dest, i * 2);
            }
        }

        public static void byteToBase16(byte value, char[] dest, int destOffset) {
            int b = value & 0xFF;
            dest[destOffset] = ENCODING[b];
            dest[destOffset + 1] = ENCODING[b | 0x100];
        }

        public static byte byteFromBase16(char first, char second) {
            if (first >= '\u0080' || DECODING[first] == -1) {
                throw new IllegalArgumentException("invalid character " + first);
            }
            if (second >= '\u0080' || DECODING[second] == -1) {
                throw new IllegalArgumentException("invalid character " + second);
            }
            int decoded = DECODING[first] << 4 | DECODING[second];
            return (byte)decoded;
        }

        public static boolean isValidBase16String(CharSequence value) {
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char b = value.charAt(i);
                if (Base16Encoder.isValidBase16Character(b)) continue;
                return false;
            }
            return true;
        }

        public static boolean isValidBase16Character(char b) {
            return VALID_HEX[b];
        }

        private Base16Encoder() {
        }
    }
}

