/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import java.io.Serializable;
import java.nio.charset.Charset;

public class ByteBuffer
implements Serializable {
    private static final long serialVersionUID = 5087570236702703703L;
    protected int mInitialSize;
    protected byte[] mBuffer;
    protected int mBufferSize;
    protected int mBufferCapacity;

    public ByteBuffer(int initialSize) {
        this.mInitialSize = initialSize;
        this.mBuffer = null;
        this.mBufferSize = 0;
        this.mBufferCapacity = 0;
    }

    public byte[] getBuffer() {
        return this.mBuffer;
    }

    public int getBufferSize() {
        return this.mBufferSize;
    }

    public int getBufferCapacity() {
        return this.mBufferCapacity;
    }

    public void clear() {
        this.mBufferSize = 0;
    }

    public void appendByte(byte aByte) {
        while (this.mBufferSize + 1 > this.mBufferCapacity) {
            this.realloc();
        }
        this.mBuffer[this.mBufferSize] = aByte;
        ++this.mBufferSize;
    }

    public void appendBytes(byte[] bytes) {
        while (this.mBufferSize + bytes.length > this.mBufferCapacity) {
            this.realloc();
        }
        System.arraycopy(bytes, 0, this.mBuffer, this.mBufferSize, bytes.length);
        this.mBufferSize += bytes.length;
    }

    public void appendBytes(byte[] bytes, int offset, int length) {
        while (this.mBufferSize + length > this.mBufferCapacity) {
            this.realloc();
        }
        System.arraycopy(bytes, offset, this.mBuffer, this.mBufferSize, length);
        this.mBufferSize += length;
    }

    public void appendString(String str) {
        char c;
        int i;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        str.getChars(0, strlen, charr, 0);
        for (i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        this.realloc(this.mBufferSize + utflen);
        for (i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                this.mBuffer[this.mBufferSize++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.mBuffer[this.mBufferSize++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.mBuffer[this.mBufferSize++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.mBuffer[this.mBufferSize++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.mBuffer[this.mBufferSize++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.mBuffer[this.mBufferSize++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    public void realloc(int size) {
        if (this.mBufferCapacity < size) {
            this.mBufferCapacity = size;
            byte[] newBuffer = new byte[this.mBufferCapacity];
            if (this.mBuffer != null && this.mBufferSize > 0) {
                System.arraycopy(this.mBuffer, 0, newBuffer, 0, this.mBufferSize);
            }
            this.mBuffer = newBuffer;
        }
    }

    protected void realloc() {
        this.mBufferCapacity = this.mBufferCapacity == 0 ? this.mInitialSize : (this.mBufferCapacity += this.mBufferCapacity);
        byte[] newBuffer = new byte[this.mBufferCapacity];
        if (this.mBuffer != null && this.mBufferSize > 0) {
            System.arraycopy(this.mBuffer, 0, newBuffer, 0, this.mBufferSize);
        }
        this.mBuffer = newBuffer;
    }

    public String toString() {
        if (this.mBufferSize == 0) {
            return "";
        }
        return new String(this.mBuffer, 0, this.mBufferSize, Charset.forName("UTF-8"));
    }
}

